/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.handler.BaseActionModuleHandler;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.events.ItemCommandEvent;
import org.openhab.core.items.events.ItemEventFactory;
import org.openhab.core.types.Command;
import org.openhab.core.types.TypeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ItemCommandActionHandler
extends BaseActionModuleHandler {
    public static final String ITEM_COMMAND_ACTION = "core.ItemCommandAction";
    public static final String ITEM_NAME = "itemName";
    public static final String COMMAND = "command";
    private final Logger logger = LoggerFactory.getLogger(ItemCommandActionHandler.class);
    private final EventPublisher eventPublisher;
    private final ItemRegistry itemRegistry;

    public ItemCommandActionHandler(Action module, EventPublisher eventPublisher, ItemRegistry itemRegistry) {
        super(module);
        this.eventPublisher = eventPublisher;
        this.itemRegistry = itemRegistry;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public @Nullable Map<String, Object> execute(Map<String, Object> inputs) {
        block9: {
            String itemName = (String)((Action)this.module).getConfiguration().get(ITEM_NAME);
            String command = (String)((Action)this.module).getConfiguration().get(COMMAND);
            if (itemName != null) {
                try {
                    Item item = this.itemRegistry.getItem(itemName);
                    Command commandObj = null;
                    if (command != null) {
                        commandObj = TypeParser.parseCommand((List)item.getAcceptedCommandTypes(), (String)command);
                    } else {
                        Object cmd = inputs.get(COMMAND);
                        Object object = cmd;
                        if (object instanceof Command) {
                            Command command2 = (Command)object;
                            Command cfr_ignored_0 = (Command)object;
                            if (item.getAcceptedCommandTypes().contains(cmd.getClass())) {
                                void command1;
                                commandObj = command1;
                            }
                        }
                    }
                    if (commandObj != null) {
                        ItemCommandEvent itemCommandEvent = ItemEventFactory.createCommandEvent((String)itemName, (Command)commandObj);
                        this.logger.debug("Executing ItemCommandAction on Item {} with Command {}", (Object)itemCommandEvent.getItemName(), (Object)itemCommandEvent.getItemCommand());
                        this.eventPublisher.post((Event)itemCommandEvent);
                        break block9;
                    }
                    this.logger.debug("Command '{}' is not valid for item '{}'.", (Object)command, (Object)itemName);
                }
                catch (ItemNotFoundException e) {
                    this.logger.error("Item with name {} not found in ItemRegistry.", (Object)itemName);
                }
            } else {
                this.logger.error("Command was not posted because either the configuration was not correct or a service was missing: ItemName: {}, Command: {}, eventPublisher: {}, ItemRegistry: {}", new Object[]{itemName, command, this.eventPublisher, this.itemRegistry});
            }
        }
        return null;
    }
}

