/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.lib.annotations;

import com.google.common.annotations.Beta;
import java.util.Objects;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtend.lib.annotations.ToStringConfiguration;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableElement;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Beta
public class ToStringProcessor
extends AbstractClassProcessor {
    public void doTransform(MutableClassDeclaration it, @Extension TransformationContext context) {
        boolean _tripleNotEquals;
        AnnotationReference _findAnnotation = it.findAnnotation(context.findTypeGlobally(Data.class));
        boolean bl = _tripleNotEquals = _findAnnotation != null;
        if (_tripleNotEquals) {
            return;
        }
        Util util = new Util(context);
        AnnotationReference annotation = it.findAnnotation(context.findTypeGlobally(ToString.class));
        ToStringConfiguration configuration = new ToStringConfiguration(annotation);
        boolean _hasToString = util.hasToString((ClassDeclaration)it);
        if (_hasToString) {
            context.addWarning((Element)annotation, "toString is already defined, this annotation has no effect.");
        } else {
            TypeReference _object;
            boolean _notEquals;
            TypeReference _extendedClass = it.getExtendedClass();
            boolean bl2 = _notEquals = !Objects.equals(_extendedClass, _object = context.getObject());
            if (_notEquals) {
                util.addReflectiveToString(it, configuration);
            } else {
                Functions.Function1 _function = it_1 -> context.isThePrimaryGeneratedJavaElement((Element)it_1) && !it_1.isStatic() && !it_1.isTransient();
                util.addToString(it, IterableExtensions.filter((Iterable)it.getDeclaredFields(), (Functions.Function1)_function), configuration);
            }
        }
    }

    @Beta
    public static class Util {
        @Extension
        private TransformationContext context;

        public Util(TransformationContext context) {
            this.context = context;
        }

        public boolean hasToString(ClassDeclaration it) {
            MethodDeclaration _findDeclaredMethod = it.findDeclaredMethod("toString", new TypeReference[0]);
            return _findDeclaredMethod != null;
        }

        public ToStringConfiguration getToStringConfig(ClassDeclaration it) {
            ToStringConfiguration _xblockexpression = null;
            AnnotationReference anno = it.findAnnotation(this.context.findTypeGlobally(ToString.class));
            ToStringConfiguration _xifexpression = null;
            _xifexpression = anno == null ? null : new ToStringConfiguration(anno);
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        public void addReflectiveToString(MutableClassDeclaration cls, final ToStringConfiguration config) {
            Procedures.Procedure1 _function = it -> {
                this.context.setPrimarySourceElement((MutableElement)it, this.context.getPrimarySourceElement((Element)cls));
                it.setReturnType(this.context.getString());
                it.addAnnotation(this.context.newAnnotationReference(Override.class));
                it.addAnnotation(this.context.newAnnotationReference(Pure.class));
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return new ");
                        _builder.append(ToStringBuilder.class);
                        _builder.append((Object)"(this)");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)".addAllFields()");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        boolean _isSkipNulls = config.isSkipNulls();
                        if (_isSkipNulls) {
                            _builder.append((Object)".skipNulls()");
                        }
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        boolean _isSingleLine = config.isSingleLine();
                        if (_isSingleLine) {
                            _builder.append((Object)".singleLine()");
                        }
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        boolean _isHideFieldNames = config.isHideFieldNames();
                        if (_isHideFieldNames) {
                            _builder.append((Object)".hideFieldNames()");
                        }
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        boolean _isVerbatimValues = config.isVerbatimValues();
                        if (_isVerbatimValues) {
                            _builder.append((Object)".verbatimValues()");
                        }
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)".toString();");
                        _builder.newLine();
                    }
                };
                it.setBody(_client);
            };
            cls.addMethod("toString", _function);
        }

        public void addToString(MutableClassDeclaration cls, final Iterable<? extends FieldDeclaration> fields, final ToStringConfiguration config) {
            Procedures.Procedure1 _function = it -> {
                this.context.setPrimarySourceElement((MutableElement)it, this.context.getPrimarySourceElement((Element)cls));
                it.setReturnType(this.context.getString());
                it.addAnnotation(this.context.newAnnotationReference(Override.class));
                it.addAnnotation(this.context.newAnnotationReference(Pure.class));
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append(ToStringBuilder.class);
                        _builder.append((Object)" b = new ");
                        _builder.append(ToStringBuilder.class);
                        _builder.append((Object)"(this);");
                        _builder.newLineIfNotEmpty();
                        boolean _isSkipNulls = config.isSkipNulls();
                        if (_isSkipNulls) {
                            _builder.append((Object)"b.skipNulls();");
                        }
                        _builder.newLineIfNotEmpty();
                        boolean _isSingleLine = config.isSingleLine();
                        if (_isSingleLine) {
                            _builder.append((Object)"b.singleLine();");
                        }
                        _builder.newLineIfNotEmpty();
                        boolean _isHideFieldNames = config.isHideFieldNames();
                        if (_isHideFieldNames) {
                            _builder.append((Object)"b.hideFieldNames();");
                        }
                        _builder.newLineIfNotEmpty();
                        boolean _isVerbatimValues = config.isVerbatimValues();
                        if (_isVerbatimValues) {
                            _builder.append((Object)"b.verbatimValues();");
                        }
                        _builder.newLineIfNotEmpty();
                        for (FieldDeclaration field : fields) {
                            _builder.append((Object)"b.add(\"");
                            String _simpleName = field.getSimpleName();
                            _builder.append((Object)_simpleName);
                            _builder.append((Object)"\", this.");
                            String _simpleName_1 = field.getSimpleName();
                            _builder.append((Object)_simpleName_1);
                            _builder.append((Object)");");
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append((Object)"return b.toString();");
                        _builder.newLine();
                    }
                };
                it.setBody(_client);
            };
            cls.addMethod("toString", _function);
        }
    }
}

