/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.header;

import aQute.bnd.header.OSGiHeader;
import aQute.bnd.stream.MapStream;
import aQute.bnd.version.Version;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Attrs
implements Map<String, String> {
    public static final DataType<String> STRING = () -> Type.STRING;
    public static final DataType<Long> LONG = () -> Type.LONG;
    public static final DataType<Double> DOUBLE = () -> Type.DOUBLE;
    public static final DataType<Version> VERSION = () -> Type.VERSION;
    public static final DataType<List<String>> LIST_STRING = () -> Type.STRINGS;
    public static final DataType<List<Long>> LIST_LONG = () -> Type.LONGS;
    public static final DataType<List<Double>> LIST_DOUBLE = () -> Type.DOUBLES;
    public static final DataType<List<Version>> LIST_VERSION = () -> Type.VERSIONS;
    public static final Pattern TYPED = Pattern.compile("List\\s*<\\s*(String|Version|Long|Double)\\s*>");
    private final Map<String, String> map;
    private final Map<String, Type> types;
    public static final Attrs EMPTY_ATTRS = new Attrs(Collections.emptyMap(), Collections.emptyMap());

    private Attrs(Map<String, String> map, Map<String, Type> types) {
        this.map = map;
        this.types = types;
    }

    public Attrs() {
        this(new LinkedHashMap<String, String>(), new HashMap<String, Type>());
    }

    public Attrs(Attrs ... attrs) {
        this();
        for (Attrs a : attrs) {
            if (a == null) continue;
            this.putAll(a);
        }
    }

    public Attrs(Attrs attrs) {
        this();
        this.putAll(attrs);
    }

    public Attrs(Map<? extends String, ? extends String> map) {
        this();
        if (map != null) {
            this.putAll(map);
        }
    }

    public void putAllTyped(Map<? extends String, ? extends Object> attrs) {
        attrs.forEach(this::putTyped);
    }

    public void putTyped(String key, Object value) {
        if (value == null) {
            this.put(key, null);
            return;
        }
        if (!(value instanceof String)) {
            Type type;
            if (value instanceof Collection) {
                value = ((Collection)value).toArray();
            }
            if (value.getClass().isArray()) {
                type = Type.STRINGS;
                int l = Array.getLength(value);
                StringBuilder sb = new StringBuilder();
                String del = "";
                boolean first = true;
                for (int i = 0; i < l; ++i) {
                    Object member = Array.get(value, i);
                    if (member == null) continue;
                    if (first) {
                        type = this.getObjectType(member).plural();
                        first = true;
                    }
                    sb.append(del);
                    sb.append(member);
                    for (int n = sb.length(); n < sb.length(); ++n) {
                        char c = sb.charAt(n);
                        if (c != '\\' && c != ',') continue;
                        sb.insert(n, '\\');
                        ++n;
                    }
                    del = ",";
                }
                value = sb;
            } else {
                type = this.getObjectType(value);
            }
            if (!key.endsWith(":")) {
                key = key + ":" + type.toString();
            }
        }
        this.put(key, value.toString());
    }

    private Type getObjectType(Object member) {
        if (member instanceof Double || member instanceof Float) {
            return Type.DOUBLE;
        }
        if (member instanceof Number) {
            return Type.LONG;
        }
        if (member instanceof Version) {
            return Type.VERSION;
        }
        return Type.STRING;
    }

    @Override
    public void clear() {
        this.map.clear();
        this.types.clear();
    }

    public boolean containsKey(String name) {
        return this.map.containsKey(name);
    }

    @Override
    @Deprecated
    public boolean containsKey(Object name) {
        assert (name instanceof String);
        return this.map.containsKey(name);
    }

    public boolean containsValue(String value) {
        return this.map.containsValue(value);
    }

    @Override
    @Deprecated
    public boolean containsValue(Object value) {
        assert (value instanceof String);
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.map.entrySet();
    }

    public MapStream<String, String> stream() {
        return MapStream.of(this);
    }

    @Override
    @Deprecated
    public String get(Object key) {
        assert (key instanceof String);
        return this.map.get(key);
    }

    public String get(String key) {
        return this.map.get(key);
    }

    public String get(String key, String deflt) {
        String s = this.get(key);
        if (s == null) {
            return deflt;
        }
        return s;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public String put(String key, String value) {
        if (key == null) {
            return null;
        }
        return this.map.put(this.putType(key), value);
    }

    private String putType(String key) {
        block33: {
            String type;
            int colon = key.indexOf(58);
            if (colon < 0 || (type = key.substring(colon + 1).trim()).isEmpty()) break block33;
            String attribute = key.substring(0, colon).trim();
            block11 : switch (type) {
                case "String": {
                    this.types.remove(attribute);
                    break;
                }
                case "Long": {
                    this.types.put(attribute, Type.LONG);
                    break;
                }
                case "Double": {
                    this.types.put(attribute, Type.DOUBLE);
                    break;
                }
                case "Version": {
                    this.types.put(attribute, Type.VERSION);
                    break;
                }
                case "List": 
                case "List<String>": {
                    this.types.put(attribute, Type.STRINGS);
                    break;
                }
                case "List<Long>": {
                    this.types.put(attribute, Type.LONGS);
                    break;
                }
                case "List<Double>": {
                    this.types.put(attribute, Type.DOUBLES);
                    break;
                }
                case "List<Version>": {
                    this.types.put(attribute, Type.VERSIONS);
                    break;
                }
                default: {
                    Matcher m = TYPED.matcher(type);
                    if (!m.matches()) break block33;
                    switch (m.group(1)) {
                        case "String": {
                            this.types.put(attribute, Type.STRINGS);
                            break block11;
                        }
                        case "Long": {
                            this.types.put(attribute, Type.LONGS);
                            break block11;
                        }
                        case "Double": {
                            this.types.put(attribute, Type.DOUBLES);
                            break block11;
                        }
                        case "Version": {
                            this.types.put(attribute, Type.VERSIONS);
                        }
                    }
                }
            }
            return attribute;
        }
        this.types.remove(key);
        return key;
    }

    public Type getType(String key) {
        Type t = this.types.get(key);
        if (t == null) {
            return Type.STRING;
        }
        return t;
    }

    public void putAll(Attrs attrs) {
        this.types.keySet().removeAll(attrs.map.keySet());
        this.map.putAll(attrs.map);
        this.types.putAll(attrs.types);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> other) {
        if (other instanceof Attrs) {
            this.putAll((Attrs)other);
            return;
        }
        other.forEach(this::put);
    }

    @Override
    @Deprecated
    public String remove(Object var0) {
        assert (var0 instanceof String);
        this.types.remove(var0);
        return this.map.remove(var0);
    }

    public String remove(String var0) {
        this.types.remove(var0);
        return this.map.remove(var0);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<String> values() {
        return this.map.values();
    }

    public String getVersion() {
        return this.get("version");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.append(sb);
        return sb.toString();
    }

    public void append(StringBuilder sb) {
        String del = "";
        for (Map.Entry<String, String> e : this.entrySet()) {
            sb.append(del);
            this.append(sb, e);
            del = ";";
        }
    }

    public void append(StringBuilder sb, Map.Entry<String, String> e) {
        this.append(sb, e.getKey(), e.getValue());
    }

    public String toString(String key) {
        StringBuilder sb = new StringBuilder();
        this.append(sb, key, this.get(key));
        return sb.toString();
    }

    private void append(StringBuilder sb, String key, String value) {
        sb.append(key);
        Type type = this.getType(key);
        if (type != Type.STRING) {
            sb.append(":").append((Object)type);
        }
        sb.append("=");
        OSGiHeader.quote(sb, value);
    }

    @Override
    @Deprecated
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    @Deprecated
    public int hashCode() {
        return super.hashCode();
    }

    public boolean isEqual(Attrs other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.size() != other.size()) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        if (!this.keySet().equals(other.keySet())) {
            return false;
        }
        for (String key : this.keySet()) {
            if (!Objects.equals(this.get(key), other.get(key))) {
                return false;
            }
            if (this.getType(key) == other.getType(key)) continue;
            return false;
        }
        return true;
    }

    public Object getTyped(String adname) {
        String s = this.get(adname);
        if (s == null) {
            return null;
        }
        Type t = this.getType(adname);
        return Attrs.convert(t, s);
    }

    public <T> T getTyped(DataType<T> type, String adname) {
        String s = this.get(adname);
        if (s == null) {
            return null;
        }
        Type t = this.getType(adname);
        if (t != type.type()) {
            throw new IllegalArgumentException("For key " + adname + ", expected " + (Object)((Object)type.type()) + " but had a " + (Object)((Object)t) + ". Value is " + s);
        }
        return (T)Attrs.convert(t, s);
    }

    public static Type toType(String type) {
        if (type == null) {
            return null;
        }
        for (Type t : Type.values()) {
            if (!t.toString.equals(type)) continue;
            return t;
        }
        return null;
    }

    public static Object convert(String t, String s) {
        if (s == null) {
            return null;
        }
        Type type = Attrs.toType(t);
        if (type == null) {
            return s;
        }
        return Attrs.convert(type, s);
    }

    public static Object convert(Type t, String s) {
        if (t.sub == null) {
            switch (t) {
                case STRING: {
                    return s;
                }
                case LONG: {
                    return Long.parseLong(s.trim());
                }
                case VERSION: {
                    return Version.parseVersion(s);
                }
                case DOUBLE: {
                    return Double.parseDouble(s.trim());
                }
                case DOUBLES: 
                case LONGS: 
                case STRINGS: 
                case VERSIONS: {
                    return null;
                }
            }
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        List<String> split = Attrs.splitListAttribute(s);
        for (String p : split) {
            list.add(Attrs.convert(t.sub, p));
        }
        return list;
    }

    static List<String> splitListAttribute(String input) throws IllegalArgumentException {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        block4: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\\': {
                    if (++i >= input.length()) {
                        throw new IllegalArgumentException("Trailing blackslash in multi-valued attribute value");
                    }
                    c = input.charAt(i);
                    builder.append(c);
                    continue block4;
                }
                case ',': {
                    result.add(builder.toString());
                    builder.setLength(0);
                    continue block4;
                }
                default: {
                    builder.append(c);
                }
            }
        }
        result.add(builder.toString());
        return result;
    }

    public void mergeWith(Attrs other, boolean override) {
        MapStream<String, String> stream = other.stream();
        if (!override) {
            stream = stream.filterKey(key -> !this.containsKey((String)key));
        }
        stream.peekKey(key -> {
            Type t = other.getType((String)key);
            if (t != Type.STRING) {
                this.types.put((String)key, t);
            } else {
                this.types.remove(key);
            }
        }).forEachOrdered(this.map::put);
    }

    public static String toDirective(String key) {
        if (key == null) {
            return null;
        }
        int last = key.length() - 1;
        return last >= 0 && key.charAt(last) == ':' ? key.substring(0, last) : null;
    }

    public static boolean isAttribute(String key) {
        return !Attrs.isDirective(key);
    }

    public static boolean isDirective(String key) {
        int last = key.length() - 1;
        return last >= 0 && key.charAt(last) == ':';
    }

    public static Attrs create(String key, String value) {
        Attrs attrs = new Attrs();
        attrs.put(key, value);
        return attrs;
    }

    public Attrs with(String key, String value) {
        this.put(key, value);
        return this;
    }

    public static enum Type {
        STRING(null, "String"),
        LONG(null, "Long"),
        VERSION(null, "Version"),
        DOUBLE(null, "Double"),
        STRINGS(STRING, "List<String>"),
        LONGS(LONG, "List<Long>"),
        VERSIONS(VERSION, "List<Version>"),
        DOUBLES(DOUBLE, "List<Double>");

        final Type sub;
        final String toString;

        private Type(Type sub, String toString) {
            this.sub = sub;
            this.toString = toString;
        }

        public String toString() {
            return this.toString;
        }

        public Type plural() {
            switch (this) {
                case DOUBLE: {
                    return DOUBLES;
                }
                case LONG: {
                    return LONGS;
                }
                case STRING: {
                    return STRINGS;
                }
                case VERSION: {
                    return VERSIONS;
                }
            }
            return null;
        }
    }

    public static interface DataType<T> {
        public Type type();
    }
}

