/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice.util;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

class InjectingMethodInterceptor
implements MethodInterceptor {
    private final Key<? extends MethodInterceptor> key;
    private volatile Injector injector = null;

    InjectingMethodInterceptor(Class<? extends MethodInterceptor> interceptorClass) {
        this.key = Key.get(interceptorClass);
    }

    InjectingMethodInterceptor(Key<? extends MethodInterceptor> key) {
        this.key = key;
    }

    @Inject
    void injectInterceptor(Injector newInjector) {
        this.injector = newInjector;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        MethodInterceptor interceptor;
        Injector inj = this.injector;
        MethodInterceptor methodInterceptor = interceptor = inj != null ? (MethodInterceptor)inj.getInstance(this.key) : null;
        if (interceptor == null) {
            return invocation.proceed();
        }
        return interceptor.invoke(invocation);
    }
}

