/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import nokogiri.XmlSaxParserContext;
import nokogiri.internals.ClosedStreamException;
import nokogiri.internals.NokogiriBlockingQueueInputStream;
import nokogiri.internals.NokogiriHandler;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.ParserContext;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Nokogiri::XML::SAX::PushParser"})
public class XmlSaxPushParser
extends RubyObject {
    private static final long serialVersionUID = 1L;
    ParserContext.Options options;
    IRubyObject saxParser;
    NokogiriBlockingQueueInputStream stream;
    private ParserTask parserTask = null;
    private FutureTask<XmlSaxParserContext> futureTask = null;
    private ExecutorService executor = null;
    RaiseException ex = null;
    private transient IRubyObject parse_options;

    public XmlSaxPushParser(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public void finalize() {
        try {
            this.terminateImpl();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @JRubyMethod
    public IRubyObject initialize_native(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.options = new ParserContext.Options(0L);
        this.saxParser = iRubyObject;
        return this;
    }

    private IRubyObject parse_options(ThreadContext threadContext) {
        if (this.parse_options == null) {
            this.parse_options = Helpers.invoke((ThreadContext)threadContext, (IRubyObject)threadContext.runtime.getClassFromPath("Nokogiri::XML::ParseOptions"), (String)"new");
        }
        return this.parse_options;
    }

    @JRubyMethod(name={"options"})
    public IRubyObject getOptions(ThreadContext threadContext) {
        return Helpers.invoke((ThreadContext)threadContext, (IRubyObject)this.parse_options(threadContext), (String)"options");
    }

    @JRubyMethod(name={"options="})
    public IRubyObject setOptions(ThreadContext threadContext, IRubyObject iRubyObject) {
        Helpers.invoke((ThreadContext)threadContext, (IRubyObject)this.parse_options(threadContext), (String)"options=", (IRubyObject)iRubyObject);
        this.options = new ParserContext.Options(iRubyObject.convertToInteger().getLongValue());
        return this.getOptions(threadContext);
    }

    @JRubyMethod(name={"replace_entities="})
    public IRubyObject setReplaceEntities(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this;
    }

    @JRubyMethod(name={"replace_entities"})
    public IRubyObject getReplaceEntities(ThreadContext threadContext) {
        return threadContext.getRuntime().getTrue();
    }

    @JRubyMethod
    public IRubyObject native_write(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (this.ex != null) {
            throw this.ex;
        }
        try {
            this.initialize_task(threadContext);
        }
        catch (IOException iOException) {
            throw threadContext.runtime.newRuntimeError(iOException.getMessage());
        }
        ByteArrayInputStream byteArrayInputStream = NokogiriHelpers.stringBytesToStream(iRubyObject);
        if (byteArrayInputStream == null) {
            return this;
        }
        int n = this.parserTask.getErrorCount();
        try {
            Future<Void> future = this.stream.addChunk(byteArrayInputStream);
            future.get();
        }
        catch (ClosedStreamException closedStreamException) {
        }
        catch (Exception exception) {
            throw threadContext.runtime.newRuntimeError(exception.toString());
        }
        if (iRubyObject2.isTrue()) {
            this.parserTask.getNokogiriHandler().endDocument();
            this.terminateTask(threadContext.runtime);
        }
        if (!this.options.recover && this.parserTask.getErrorCount() > n) {
            this.terminateTask(threadContext.runtime);
            this.ex = this.parserTask.getLastError().toThrowable();
            throw this.ex;
        }
        return this;
    }

    private void initialize_task(ThreadContext threadContext) throws IOException {
        if (this.futureTask == null || this.stream == null) {
            this.stream = new NokogiriBlockingQueueInputStream();
            assert (this.saxParser != null) : "saxParser null";
            this.parserTask = new ParserTask(threadContext, this.saxParser, this.stream);
            this.futureTask = new FutureTask<XmlSaxParserContext>(this.parserTask);
            this.executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable);
                    thread.setName("XmlSaxPushParser");
                    thread.setDaemon(true);
                    return thread;
                }
            });
            this.executor.submit(this.futureTask);
        }
    }

    private void terminateTask(Ruby ruby) {
        if (this.executor == null) {
            return;
        }
        try {
            this.terminateImpl();
        }
        catch (InterruptedException interruptedException) {
            throw ruby.newRuntimeError(interruptedException.toString());
        }
        catch (Exception exception) {
            throw ruby.newRuntimeError(exception.toString());
        }
    }

    private synchronized void terminateImpl() throws InterruptedException, ExecutionException {
        XmlSaxPushParser.terminateExecution(this.executor, this.stream, this.futureTask);
        this.executor = null;
        this.stream = null;
        this.futureTask = null;
    }

    static void terminateExecution(ExecutorService executorService, NokogiriBlockingQueueInputStream nokogiriBlockingQueueInputStream, FutureTask<?> futureTask) throws InterruptedException, ExecutionException {
        if (executorService == null) {
            return;
        }
        try {
            Future<Void> future = nokogiriBlockingQueueInputStream.addChunk(NokogiriBlockingQueueInputStream.END);
            future.get();
        }
        catch (ClosedStreamException closedStreamException) {
            // empty catch block
        }
        futureTask.cancel(true);
        executorService.shutdown();
    }

    private static XmlSaxParserContext parse(Ruby ruby, InputStream inputStream) {
        RubyClass rubyClass = NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::SAX::ParserContext");
        return XmlSaxParserContext.parse_stream(ruby, rubyClass, inputStream);
    }

    static class ParserTask
    extends ParserContext.ParserTask<XmlSaxParserContext> {
        final InputStream stream;

        private ParserTask(ThreadContext threadContext, IRubyObject iRubyObject, InputStream inputStream) {
            this(threadContext, iRubyObject, XmlSaxPushParser.parse(threadContext.runtime, inputStream), inputStream);
        }

        protected ParserTask(ThreadContext threadContext, IRubyObject iRubyObject, XmlSaxParserContext xmlSaxParserContext, InputStream inputStream) {
            super(threadContext, iRubyObject, xmlSaxParserContext);
            this.stream = inputStream;
        }

        @Override
        public XmlSaxParserContext call() throws Exception {
            try {
                ((XmlSaxParserContext)this.parser).parse_with(this.context, this.handler);
            }
            finally {
                this.stream.close();
            }
            return (XmlSaxParserContext)this.parser;
        }

        final NokogiriHandler getNokogiriHandler() {
            return ((XmlSaxParserContext)this.parser).getNokogiriHandler();
        }

        final synchronized int getErrorCount() {
            if (((XmlSaxParserContext)this.parser).getNokogiriErrorHandler() == null) {
                return 0;
            }
            return ((XmlSaxParserContext)this.parser).getNokogiriErrorHandler().getErrors().size();
        }

        final synchronized RubyException getLastError() {
            List<RubyException> list = ((XmlSaxParserContext)this.parser).getNokogiriErrorHandler().getErrors();
            return list.get(list.size() - 1);
        }
    }
}

