/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.health;

import java.util.Objects;
import org.logstash.Logstash;

public class HelpUrl {
    static final String BASE_URL;
    private final String page;
    private final String anchor;
    private transient String resolved;

    public HelpUrl(String page) {
        this(page, null);
    }

    public HelpUrl withAnchor(String anchor) {
        return new HelpUrl(this.page, anchor);
    }

    private HelpUrl(String page, String anchor) {
        Objects.requireNonNull(page, "page cannot be null");
        this.page = page;
        this.anchor = anchor;
    }

    public String toString() {
        if (this.resolved == null) {
            StringBuilder sb = new StringBuilder(BASE_URL);
            sb.append(this.page).append(".html");
            if (this.anchor != null) {
                sb.append("#").append(this.anchor);
            }
            this.resolved = sb.toString();
        }
        return this.resolved;
    }

    static {
        String versionAnchor = Integer.parseInt(Logstash.VERSION_MAJOR) >= 9 ? "master" : String.format("%s.%s", Logstash.VERSION_MAJOR, Logstash.VERSION_MINOR);
        BASE_URL = String.format("https://www.elastic.co/guide/en/logstash/%s/", versionAnchor);
    }
}

