/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;

public class DocAvailable
extends SystemFunctionCall
implements Callable {
    private String expressionBaseURI = null;

    public void bindStaticContext(StaticContext env) throws XPathException {
        this.expressionBaseURI = env.getBaseURI();
    }

    public String getStaticBaseURI() {
        return this.expressionBaseURI;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public Expression copy() {
        DocAvailable fn = (DocAvailable)super.copy();
        fn.expressionBaseURI = this.expressionBaseURI;
        return fn;
    }

    public boolean equals(Object o) {
        return super.equals(o) && DocAvailable.equalOrNull(this.expressionBaseURI, ((DocAvailable)o).expressionBaseURI);
    }

    public BooleanValue evaluateItem(XPathContext context) throws XPathException {
        AtomicValue hrefVal = (AtomicValue)this.argument[0].evaluateItem(context);
        return BooleanValue.get(this.isDocAvailable(hrefVal, context));
    }

    private boolean isDocAvailable(AtomicValue hrefVal, XPathContext context) throws XPathException {
        if (hrefVal == null) {
            return false;
        }
        String href = hrefVal.getStringValue();
        return this.docAvailable(href, context);
    }

    public BooleanValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        return BooleanValue.get(this.isDocAvailable((AtomicValue)arguments[0].head(), context));
    }

    public boolean docAvailable(String href, XPathContext context) throws XPathException {
        try {
            DocumentURI documentKey = DocumentFn.computeDocumentKey(href, this.expressionBaseURI, context);
            DocumentPool pool = context.getController().getDocumentPool();
            if (pool.isMarkedUnavailable(documentKey)) {
                return false;
            }
            DocumentInfo doc = pool.find(documentKey);
            if (doc != null) {
                return true;
            }
            NodeInfo item = DocumentFn.makeDoc(href, this.expressionBaseURI, context, this, true);
            if (item != null) {
                return true;
            }
            pool.markUnavailable(documentKey);
            return false;
        }
        catch (XPathException e) {
            return false;
        }
    }
}

