/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.util.ArrayList;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.sort.GenericSorter;
import net.sf.saxon.expr.sort.ItemOrderComparer;
import net.sf.saxon.expr.sort.Sortable;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;

public final class DocumentOrderIterator
implements SequenceIterator,
Sortable {
    private SequenceIterator iterator;
    private ArrayList<NodeInfo> sequence;
    private ItemOrderComparer comparer;
    private NodeInfo current = null;

    public DocumentOrderIterator(SequenceIterator base, ItemOrderComparer comparer) throws XPathException {
        NodeInfo node;
        this.comparer = comparer;
        int len = (base.getProperties() & 2) == 0 ? 50 : ((LastPositionFinder)((Object)base)).getLength();
        this.sequence = new ArrayList(len);
        while ((node = (NodeInfo)base.next()) != null) {
            this.sequence.add(node);
        }
        if (this.sequence.size() > 1) {
            GenericSorter.quickSort(0, this.sequence.size(), this);
        }
        this.iterator = new ListIterator(this.sequence);
    }

    private DocumentOrderIterator() {
    }

    public int compare(int a, int b) {
        return this.comparer.compare(this.sequence.get(a), this.sequence.get(b));
    }

    public void swap(int a, int b) {
        NodeInfo temp = this.sequence.get(a);
        this.sequence.set(a, this.sequence.get(b));
        this.sequence.set(b, temp);
    }

    public NodeInfo next() throws XPathException {
        NodeInfo next;
        do {
            if ((next = (NodeInfo)this.iterator.next()) != null) continue;
            this.current = null;
            return null;
        } while (this.current != null && next.isSameNodeInfo(this.current));
        this.current = next;
        return this.current;
    }

    public int getProperties() {
        return 0;
    }

    public void close() {
    }

    public DocumentOrderIterator getAnother() throws XPathException {
        DocumentOrderIterator another = new DocumentOrderIterator();
        another.iterator = this.iterator.getAnother();
        return another;
    }
}

