/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.trace.ContextStackIterator;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.value.DateTimeValue;

public class XPathContextMinor
implements XPathContext {
    Controller controller;
    FocusIterator currentIterator;
    LastValue last = null;
    SequenceReceiver currentReceiver;
    XPathContext caller = null;
    protected StackFrame stackFrame;
    protected String currentDestination = "";
    protected int temporaryOutputState = 0;
    XPathException currentException;

    protected XPathContextMinor() {
    }

    public XPathContextMajor newContext() {
        return XPathContextMajor.newContext(this);
    }

    public XPathContextMinor newMinorContext() {
        XPathContextMinor c = new XPathContextMinor();
        c.controller = this.controller;
        c.caller = this;
        c.currentIterator = this.currentIterator;
        c.currentReceiver = this.currentReceiver;
        c.last = this.last;
        c.stackFrame = this.stackFrame;
        c.currentException = this.currentException;
        c.currentDestination = this.currentDestination;
        c.temporaryOutputState = this.temporaryOutputState;
        return c;
    }

    public void setCaller(XPathContext caller) {
        this.caller = caller;
    }

    public XPathContextMajor newCleanContext() {
        XPathContextMajor c = new XPathContextMajor(this.getController());
        c.setCaller(this);
        return c;
    }

    public ParameterSet getLocalParameters() {
        return this.getCaller().getLocalParameters();
    }

    public ParameterSet getTunnelParameters() {
        return this.getCaller().getTunnelParameters();
    }

    public final Controller getController() {
        return this.controller;
    }

    public final Configuration getConfiguration() {
        return this.controller.getConfiguration();
    }

    public final NamePool getNamePool() {
        return this.controller.getConfiguration().getNamePool();
    }

    public final XPathContext getCaller() {
        return this.caller;
    }

    public void setCurrentIterator(FocusIterator iter) {
        this.currentIterator = iter;
        this.last = new LastValue(-1);
    }

    public final FocusIterator getCurrentIterator() {
        return this.currentIterator;
    }

    public final Item getContextItem() {
        if (this.currentIterator == null) {
            return null;
        }
        return this.currentIterator.current();
    }

    public final int getLast() throws XPathException {
        if (this.currentIterator == null) {
            XPathException e = new XPathException("The context item is absent, so last() is undefined");
            e.setXPathContext(this);
            e.setErrorCode("XPDY0002");
            throw e;
        }
        if (this.last.value >= 0) {
            return this.last.value;
        }
        if ((this.currentIterator.getProperties() & 2) == 0) {
            FocusIterator another = this.currentIterator.getAnother();
            int count = 0;
            while (another.next() != null) {
                ++count;
            }
            this.last.value = count;
            return this.last.value;
        }
        this.last.value = this.currentIterator.getLength();
        return this.last.value;
    }

    public final boolean isAtLast() throws XPathException {
        if ((this.currentIterator.getProperties() & 4) != 0) {
            return !((LookaheadIterator)((Object)this.currentIterator)).hasNext();
        }
        return this.currentIterator.position() == this.getLast();
    }

    public URIResolver getURIResolver() {
        return this.caller.getURIResolver();
    }

    public UnfailingErrorListener getErrorListener() {
        return this.caller.getErrorListener();
    }

    public Component getCurrentComponent() {
        return this.caller.getCurrentComponent();
    }

    public StackFrame getStackFrame() {
        return this.stackFrame;
    }

    public final Sequence evaluateLocalVariable(int slotnumber) {
        return this.stackFrame.slots[slotnumber];
    }

    public final void setLocalVariable(int slotnumber, Sequence value) {
        try {
            this.stackFrame.slots[slotnumber] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new AssertionError((Object)("Internal error: invalid slot number for local variable " + (slotnumber == -999 ? "(No slot allocated)" : "(" + slotnumber + ")")));
        }
    }

    public synchronized void notifyChildThreads() throws XPathException {
        this.getCaller().notifyChildThreads();
    }

    public void changeOutputDestination(Receiver receiver, ParseOptions options) throws XPathException {
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        ComplexContentOutputter out = new ComplexContentOutputter(pipe);
        out.setHostLanguage(pipe.getHostLanguage());
        NamespaceReducer ne = new NamespaceReducer(receiver);
        ne.setSystemId(receiver.getSystemId());
        receiver = ne;
        if (options != null && options.getSchemaValidationMode() != 3) {
            Configuration config = this.controller.getConfiguration();
            receiver = config.getDocumentValidator(ne, receiver.getSystemId(), options);
        }
        out.setReceiver(receiver);
        this.currentReceiver = out;
    }

    public void setReceiver(SequenceReceiver receiver) {
        this.currentReceiver = receiver;
    }

    public final SequenceReceiver getReceiver() {
        return this.currentReceiver;
    }

    public void setTemporaryOutputState(int temporary) {
        this.temporaryOutputState = temporary;
    }

    public int getTemporaryOutputState() {
        return this.temporaryOutputState;
    }

    public void setCurrentOutputUri(String uri) {
        this.currentDestination = uri;
    }

    public String getCurrentOutputUri() {
        return this.currentDestination;
    }

    public int useLocalParameter(StructuredQName parameterId, int slotNumber, boolean isTunnel) throws XPathException {
        return this.getCaller().useLocalParameter(parameterId, slotNumber, isTunnel);
    }

    public Mode getCurrentMode() {
        return this.getCaller().getCurrentMode();
    }

    public Rule getCurrentTemplateRule() {
        return null;
    }

    public GroupIterator getCurrentGroupIterator() {
        return this.getCaller().getCurrentGroupIterator();
    }

    public GroupIterator getCurrentMergeGroupIterator() {
        return this.getCaller().getCurrentMergeGroupIterator();
    }

    public RegexIterator getCurrentRegexIterator() {
        return this.getCaller().getCurrentRegexIterator();
    }

    public DateTimeValue getCurrentDateTime() {
        return this.controller.getCurrentDateTime();
    }

    public final int getImplicitTimezone() {
        return this.controller.getImplicitTimezone();
    }

    public Iterator iterateStackFrames() {
        return new ContextStackIterator(this);
    }

    public void setCurrentException(XPathException exception) {
        this.currentException = exception;
    }

    public XPathException getCurrentException() {
        return this.currentException;
    }

    public Component getTargetComponent(int bindingSlot) {
        return this.getCaller().getTargetComponent(bindingSlot);
    }

    protected static class LastValue {
        public int value = 0;

        public LastValue(int count) {
            this.value = count;
        }
    }
}

