/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ingest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.logstash.ingest.IngestConverter;
import org.logstash.ingest.JsUtil;

public class IngestDate {
    public static String toLogstash(String json, boolean appendStdio) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        HashMap<String, Object> jsonDefinition = mapper.readValue(json, typeRef);
        List processors = (List)jsonDefinition.get("processors");
        List<String> filters_pipeline = processors.stream().map(IngestDate::mapProcessor).collect(Collectors.toList());
        return IngestConverter.filtersToFile(IngestConverter.appendIoPlugins(filters_pipeline, appendStdio));
    }

    private static String mapProcessor(Map processor) {
        return IngestConverter.filterHash(IngestConverter.createHash("date", IngestDate.dateHash(processor)));
    }

    static String dateHash(Map<String, Map> processor) {
        Map date_json = processor.get("date");
        List formats = (List)date_json.get("formats");
        String firstElem = IngestConverter.dotsToSquareBrackets((String)date_json.get("field"));
        ArrayList<String> match_contents = new ArrayList<String>();
        match_contents.add(firstElem);
        for (String f : formats) {
            match_contents.add(f);
        }
        String date_contents = IngestConverter.createField("match", IngestConverter.createPatternArray(match_contents.toArray(new String[0])));
        if (JsUtil.isNotEmpty((String)date_json.get("target_field"))) {
            String target = IngestConverter.createField("target", IngestConverter.quoteString(IngestConverter.dotsToSquareBrackets((String)date_json.get("target_field"))));
            date_contents = IngestConverter.joinHashFields(date_contents, target);
        }
        if (JsUtil.isNotEmpty((String)date_json.get("timezone"))) {
            String timezone = IngestConverter.createField("timezone", IngestConverter.quoteString((String)date_json.get("timezone")));
            date_contents = IngestConverter.joinHashFields(date_contents, timezone);
        }
        if (JsUtil.isNotEmpty((String)date_json.get("locale"))) {
            String locale = IngestConverter.createField("locale", IngestConverter.quoteString((String)date_json.get("locale")));
            date_contents = IngestConverter.joinHashFields(date_contents, locale);
        }
        return date_contents;
    }

    public static boolean has_date(Map<String, Object> processor) {
        return processor.containsKey("date");
    }
}

