/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.sort;

import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.impl.store.access.sort.MergeSort;
import org.apache.derby.impl.store.access.sort.SortBuffer;
import org.apache.derby.impl.store.access.sort.SortScan;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class SortBufferScan
extends SortScan {
    protected SortBuffer sortBuffer;

    SortBufferScan(MergeSort sort, TransactionManager tran, SortBuffer sortBuffer, boolean hold) {
        super(sort, tran, hold);
        SanityManager.ASSERT((sortBuffer != null ? 1 : 0) != 0);
        this.sortBuffer = sortBuffer;
    }

    @Override
    public boolean next() throws StandardException {
        SanityManager.ASSERT((this.sortBuffer != null ? 1 : 0) != 0, (String)"next() called on scan after scan was closed.");
        this.current = this.sortBuffer.removeFirst();
        return this.current != null;
    }

    @Override
    public boolean closeForEndTransaction(boolean closeHeldScan) {
        if (closeHeldScan || !this.hold) {
            this.close();
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        if (this.sort != null) {
            this.sort.doneScanning(this, this.sortBuffer);
            this.sortBuffer = null;
        }
        super.close();
    }
}

