/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.bytecode;

import org.apache.derby.impl.services.bytecode.BCMethod;
import org.apache.derby.impl.services.bytecode.CodeChunk;
import org.apache.derby.impl.services.bytecode.Type;
import org.apache.derby.shared.common.sanity.SanityManager;

class Conditional {
    private static final int BRANCH16LIMIT = Short.MAX_VALUE;
    private final Conditional parent;
    private final int if_pc;
    private Type[] stack;
    private int thenGoto_pc;

    Conditional(Conditional parent, CodeChunk chunk, short ifOpcode, Type[] entryStack) {
        this.parent = parent;
        this.if_pc = chunk.getPC();
        this.stack = entryStack;
        chunk.addInstrU2(ifOpcode, 0);
    }

    Type[] startElse(BCMethod mb, CodeChunk chunk, Type[] thenStack) {
        chunk.addInstrU2((short)167, 0);
        this.fillIn(mb, chunk, this.if_pc, chunk.getPC());
        this.thenGoto_pc = chunk.getPC() - 3;
        Type[] entryStack = this.stack;
        this.stack = thenStack;
        return entryStack;
    }

    Conditional end(BCMethod mb, CodeChunk chunk, Type[] elseStack, int stackNumber) {
        int branch_pc = this.thenGoto_pc == 0 ? this.if_pc : this.thenGoto_pc;
        this.fillIn(mb, chunk, branch_pc, chunk.getPC());
        if (stackNumber != this.stack.length) {
            StringBuilder sb = new StringBuilder();
            sb.append("ByteCode Conditional then/else stack depths differ then:" + this.stack.length + " else: " + stackNumber);
            sb.append("\nif stack:\n");
            for (Type t : this.stack) {
                sb.append(t);
                sb.append('\n');
            }
            sb.append("else stack:\n");
            for (int i = 0; i < stackNumber; ++i) {
                Type t = elseStack[i];
                sb.append(t);
                sb.append('\n');
            }
            SanityManager.THROWASSERT((String)sb.toString());
        }
        for (int i = 0; i < stackNumber; ++i) {
            if (this.stack[i].vmType() == elseStack[i].vmType() || this.stack[i].vmName().equals(elseStack[i].vmName())) continue;
            SanityManager.THROWASSERT((String)("ByteCode Conditional then/else stack mismatch: then: " + this.stack[i].vmName() + " else: " + elseStack[i].vmName()));
        }
        return this.parent;
    }

    private void fillIn(BCMethod mb, CodeChunk chunk, int branch_pc, int target_pc) {
        int offset = target_pc - branch_pc;
        if (offset <= 0) {
            SanityManager.THROWASSERT((String)("Conditional branch zero or negative " + offset));
        }
        short branchOpcode = chunk.getOpcode(branch_pc);
        if (offset <= Short.MAX_VALUE) {
            CodeChunk mod = chunk.insertCodeSpace(branch_pc, 0);
            mod.addInstrU2(branchOpcode, offset);
            return;
        }
        if (branchOpcode == 167) {
            CodeChunk mod = chunk.insertCodeSpace(branch_pc, 2);
            mod.addInstrU4((short)200, offset += 2);
            int startElse_pc = mod.getPC();
            int branchOffset = startElse_pc - this.if_pc;
            if (branchOffset <= 32769) {
                this.fillIn(mb, chunk, this.if_pc, mod.getPC());
                return;
            }
            mod = chunk.insertCodeSpace(this.if_pc + 3, 0);
            mod.addInstrU4((short)200, branchOffset -= 3);
            return;
        }
        if (target_pc + 5 >= 65535) {
            mb.cb.addLimitExceeded(mb, "branch_target", 65535, target_pc + 5);
        }
        switch (branchOpcode) {
            case 199: {
                branchOpcode = 198;
                break;
            }
            case 153: {
                branchOpcode = 154;
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("Conditional does not handle opcode " + branchOpcode));
            }
        }
        CodeChunk mod = chunk.insertCodeSpace(branch_pc, 5);
        mod.addInstrU2(branchOpcode, 8);
        mod.addInstrU4((short)200, offset += 2);
    }
}

