/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.action.mappings;

import java.util.logging.Logger;
import org.aesh.readline.InputProcessor;
import org.aesh.readline.action.Action;
import org.aesh.readline.action.KeyAction;
import org.aesh.readline.action.SearchAction;
import org.aesh.readline.action.mappings.BackwardChar;
import org.aesh.readline.action.mappings.BeginningOfLine;
import org.aesh.readline.action.mappings.DeletePrevChar;
import org.aesh.readline.action.mappings.EndOfLine;
import org.aesh.readline.action.mappings.Enter;
import org.aesh.readline.action.mappings.ForwardChar;
import org.aesh.readline.action.mappings.ForwardSearchHistory;
import org.aesh.readline.action.mappings.Interrupt;
import org.aesh.readline.action.mappings.NextHistory;
import org.aesh.readline.action.mappings.PrevHistory;
import org.aesh.readline.action.mappings.ReverseSearchHistory;
import org.aesh.readline.history.SearchDirection;
import org.aesh.readline.terminal.Key;
import org.aesh.readline.util.IntArrayBuilder;
import org.aesh.readline.util.LoggerUtil;
import org.aesh.readline.util.Parser;
import org.aesh.terminal.utils.ANSI;

abstract class SearchHistory
implements SearchAction {
    private SearchAction.Status status = SearchAction.Status.SEARCH_NOT_STARTED;
    private IntArrayBuilder searchArgument;
    private int[] searchResult;
    private SearchAction.Status defaultAction;
    private static final int[] REVERSE_SEARCH_TEXT = Parser.toCodePoints("(reverse-i-search) `");
    private static final int[] FORWARD_SEARCH_TEXT = Parser.toCodePoints("(forward-i-search) `");
    private static final int[] DIVIDER = Parser.toCodePoints("': ");
    private static final Logger LOGGER = LoggerUtil.getLogger(SearchHistory.class.getName());

    SearchHistory(SearchAction.Status defaultAction) {
        this.defaultAction = defaultAction;
    }

    @Override
    public void input(Action action, KeyAction key) {
        if (action == null && Key.isPrintable(key.buffer())) {
            if (this.searchArgument == null) {
                this.searchArgument = new IntArrayBuilder(1);
            }
            this.status = this.defaultAction;
            this.searchArgument.append(key.buffer().array()[0]);
        } else if (action instanceof Interrupt) {
            this.status = SearchAction.Status.SEARCH_INTERRUPT;
        } else if (action instanceof Enter) {
            this.status = SearchAction.Status.SEARCH_END;
        } else if (action instanceof ReverseSearchHistory) {
            this.status = SearchAction.Status.SEARCH_PREV;
        } else if (action instanceof ForwardSearchHistory) {
            this.status = SearchAction.Status.SEARCH_NEXT;
        } else if (action instanceof DeletePrevChar) {
            this.status = SearchAction.Status.SEARCH_DELETE;
        } else if (action instanceof PrevHistory) {
            this.status = SearchAction.Status.SEARCH_MOVE_PREV;
        } else if (action instanceof NextHistory) {
            this.status = SearchAction.Status.SEARCH_MOVE_NEXT;
        } else if (action instanceof ForwardChar) {
            this.status = SearchAction.Status.SEARCH_MOVE_RIGHT;
        } else if (action instanceof BackwardChar) {
            this.status = SearchAction.Status.SEARCH_MOVE_LEFT;
        } else if (action instanceof BeginningOfLine) {
            this.status = SearchAction.Status.SEARCH_MOVE_BEGINNING_OF_LINE;
        } else if (action instanceof EndOfLine) {
            this.status = SearchAction.Status.SEARCH_MOVE_END_OF_LINE;
        } else {
            if (key == Key.ESC) {
                this.status = SearchAction.Status.SEARCH_EXIT;
            } else if (key == Key.CTRL_D) {
                this.status = SearchAction.Status.SEARCH_EXIT;
            }
            if (Key.isPrintable(key.buffer())) {
                if (this.searchArgument == null) {
                    this.searchArgument = new IntArrayBuilder(1);
                }
                this.status = this.defaultAction;
                this.searchArgument.append(key.buffer().array()[0]);
            }
        }
    }

    @Override
    public boolean keepFocus() {
        return this.status == SearchAction.Status.SEARCH_INPUT || this.status == SearchAction.Status.SEARCH_PREV || this.status == SearchAction.Status.SEARCH_NEXT || this.status == SearchAction.Status.SEARCH_DELETE;
    }

    @Override
    public void accept(InputProcessor inputProcessor) {
        if (this.status == SearchAction.Status.SEARCH_INTERRUPT) {
            inputProcessor.buffer().replace(new int[0]);
            this.searchArgument = null;
            this.searchResult = null;
        } else {
            switch (this.status) {
                case SEARCH_PREV: {
                    if (inputProcessor.buffer().history().getSearchDirection() != SearchDirection.REVERSE) {
                        inputProcessor.buffer().history().setSearchDirection(SearchDirection.REVERSE);
                    }
                    if (this.searchArgument == null || this.searchArgument.size() <= 0) break;
                    int[] tmpResult = inputProcessor.buffer().history().search(this.searchArgument.toArray());
                    if (tmpResult == null) {
                        this.searchArgument.deleteLastEntry();
                        break;
                    }
                    this.searchResult = tmpResult;
                    break;
                }
                case SEARCH_NEXT: {
                    if (inputProcessor.buffer().history().getSearchDirection() != SearchDirection.FORWARD) {
                        inputProcessor.buffer().history().setSearchDirection(SearchDirection.FORWARD);
                    }
                    if (this.searchArgument == null || this.searchArgument.size() <= 0) break;
                    int[] tmpResult = inputProcessor.buffer().history().search(this.searchArgument.toArray());
                    if (tmpResult == null) {
                        this.searchArgument.deleteLastEntry();
                        break;
                    }
                    this.searchResult = tmpResult;
                    break;
                }
                case SEARCH_NOT_STARTED: {
                    this.status = SearchAction.Status.SEARCH_PREV;
                    inputProcessor.buffer().history().setSearchDirection(SearchDirection.REVERSE);
                    if (inputProcessor.buffer().buffer().length() <= 0) break;
                    this.searchArgument = new IntArrayBuilder(inputProcessor.buffer().buffer().multiLine());
                    this.searchResult = inputProcessor.buffer().history().search(inputProcessor.buffer().buffer().multiLine());
                    break;
                }
                case SEARCH_DELETE: {
                    if (this.searchArgument == null || this.searchArgument.size() <= 0) break;
                    this.searchArgument.deleteLastEntry();
                    this.searchResult = inputProcessor.buffer().history().search(this.searchArgument.toArray());
                    break;
                }
                case SEARCH_END: {
                    if (this.searchResult != null) {
                        inputProcessor.buffer().moveCursor(-inputProcessor.buffer().buffer().cursor());
                        inputProcessor.buffer().replace(this.searchResult);
                        inputProcessor.buffer().history().push(inputProcessor.buffer().buffer().multiLine());
                        inputProcessor.buffer().buffer().reset();
                        inputProcessor.setReturnValue(this.searchResult);
                        break;
                    }
                    inputProcessor.buffer().moveCursor(-inputProcessor.buffer().buffer().cursor());
                    inputProcessor.buffer().replace(new int[0]);
                    break;
                }
                case SEARCH_EXIT: {
                    if (this.searchResult != null) {
                        inputProcessor.buffer().replace(this.searchResult);
                        break;
                    }
                    inputProcessor.buffer().replace(new int[0]);
                    break;
                }
                case SEARCH_MOVE_NEXT: {
                    this.searchResult = inputProcessor.buffer().history().getNextFetch();
                    inputProcessor.buffer().replace(this.searchResult);
                    break;
                }
                case SEARCH_MOVE_PREV: {
                    this.searchResult = inputProcessor.buffer().history().getPreviousFetch();
                    inputProcessor.buffer().replace(this.searchResult);
                    break;
                }
                case SEARCH_MOVE_RIGHT: 
                case SEARCH_MOVE_LEFT: 
                case SEARCH_MOVE_BEGINNING_OF_LINE: 
                case SEARCH_MOVE_END_OF_LINE: {
                    inputProcessor.buffer().replace(this.searchResult);
                }
            }
            if (!this.keepFocus()) {
                this.searchArgument = null;
                this.searchResult = null;
                if (this.status != SearchAction.Status.SEARCH_END) {
                    this.moveCursorAtExit(inputProcessor);
                }
            } else if (this.searchArgument == null || this.searchArgument.size() == 0) {
                if (this.searchResult != null) {
                    this.printSearch(new int[0], this.searchResult, inputProcessor);
                } else {
                    this.printSearch(new int[0], new int[0], inputProcessor);
                }
            } else if (this.searchResult != null && this.searchResult.length > 0) {
                this.printSearch(this.searchArgument.toArray(), this.searchResult, inputProcessor);
            }
        }
    }

    private void printSearch(int[] searchTerm, int[] result, InputProcessor inputProcessor) {
        int cursor = Parser.arrayIndexOf(result, searchTerm);
        IntArrayBuilder builder = inputProcessor.buffer().history().getSearchDirection() == SearchDirection.REVERSE ? new IntArrayBuilder(REVERSE_SEARCH_TEXT) : new IntArrayBuilder(FORWARD_SEARCH_TEXT);
        builder.append(searchTerm).append(DIVIDER);
        cursor += builder.size();
        builder.append(result);
        inputProcessor.buffer().moveCursor(-inputProcessor.buffer().buffer().cursor());
        inputProcessor.buffer().buffer().disablePrompt(true);
        inputProcessor.buffer().writeOut(ANSI.CURSOR_START);
        inputProcessor.buffer().writeOut(ANSI.ERASE_WHOLE_LINE);
        inputProcessor.buffer().replace(builder.toArray());
        inputProcessor.buffer().moveCursor(cursor - inputProcessor.buffer().buffer().cursor());
        inputProcessor.buffer().buffer().disablePrompt(false);
    }

    private void moveCursorAtExit(InputProcessor inputProcessor) {
        switch (this.status) {
            case SEARCH_MOVE_RIGHT: 
            case SEARCH_MOVE_END_OF_LINE: {
                inputProcessor.buffer().moveCursor(inputProcessor.buffer().buffer().length());
                break;
            }
            case SEARCH_MOVE_BEGINNING_OF_LINE: {
                inputProcessor.buffer().moveCursor(-inputProcessor.buffer().buffer().length());
            }
        }
    }
}

