/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.OsmServerChangesetReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class ChangesetUpdater {
    public static final IntegerProperty PROP_INTERVAL = new IntegerProperty("changeset.updater.interval", 60);
    private static final ScheduledExecutorService EXECUTOR = Executors.newSingleThreadScheduledExecutor(Utils.newThreadFactory("changeset-updater-%d", 5));
    private static final Runnable WORKER = new Worker();
    private static volatile ScheduledFuture<?> task;

    private ChangesetUpdater() {
    }

    public static void check() {
        long now = System.currentTimeMillis();
        List<Long> changesetIds = ChangesetCache.getInstance().getOpenChangesets().stream().filter(x -> x.getCreatedAt() != null && now - x.getCreatedAt().getTime() > TimeUnit.HOURS.toMillis(1L)).map(Changeset::getId).map(Integer::longValue).collect(Collectors.toList());
        if (!changesetIds.isEmpty()) {
            try {
                ChangesetCache.getInstance().update(new OsmServerChangesetReader().queryChangesets(new ChangesetQuery().forChangesetIds(changesetIds), null));
            }
            catch (OsmTransferException e) {
                Logging.warn(e);
            }
        }
    }

    public static void start() {
        int interval = PROP_INTERVAL.get();
        if (!ChangesetUpdater.isRunning() && interval > 0) {
            task = EXECUTOR.scheduleAtFixedRate(WORKER, 0L, interval, TimeUnit.MINUTES);
            Logging.info("Changeset updater active (checks every " + interval + " minute" + (interval > 1 ? "s" : "") + " if open changesets have been closed)");
        }
    }

    public static void stop() {
        if (ChangesetUpdater.isRunning()) {
            task.cancel(false);
            Logging.info("Changeset updater inactive");
            task = null;
        }
    }

    public static boolean isRunning() {
        return task != null;
    }

    private static class Worker
    implements Runnable {
        private long lastTimeInMillis;

        private Worker() {
        }

        @Override
        public void run() {
            long currentTime = System.currentTimeMillis();
            if (currentTime >= this.lastTimeInMillis + TimeUnit.MINUTES.toMillis(PROP_INTERVAL.get().intValue())) {
                this.lastTimeInMillis = currentTime;
                ChangesetUpdater.check();
            }
        }
    }
}

