/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.srtp.crypto;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.MacSpi;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jitsi.srtp.crypto.Aes;
import org.jitsi.srtp.crypto.JitsiOpenSslProvider;
import org.jitsi.srtp.crypto.OpenSslHmacSpi;
import org.jitsi.utils.logging2.Logger;

public class HmacSha1 {
    private static List<Provider> providers;
    private static Provider jitsiProvider;

    private static synchronized List<Provider> getProviders(Logger logger) {
        if (providers == null) {
            providers = new ArrayList<Provider>(3);
            if (JitsiOpenSslProvider.isLoaded()) {
                jitsiProvider = new JitsiOpenSslProvider();
                providers.add(jitsiProvider);
            }
            providers.add(Security.getProvider("SunJCE"));
            try {
                Provider pkcs11Provider = Aes.SunPKCS11CipherFactory.getProvider();
                if (pkcs11Provider != null) {
                    providers.add(pkcs11Provider);
                }
            }
            catch (Exception e) {
                logger.debug(() -> "PKCS#11 provider not available for HMAC: " + e.getMessage());
            }
            providers.add(new BouncyCastleProvider());
        }
        return providers;
    }

    public static Mac createMac(Logger parentLogger) {
        for (Provider p : HmacSha1.getProviders(parentLogger)) {
            try {
                Mac mac = p == jitsiProvider ? new MacWrapper(new OpenSslHmacSpi(), p, "HmacSHA1") : Mac.getInstance("HmacSHA1", p);
                parentLogger.debug(() -> "Using " + p.getName() + " for HMAC");
                return mac;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
        }
        throw new RuntimeException("No HmacSHA1 provider found");
    }

    private static class MacWrapper
    extends Mac {
        public MacWrapper(MacSpi macSpi, Provider provider, String s2) {
            super(macSpi, provider, s2);
        }
    }
}

