/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.attr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class StructMethodParametersAttribute
extends StructGeneralAttribute {
    private List<Entry> myEntries;

    @Override
    public void initContent(DataInputFullStream data, ConstantPool pool) throws IOException {
        List entries;
        int len = data.readUnsignedByte();
        if (len > 0) {
            entries = new ArrayList(len);
            for (int i = 0; i < len; ++i) {
                int nameIndex = data.readUnsignedShort();
                String name = nameIndex != 0 ? pool.getPrimitiveConstant(nameIndex).getString() : null;
                int access_flags = data.readUnsignedShort();
                entries.add(new Entry(name, access_flags));
            }
        } else {
            entries = Collections.emptyList();
        }
        this.myEntries = Collections.unmodifiableList(entries);
    }

    public List<Entry> getEntries() {
        return this.myEntries;
    }

    public static class Entry {
        public final String myName;
        public final int myAccessFlags;

        public Entry(String name, int accessFlags) {
            this.myName = name;
            this.myAccessFlags = accessFlags;
        }
    }
}

