/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.attr;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AnnotationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.consts.PrimitiveConstant;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class StructAnnotationAttribute
extends StructGeneralAttribute {
    private List<AnnotationExprent> annotations;

    @Override
    public void initContent(DataInputFullStream data, ConstantPool pool) throws IOException {
        this.annotations = StructAnnotationAttribute.parseAnnotations(pool, data);
    }

    public static List<AnnotationExprent> parseAnnotations(ConstantPool pool, DataInputStream data) throws IOException {
        int len = data.readUnsignedShort();
        if (len > 0) {
            ArrayList<AnnotationExprent> annotations = new ArrayList<AnnotationExprent>(len);
            for (int i = 0; i < len; ++i) {
                annotations.add(StructAnnotationAttribute.parseAnnotation(data, pool));
            }
            return annotations;
        }
        return Collections.emptyList();
    }

    @NotNull
    public static AnnotationExprent parseAnnotation(DataInputStream data, ConstantPool pool) throws IOException {
        List values;
        List<String> names;
        String className = pool.getPrimitiveConstant(data.readUnsignedShort()).getString();
        int len = data.readUnsignedShort();
        if (len > 0) {
            names = new ArrayList(len);
            values = new ArrayList(len);
            for (int i = 0; i < len; ++i) {
                names.add(pool.getPrimitiveConstant(data.readUnsignedShort()).getString());
                values.add(StructAnnotationAttribute.parseAnnotationElement(data, pool));
            }
        } else {
            names = Collections.emptyList();
            values = Collections.emptyList();
        }
        return new AnnotationExprent(new VarType(className).getValue(), names, values);
    }

    public static Exprent parseAnnotationElement(DataInputStream data, ConstantPool pool) throws IOException {
        int tag = data.readUnsignedByte();
        switch (tag) {
            case 101: {
                String className = pool.getPrimitiveConstant(data.readUnsignedShort()).getString();
                String constName = pool.getPrimitiveConstant(data.readUnsignedShort()).getString();
                FieldDescriptor descr = FieldDescriptor.parseDescriptor(className);
                return new FieldExprent(constName, descr.type.getValue(), true, null, descr, null);
            }
            case 99: {
                String descriptor = pool.getPrimitiveConstant(data.readUnsignedShort()).getString();
                VarType type = FieldDescriptor.parseDescriptor((String)descriptor).type;
                String value = switch (type.getType()) {
                    case 8 -> type.getValue();
                    case 0 -> Byte.TYPE.getName();
                    case 1 -> Character.TYPE.getName();
                    case 2 -> Double.TYPE.getName();
                    case 3 -> Float.TYPE.getName();
                    case 4 -> Integer.TYPE.getName();
                    case 5 -> Long.TYPE.getName();
                    case 6 -> Short.TYPE.getName();
                    case 7 -> Boolean.TYPE.getName();
                    case 10 -> Void.TYPE.getName();
                    default -> throw new RuntimeException("invalid class type: " + type.getType());
                };
                return new ConstExprent(VarType.VARTYPE_CLASS, value, null);
            }
            case 91: {
                VarType newType;
                List<Exprent> elements = Collections.emptyList();
                int len = data.readUnsignedShort();
                if (len > 0) {
                    elements = new ArrayList(len);
                    for (int i = 0; i < len; ++i) {
                        elements.add(StructAnnotationAttribute.parseAnnotationElement(data, pool));
                    }
                }
                if (elements.isEmpty()) {
                    newType = new VarType(8, 1, "java/lang/Object");
                } else {
                    VarType elementType = ((Exprent)elements.get(0)).getExprType();
                    newType = new VarType(elementType.getType(), 1, elementType.getValue());
                }
                NewExprent newExpr = new NewExprent(newType, Collections.emptyList(), null);
                newExpr.setDirectArrayInit(true);
                newExpr.setLstArrayElements(elements);
                return newExpr;
            }
            case 64: {
                return StructAnnotationAttribute.parseAnnotation(data, pool);
            }
        }
        PrimitiveConstant cn = pool.getPrimitiveConstant(data.readUnsignedShort());
        return switch (tag) {
            case 66 -> new ConstExprent(VarType.VARTYPE_BYTE, cn.value, null);
            case 67 -> new ConstExprent(VarType.VARTYPE_CHAR, cn.value, null);
            case 68 -> new ConstExprent(VarType.VARTYPE_DOUBLE, cn.value, null);
            case 70 -> new ConstExprent(VarType.VARTYPE_FLOAT, cn.value, null);
            case 73 -> new ConstExprent(VarType.VARTYPE_INT, cn.value, null);
            case 74 -> new ConstExprent(VarType.VARTYPE_LONG, cn.value, null);
            case 83 -> new ConstExprent(VarType.VARTYPE_SHORT, cn.value, null);
            case 90 -> new ConstExprent(VarType.VARTYPE_BOOLEAN, cn.value, null);
            case 115 -> new ConstExprent(VarType.VARTYPE_STRING, cn.value, null);
            default -> throw new RuntimeException("invalid element type!");
        };
    }

    public List<AnnotationExprent> getAnnotations() {
        return this.annotations;
    }
}

