/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.code.SimpleInstructionSequence;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.code.cfg.ControlFlowGraph;
import org.jetbrains.java.decompiler.code.cfg.ExceptionRangeCFG;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.code.DeadCodeHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.FlattenStatementsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.SSAConstructorSparseEx;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersion;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class FinallyProcessor {
    private final Map<Integer, Integer> finallyBlockIDs = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> catchallBlockIDs = new HashMap<Integer, Integer>();
    private final MethodDescriptor methodDescriptor;
    private final VarProcessor varProcessor;

    public FinallyProcessor(MethodDescriptor md, VarProcessor varProc) {
        this.methodDescriptor = md;
        this.varProcessor = varProc;
    }

    public boolean iterateGraph(StructClass cl, StructMethod mt, RootStatement root, ControlFlowGraph graph) {
        int bytecodeVersion = mt.getBytecodeVersion();
        LinkedList<RootStatement> stack = new LinkedList<RootStatement>();
        stack.add(root);
        while (!stack.isEmpty()) {
            Statement stat = (Statement)stack.removeLast();
            Statement parent = stat.getParent();
            if (parent != null && parent.type == Statement.StatementType.CATCH_ALL && stat == parent.getFirst() && !parent.isCopied()) {
                CatchAllStatement fin = (CatchAllStatement)parent;
                BasicBlock head = fin.getBasichead().getBlock();
                BasicBlock handler = fin.getHandler().getBasichead().getBlock();
                if (!this.catchallBlockIDs.containsKey(handler.id)) {
                    if (this.finallyBlockIDs.containsKey(handler.id)) {
                        fin.setFinally(true);
                        Integer var = this.finallyBlockIDs.get(handler.id);
                        fin.setMonitor(var == null ? null : new VarExprent(var, VarType.VARTYPE_INT, this.varProcessor));
                    } else {
                        Record inf = this.getFinallyInformation(cl, mt, root, fin);
                        if (inf == null) {
                            this.catchallBlockIDs.put(handler.id, null);
                        } else {
                            if (DecompilerContext.getOption("fdi") && this.verifyFinallyEx(graph, fin, inf)) {
                                this.finallyBlockIDs.put(handler.id, null);
                            } else {
                                int varIndex = DecompilerContext.getCounterContainer().getCounterAndIncrement(2);
                                FinallyProcessor.insertSemaphore(graph, FinallyProcessor.getAllBasicBlocks(fin.getFirst()), head, handler, varIndex, inf, bytecodeVersion);
                                this.finallyBlockIDs.put(handler.id, varIndex);
                            }
                            DeadCodeHelper.removeDeadBlocks(graph);
                            DeadCodeHelper.removeEmptyBlocks(graph);
                            DeadCodeHelper.mergeBasicBlocks(graph);
                        }
                        return true;
                    }
                }
            }
            stack.addAll(stat.getStats());
        }
        return false;
    }

    private Record getFinallyInformation(StructClass cl, StructMethod mt, RootStatement root, CatchAllStatement fstat) {
        HashMap<BasicBlock, Boolean> mapLast = new HashMap<BasicBlock, Boolean>();
        BasicBlockStatement firstBlockStatement = fstat.getHandler().getBasichead();
        BasicBlock firstBasicBlock = firstBlockStatement.getBlock();
        Instruction instrFirst = firstBasicBlock.getInstruction(0);
        int firstCode = switch (instrFirst.opcode) {
            case 87 -> 1;
            case 58 -> 2;
            default -> 0;
        };
        ExprProcessor proc = new ExprProcessor(this.methodDescriptor, this.varProcessor);
        proc.processStatement(root, cl);
        SSAConstructorSparseEx ssa = new SSAConstructorSparseEx();
        ssa.splitVariables(root, mt);
        List<Exprent> expressions = firstBlockStatement.getExprents();
        VarVersion pair = new VarVersion((VarExprent)((AssignmentExprent)expressions.get(firstCode == 2 ? 1 : 0)).getLeft());
        FlattenStatementsHelper flattenHelper = new FlattenStatementsHelper();
        DirectGraph dgraph = flattenHelper.buildDirectGraph(root);
        LinkedList<DirectNode> stack = new LinkedList<DirectNode>();
        stack.add(dgraph.first);
        HashSet<DirectNode> setVisited = new HashSet<DirectNode>();
        while (!stack.isEmpty()) {
            DirectNode node = (DirectNode)stack.removeFirst();
            if (setVisited.contains(node)) continue;
            setVisited.add(node);
            BasicBlockStatement blockStatement = null;
            if (node.block != null) {
                blockStatement = node.block;
            } else if (node.predecessors.size() == 1) {
                blockStatement = node.predecessors.get((int)0).block;
            }
            boolean isTrueExit = true;
            if (firstCode != 1) {
                isTrueExit = false;
                for (int i = 0; i < node.exprents.size(); ++i) {
                    ExitExprent exit;
                    Exprent exprent = node.exprents.get(i);
                    if (firstCode == 0) {
                        ExitExprent exit2;
                        List<Exprent> lst = exprent.getAllExprents();
                        lst.add(exprent);
                        boolean found = false;
                        for (Exprent expr : lst) {
                            if (expr.type != 12 || !new VarVersion((VarExprent)expr).equals(pair)) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        found = false;
                        if (exprent.type == 4 && (exit2 = (ExitExprent)exprent).getExitType() == 1 && exit2.getValue().type == 12) {
                            found = true;
                        }
                        if (!found) {
                            return null;
                        }
                        isTrueExit = true;
                        continue;
                    }
                    if (exprent.type != 2) continue;
                    AssignmentExprent assignment = (AssignmentExprent)exprent;
                    if (assignment.getRight().type != 12 || !new VarVersion((VarExprent)assignment.getRight()).equals(pair)) continue;
                    Exprent next = null;
                    if (i == node.exprents.size() - 1) {
                        if (node.successors.size() == 1) {
                            DirectNode nd = node.successors.get(0);
                            if (!nd.exprents.isEmpty()) {
                                next = nd.exprents.get(0);
                            }
                        }
                    } else {
                        next = node.exprents.get(i + 1);
                    }
                    boolean found = false;
                    if (next != null && next.type == 4 && (exit = (ExitExprent)next).getExitType() == 1 && exit.getValue().type == 12 && assignment.getLeft().equals(exit.getValue())) {
                        found = true;
                    }
                    if (!found) {
                        return null;
                    }
                    isTrueExit = true;
                }
            }
            if (blockStatement != null && blockStatement.getBlock() != null) {
                Statement handler = fstat.getHandler();
                for (StatEdge edge : blockStatement.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL)) {
                    Boolean existingFlag;
                    if (edge.getType() == StatEdge.EdgeType.REGULAR || !handler.containsStatement(blockStatement) || handler.containsStatement(edge.getDestination()) || (existingFlag = (Boolean)mapLast.get(blockStatement.getBlock())) != null && existingFlag.booleanValue()) continue;
                    mapLast.put(blockStatement.getBlock(), isTrueExit);
                    break;
                }
            }
            stack.addAll(node.successors);
        }
        if (fstat.getHandler().type == Statement.StatementType.BASIC_BLOCK) {
            boolean isEmpty;
            boolean isFirstLast = mapLast.containsKey(firstBasicBlock);
            InstructionSequence seq = firstBasicBlock.getSeq();
            switch (firstCode) {
                case 0: {
                    boolean bl;
                    if (isFirstLast && seq.length() == 1) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 1: {
                    boolean bl;
                    if (seq.length() == 1) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    boolean bl;
                    if (isFirstLast) {
                        if (seq.length() == 3) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    if (seq.length() == 1) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    boolean bl = isEmpty = false;
                }
            }
            if (isEmpty) {
                firstCode = 3;
            }
        }
        return new Record(firstCode, mapLast);
    }

    private static void insertSemaphore(ControlFlowGraph graph, Set<BasicBlock> setTry, BasicBlock head, BasicBlock handler, int var, Record information, int bytecodeVersion) {
        HashSet<BasicBlock> setCopy = new HashSet<BasicBlock>(setTry);
        int finallyType = information.firstCode;
        Map<BasicBlock, Boolean> mapLast = information.mapLast;
        FinallyProcessor.removeExceptionInstructionsEx(handler, 1, finallyType);
        for (Map.Entry<BasicBlock, Boolean> entry : mapLast.entrySet()) {
            BasicBlock last = entry.getKey();
            if (!entry.getValue().booleanValue()) continue;
            FinallyProcessor.removeExceptionInstructionsEx(last, 2, finallyType);
            graph.getFinallyExits().add(last);
        }
        int storeLength = var <= 3 ? 1 : (var <= 128 ? 2 : 4);
        for (BasicBlock block : setTry) {
            for (BasicBlock dest : block.getSuccessors()) {
                if (dest == graph.getLast() || setCopy.contains(dest)) continue;
                SimpleInstructionSequence seq = new SimpleInstructionSequence();
                seq.addInstruction(Instruction.create(16, false, 1, bytecodeVersion, new int[]{0}, 1), -1);
                seq.addInstruction(Instruction.create(54, false, 1, bytecodeVersion, new int[]{var}, storeLength), -1);
                BasicBlock newBlock = new BasicBlock(++graph.last_id, seq);
                block.replaceSuccessor(dest, newBlock);
                newBlock.addSuccessor(dest);
                setCopy.add(newBlock);
                graph.getBlocks().addWithKey(newBlock, newBlock.id);
                FinallyProcessor.copyExceptionEdges(graph, block, newBlock);
            }
        }
        BasicBlock basicBlock = FinallyProcessor.createHeadBlock(graph, 1, var, bytecodeVersion, storeLength);
        FinallyProcessor.insertBlockBefore(graph, head, basicBlock);
        BasicBlock newHeadInit = FinallyProcessor.createHeadBlock(graph, 0, var, bytecodeVersion, storeLength);
        FinallyProcessor.insertBlockBefore(graph, basicBlock, newHeadInit);
        setCopy.add(basicBlock);
        setCopy.add(newHeadInit);
        for (BasicBlock hd : new HashSet<BasicBlock>(newHeadInit.getSuccessorExceptions())) {
            ExceptionRangeCFG range = graph.getExceptionRange(hd, newHeadInit);
            if (!setCopy.containsAll(range.getProtectedRange())) continue;
            newHeadInit.removeSuccessorException(hd);
            range.getProtectedRange().remove(newHeadInit);
        }
    }

    @NotNull
    private static BasicBlock createHeadBlock(ControlFlowGraph graph, int value, int var, int bytecodeVersion, int storeLength) {
        SimpleInstructionSequence seq = new SimpleInstructionSequence();
        seq.addInstruction(Instruction.create(16, false, 1, bytecodeVersion, new int[]{value}, 1), -1);
        seq.addInstruction(Instruction.create(54, false, 1, bytecodeVersion, new int[]{var}, storeLength), -1);
        return new BasicBlock(++graph.last_id, seq);
    }

    private static void insertBlockBefore(ControlFlowGraph graph, BasicBlock oldBlock, BasicBlock newBlock) {
        ArrayList<BasicBlock> blocks = new ArrayList<BasicBlock>();
        blocks.addAll(oldBlock.getPredecessors());
        blocks.addAll(oldBlock.getPredecessorExceptions());
        for (BasicBlock predecessor : blocks) {
            predecessor.replaceSuccessor(oldBlock, newBlock);
        }
        for (BasicBlock hd : oldBlock.getSuccessorExceptions()) {
            newBlock.addSuccessorException(hd);
            ExceptionRangeCFG range = graph.getExceptionRange(hd, oldBlock);
            range.getProtectedRange().add(newBlock);
        }
        for (ExceptionRangeCFG range : graph.getExceptions()) {
            if (range.getHandler() != oldBlock) continue;
            range.setHandler(newBlock);
        }
        newBlock.addSuccessor(oldBlock);
        graph.getBlocks().addWithKey(newBlock, newBlock.id);
        if (graph.getFirst() == oldBlock) {
            graph.setFirst(newBlock);
        }
    }

    private static Set<BasicBlock> getAllBasicBlocks(Statement stat) {
        LinkedList<Statement> lst = new LinkedList<Statement>();
        lst.add(stat);
        int index = 0;
        do {
            Statement st = (Statement)lst.get(index);
            if (st.type == Statement.StatementType.BASIC_BLOCK) {
                ++index;
                continue;
            }
            lst.addAll(st.getStats());
            lst.remove(index);
        } while (index < lst.size());
        HashSet<BasicBlock> res = new HashSet<BasicBlock>();
        for (Statement st : lst) {
            res.add(((BasicBlockStatement)st).getBlock());
        }
        return res;
    }

    private boolean verifyFinallyEx(ControlFlowGraph graph, CatchAllStatement fstat, Record information) {
        BasicBlock firstSuccessor;
        Set<BasicBlock> tryBlocks = FinallyProcessor.getAllBasicBlocks(fstat.getFirst());
        Set<BasicBlock> catchBlocks = FinallyProcessor.getAllBasicBlocks(fstat.getHandler());
        int finallyType = information.firstCode;
        Map<BasicBlock, Boolean> mapLast = information.mapLast;
        BasicBlock first = fstat.getHandler().getBasichead().getBlock();
        boolean skippedFirst = false;
        if (finallyType == 3) {
            FinallyProcessor.removeExceptionInstructionsEx(first, 3, finallyType);
            if (mapLast.containsKey(first)) {
                graph.getFinallyExits().add(first);
            }
            return true;
        }
        if (first.getSeq().length() == 1 && finallyType > 0 && catchBlocks.contains(firstSuccessor = first.getSuccessors().get(0))) {
            first = firstSuccessor;
            skippedFirst = true;
        }
        HashSet<BasicBlock> startBlocks = new HashSet<BasicBlock>();
        for (BasicBlock block : tryBlocks) {
            startBlocks.addAll(block.getSuccessors());
        }
        startBlocks.remove(graph.getLast());
        startBlocks.removeAll(tryBlocks);
        ArrayList starts = new ArrayList(startBlocks);
        Collections.sort(starts, Comparator.comparingInt(o -> -o.id));
        ArrayList<Area> areas = new ArrayList<Area>();
        for (BasicBlock start : starts) {
            Area area = this.compareSubGraphsEx(graph, start, catchBlocks, first, finallyType, mapLast, skippedFirst);
            if (area == null) {
                return false;
            }
            areas.add(area);
        }
        for (Area area : areas) {
            FinallyProcessor.deleteArea(graph, area);
        }
        ArrayList<Map.Entry<BasicBlock, Boolean>> lasts = new ArrayList<Map.Entry<BasicBlock, Boolean>>(mapLast.entrySet());
        lasts.sort(Comparator.comparingInt(o -> ((BasicBlock)o.getKey()).id));
        for (Map.Entry entry : lasts) {
            BasicBlock last = (BasicBlock)entry.getKey();
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            FinallyProcessor.removeExceptionInstructionsEx(last, 2, finallyType);
            graph.getFinallyExits().add(last);
        }
        FinallyProcessor.removeExceptionInstructionsEx(fstat.getHandler().getBasichead().getBlock(), 1, finallyType);
        return true;
    }

    private Area compareSubGraphsEx(ControlFlowGraph graph, BasicBlock startSample, Set<BasicBlock> catchBlocks, BasicBlock startCatch, int finallyType, Map<BasicBlock, Boolean> mapLast, boolean skippedFirst) {
        LinkedList<BlockStackEntry> stack = new LinkedList<BlockStackEntry>();
        HashSet<BasicBlock> setSample = new HashSet<BasicBlock>();
        HashMap<CallSite, BasicBlock[]> mapNext = new HashMap<CallSite, BasicBlock[]>();
        class BlockStackEntry {
            public final BasicBlock blockCatch;
            public final BasicBlock blockSample;
            public final List<int[]> lstStoreVars;

            BlockStackEntry(BasicBlock blockCatch, BasicBlock blockSample, List<int[]> lstStoreVars) {
                this.blockCatch = blockCatch;
                this.blockSample = blockSample;
                this.lstStoreVars = new ArrayList<int[]>(lstStoreVars);
            }
        }
        stack.add(new BlockStackEntry(startCatch, startSample, new ArrayList<int[]>()));
        while (!stack.isEmpty()) {
            BasicBlock sucSample;
            BasicBlock sucCatch;
            int i;
            boolean isLastBlock;
            boolean isTrueLastBlock;
            BlockStackEntry entry = (BlockStackEntry)stack.remove(0);
            BasicBlock blockCatch = entry.blockCatch;
            BasicBlock blockSample = entry.blockSample;
            boolean isFirstBlock = !skippedFirst && blockCatch == startCatch;
            int compareType = (isFirstBlock ? 1 : 0) | ((isTrueLastBlock = (isLastBlock = mapLast.containsKey(blockCatch)) && mapLast.get(blockCatch) != false) ? 2 : 0);
            if (!this.compareBasicBlocksEx(graph, blockCatch, blockSample, compareType, finallyType, entry.lstStoreVars)) {
                return null;
            }
            if (blockSample.getSuccessors().size() != blockCatch.getSuccessors().size()) {
                return null;
            }
            setSample.add(blockSample);
            for (i = 0; i < blockCatch.getSuccessors().size(); ++i) {
                sucCatch = blockCatch.getSuccessors().get(i);
                sucSample = blockSample.getSuccessors().get(i);
                if (!catchBlocks.contains(sucCatch) || setSample.contains(sucSample)) continue;
                stack.add(new BlockStackEntry(sucCatch, sucSample, entry.lstStoreVars));
            }
            if (!isLastBlock || !blockSample.getSeq().isEmpty()) {
                if (blockCatch.getSuccessorExceptions().size() == blockSample.getSuccessorExceptions().size()) {
                    for (i = 0; i < blockCatch.getSuccessorExceptions().size(); ++i) {
                        String excSample;
                        sucCatch = blockCatch.getSuccessorExceptions().get(i);
                        sucSample = blockSample.getSuccessorExceptions().get(i);
                        String excCatch = graph.getExceptionRange(sucCatch, blockCatch).getUniqueExceptionsString();
                        if (Objects.equals(excCatch, excSample = graph.getExceptionRange(sucSample, blockSample).getUniqueExceptionsString())) {
                            if (!catchBlocks.contains(sucCatch) || setSample.contains(sucSample)) continue;
                            List<int[]> lst = entry.lstStoreVars;
                            if (sucCatch.getSeq().length() > 0 && sucSample.getSeq().length() > 0) {
                                Instruction instrCatch = sucCatch.getSeq().getInstr(0);
                                Instruction instrSample = sucSample.getSeq().getInstr(0);
                                if (instrCatch.opcode == 58 && instrSample.opcode == 58) {
                                    lst = new ArrayList<int[]>(lst);
                                    lst.add(new int[]{instrCatch.operand(0), instrSample.operand(0)});
                                }
                            }
                            stack.add(new BlockStackEntry(sucCatch, sucSample, lst));
                            continue;
                        }
                        return null;
                    }
                } else {
                    return null;
                }
            }
            if (!isLastBlock) continue;
            HashSet<BasicBlock> successors = new HashSet<BasicBlock>(blockSample.getSuccessors());
            successors.removeAll(setSample);
            for (BlockStackEntry stackEntry : stack) {
                successors.remove(stackEntry.blockSample);
            }
            for (BasicBlock successor : successors) {
                if (graph.getLast() == successor) continue;
                mapNext.put((CallSite)((Object)(blockSample.id + "#" + successor.id)), new BasicBlock[]{blockSample, successor, isTrueLastBlock ? successor : null});
            }
        }
        return new Area(startSample, setSample, FinallyProcessor.getUniqueNext(graph, new HashSet<BasicBlock[]>(mapNext.values())));
    }

    private static BasicBlock getUniqueNext(ControlFlowGraph graph, Set<BasicBlock[]> setNext) {
        BasicBlock next = null;
        boolean multiple = false;
        for (BasicBlock[] arr : setNext) {
            if (arr[2] != null) {
                next = arr[1];
                multiple = false;
                break;
            }
            if (next == null) {
                next = arr[1];
            } else if (next != arr[1]) {
                multiple = true;
            }
            if (arr[1].getPredecessors().size() != 1) continue;
            next = arr[1];
        }
        if (multiple) {
            for (BasicBlock[] arr : setNext) {
                BasicBlock block = arr[1];
                if (block == next) continue;
                if (InterpreterUtil.equalSets(next.getSuccessors(), block.getSuccessors())) {
                    InstructionSequence seqNext = next.getSeq();
                    InstructionSequence seqBlock = block.getSeq();
                    if (seqNext.length() == seqBlock.length()) {
                        for (int i = 0; i < seqNext.length(); ++i) {
                            Instruction instrBlock;
                            Instruction instrNext = seqNext.getInstr(i);
                            if (!Instruction.equals(instrNext, instrBlock = seqBlock.getInstr(i))) {
                                return null;
                            }
                            for (int j = 0; j < instrNext.operandsCount(); ++j) {
                                if (instrNext.operand(j) == instrBlock.operand(j)) continue;
                                return null;
                            }
                        }
                        continue;
                    }
                    return null;
                }
                return null;
            }
            for (BasicBlock[] arr : setNext) {
                if (arr[1] == next) continue;
                arr[0].removeSuccessor(arr[1]);
                arr[0].addSuccessor(next);
            }
            DeadCodeHelper.removeDeadBlocks(graph);
        }
        return next;
    }

    private boolean compareBasicBlocksEx(ControlFlowGraph graph, BasicBlock pattern, BasicBlock sample, int type, int finallyType, List<int[]> lstStoreVars) {
        InstructionSequence seqPattern = pattern.getSeq();
        List<Integer> instrOldOffsetsPattern = pattern.getOriginalOffsets();
        InstructionSequence seqSample = sample.getSeq();
        List<Integer> instrOldOffsetsSample = sample.getOriginalOffsets();
        if (type != 0) {
            seqPattern = seqPattern.clone();
            instrOldOffsetsPattern = new ArrayList<Integer>(instrOldOffsetsPattern);
            if ((type & 1) > 0 && finallyType > 0) {
                instrOldOffsetsPattern.remove(0);
                seqPattern.removeInstruction(0);
            }
            if ((type & 2) > 0) {
                if (finallyType == 0 || finallyType == 2) {
                    instrOldOffsetsPattern.remove(instrOldOffsetsPattern.size() - 1);
                    seqPattern.removeLast();
                }
                if (finallyType == 2) {
                    instrOldOffsetsPattern.remove(instrOldOffsetsPattern.size() - 1);
                    seqPattern.removeLast();
                }
            }
        }
        if (seqPattern.length() > seqSample.length()) {
            return false;
        }
        for (int i = 0; i < seqPattern.length(); ++i) {
            Instruction instrSample;
            Instruction instrPattern = seqPattern.getInstr(i);
            if (this.equalInstructions(instrPattern, instrSample = seqSample.getInstr(i), lstStoreVars)) continue;
            return false;
        }
        if (seqPattern.length() < seqSample.length()) {
            SimpleInstructionSequence seq = new SimpleInstructionSequence();
            LinkedList<Integer> oldOffsets = new LinkedList<Integer>();
            for (int i = seqSample.length() - 1; i >= seqPattern.length(); --i) {
                seq.addInstruction(0, seqSample.getInstr(i), -1);
                oldOffsets.addFirst(sample.getOriginalOffset(i));
                seqSample.removeInstruction(i);
                instrOldOffsetsSample.remove(i);
            }
            BasicBlock newBlock = new BasicBlock(++graph.last_id, seq);
            newBlock.getOriginalOffsets().addAll(oldOffsets);
            ArrayList<BasicBlock> lstTemp = new ArrayList<BasicBlock>(sample.getSuccessors());
            for (BasicBlock suc : lstTemp) {
                sample.removeSuccessor(suc);
                newBlock.addSuccessor(suc);
            }
            sample.addSuccessor(newBlock);
            graph.getBlocks().addWithKey(newBlock, newBlock.id);
            Set<BasicBlock> setFinallyExits = graph.getFinallyExits();
            if (setFinallyExits.contains(sample)) {
                setFinallyExits.remove(sample);
                setFinallyExits.add(newBlock);
            }
            FinallyProcessor.copyExceptionEdges(graph, sample, newBlock);
        }
        return true;
    }

    public static void copyExceptionEdges(ControlFlowGraph graph, BasicBlock sample, BasicBlock newBlock) {
        for (int i = 0; i < sample.getSuccessorExceptions().size(); ++i) {
            BasicBlock hd = sample.getSuccessorExceptions().get(i);
            newBlock.addSuccessorException(hd);
            ExceptionRangeCFG range = graph.getExceptionRange(hd, sample);
            range.getProtectedRange().add(newBlock);
        }
    }

    public boolean equalInstructions(Instruction first, Instruction second, List<int[]> lstStoreVars) {
        if (!Instruction.equals(first, second)) {
            return false;
        }
        if (first.group != 2) {
            for (int i = 0; i < first.operandsCount(); ++i) {
                int secondOp;
                int firstOp = first.operand(i);
                if (firstOp == (secondOp = second.operand(i))) continue;
                if (first.opcode == 25) {
                    for (int[] arr : lstStoreVars) {
                        if (arr[0] != firstOp || arr[1] != secondOp) continue;
                        return true;
                    }
                } else if (first.opcode == 58) {
                    lstStoreVars.add(new int[]{firstOp, secondOp});
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    private static void deleteArea(ControlFlowGraph graph, Area area) {
        BasicBlock start = area.start;
        BasicBlock next = area.next;
        if (start == next) {
            return;
        }
        if (next == null) {
            next = graph.getLast();
        }
        HashSet<BasicBlock> setCommonExceptionHandlers = new HashSet<BasicBlock>(next.getSuccessorExceptions());
        for (BasicBlock predecessor : start.getPredecessors()) {
            setCommonExceptionHandlers.retainAll(predecessor.getSuccessorExceptions());
        }
        boolean isOutsideRange = false;
        HashSet<BasicBlock> setPredecessors = new HashSet<BasicBlock>(start.getPredecessors());
        for (BasicBlock predecessor : setPredecessors) {
            predecessor.replaceSuccessor(start, next);
        }
        Set<BasicBlock> setBlocks = area.sample;
        HashSet<ExceptionRangeCFG> setCommonRemovedExceptionRanges = null;
        for (BasicBlock block : setBlocks) {
            if (!graph.getBlocks().containsKey(block.id)) continue;
            if (!new HashSet<BasicBlock>(block.getSuccessorExceptions()).containsAll(setCommonExceptionHandlers)) {
                isOutsideRange = true;
            }
            HashSet<ExceptionRangeCFG> setRemovedExceptionRanges = new HashSet<ExceptionRangeCFG>();
            for (BasicBlock handler : block.getSuccessorExceptions()) {
                setRemovedExceptionRanges.add(graph.getExceptionRange(handler, block));
            }
            if (setCommonRemovedExceptionRanges == null) {
                setCommonRemovedExceptionRanges = setRemovedExceptionRanges;
            } else {
                setCommonRemovedExceptionRanges.retainAll(setRemovedExceptionRanges);
            }
            if (block.getSeq().isEmpty() && block.getSuccessors().size() == 1) {
                BasicBlock successor = block.getSuccessors().get(0);
                for (BasicBlock predecessor : new ArrayList<BasicBlock>(block.getPredecessors())) {
                    if (setBlocks.contains(predecessor)) continue;
                    predecessor.replaceSuccessor(block, successor);
                }
                if (graph.getFirst() == block) {
                    graph.setFirst(successor);
                }
            }
            graph.removeBlock(block);
        }
        if (isOutsideRange) {
            BasicBlock emptyBlock = new BasicBlock(++graph.last_id);
            graph.getBlocks().addWithKey(emptyBlock, emptyBlock.id);
            for (ExceptionRangeCFG range : setCommonRemovedExceptionRanges) {
                emptyBlock.addSuccessorException(range.getHandler());
                range.getProtectedRange().add(emptyBlock);
            }
            emptyBlock.addSuccessor(next);
            for (BasicBlock predecessor : setPredecessors) {
                predecessor.replaceSuccessor(next, emptyBlock);
            }
        }
    }

    private static void removeExceptionInstructionsEx(BasicBlock block, int blockType, int finallyType) {
        InstructionSequence seq = block.getSeq();
        List<Integer> instrOldOffsets = block.getOriginalOffsets();
        if (finallyType == 3) {
            for (int i = seq.length() - 1; i >= 0; --i) {
                seq.removeInstruction(i);
                instrOldOffsets.remove(i);
            }
        } else {
            if ((blockType & 1) > 0 && (finallyType == 2 || finallyType == 1)) {
                seq.removeInstruction(0);
            }
            if ((blockType & 2) > 0) {
                if (finallyType == 2 || finallyType == 0) {
                    seq.removeLast();
                    instrOldOffsets.remove(instrOldOffsets.size() - 1);
                }
                if (finallyType == 2) {
                    seq.removeLast();
                    instrOldOffsets.remove(instrOldOffsets.size() - 1);
                }
            }
        }
    }

    private static final class Record {
        private final int firstCode;
        private final Map<BasicBlock, Boolean> mapLast;

        private Record(int firstCode, Map<BasicBlock, Boolean> mapLast) {
            this.firstCode = firstCode;
            this.mapLast = mapLast;
        }
    }

    private static final class Area {
        private final BasicBlock start;
        private final Set<BasicBlock> sample;
        private final BasicBlock next;

        private Area(BasicBlock start, Set<BasicBlock> sample, BasicBlock next) {
            this.start = start;
            this.sample = sample;
            this.next = next;
        }
    }
}

