/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.decompiler.util;

import java.util.BitSet;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.IfExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.struct.match.IMatchable;

public final class DebugPrinter {
    public static void printMethod(Statement root, String name, VarProcessor varProc) {
        System.out.println(name + "{");
        if (root == null || root.getSequentialObjects() == null) {
            System.out.println("}");
            return;
        }
        for (IMatchable obj : root.getSequentialObjects()) {
            if (obj instanceof Statement) {
                DebugPrinter.printStatement((Statement)obj, "  ", varProc);
                continue;
            }
            if (obj == null) {
                System.out.println("  null");
                continue;
            }
            System.out.println("  " + obj.getClass().getSimpleName());
        }
        if (root.type == Statement.StatementType.ROOT) {
            DebugPrinter.printStatement(((RootStatement)root).getDummyExit(), "  ", varProc);
        }
        System.out.println("}");
    }

    public static void printStatement(Statement statement, String indent, VarProcessor varProc) {
        BitSet values = new BitSet();
        statement.getOffset(values);
        int start = values.nextSetBit(0);
        int end = values.length() - 1;
        System.out.println((String)indent + "{" + statement.getClass().getSimpleName() + "}:" + statement.id + "  (" + start + ", " + end + ")");
        for (StatEdge statEdge : statement.getAllSuccessorEdges()) {
            System.out.println((String)indent + " Dest: " + statEdge.getDestination());
        }
        if (statement.getExprents() != null) {
            for (Exprent exprent : statement.getExprents()) {
                System.out.println(DebugPrinter.printExprent((String)indent + "  ", exprent, varProc));
            }
        }
        indent = (String)indent + "  ";
        for (Object object : statement.getSequentialObjects()) {
            if (object == null) {
                System.out.println((String)indent + " Null");
                continue;
            }
            if (object instanceof Statement) {
                DebugPrinter.printStatement((Statement)object, (String)indent, varProc);
                continue;
            }
            if (object instanceof Exprent) {
                System.out.println(DebugPrinter.printExprent((String)indent, (Exprent)object, varProc));
                continue;
            }
            System.out.println((String)indent + object.getClass().getSimpleName());
        }
    }

    private static String printExprent(String indent, Exprent exp, VarProcessor varProc) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        BitSet values = new BitSet();
        exp.fillBytecodeRange(values);
        sb.append("(").append(values.nextSetBit(0)).append(", ").append(values.length() - 1).append(") ");
        sb.append(exp.getClass().getSimpleName());
        sb.append(" ").append(exp.id).append(" ");
        if (exp instanceof VarExprent) {
            VarExprent varExprent = (VarExprent)exp;
            int currindex = varExprent.getIndex();
            int origindex = varProc == null ? -2 : varProc.getVarOriginalIndex(currindex);
            sb.append("[").append(currindex).append(":").append(origindex).append(", ").append(varExprent.isStack()).append("]");
            if (varProc != null) {
                sb.append(varProc.getCandidates(origindex));
            }
        } else if (exp instanceof AssignmentExprent) {
            AssignmentExprent assignmentExprent = (AssignmentExprent)exp;
            sb.append("{").append(DebugPrinter.printExprent(" ", assignmentExprent.getLeft(), varProc)).append(" =").append(DebugPrinter.printExprent(" ", assignmentExprent.getRight(), varProc)).append("}");
        } else if (exp instanceof IfExprent) {
            sb.append(' ').append(exp.toJava(0, new BytecodeMappingTracer()));
        }
        return sb.toString();
    }
}

