/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.plexus;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Component;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.DeferredClass;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBeanMetadata;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBeanModule;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBeanSource;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusTypeBinder;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusXmlScanner;
import org.jetbrains.kotlin.org.eclipse.sisu.space.ClassSpace;

public final class PlexusXmlBeanModule
implements PlexusBeanModule {
    private final ClassSpace space;
    private final Map<?, ?> variables;
    private final URL plexusXml;
    private final boolean root;

    public PlexusXmlBeanModule(ClassSpace space, Map<?, ?> variables, URL plexusXml) {
        this.space = space;
        this.variables = variables;
        this.plexusXml = plexusXml;
        this.root = true;
    }

    public PlexusXmlBeanModule(ClassSpace space, Map<?, ?> variables) {
        this.space = space;
        this.variables = variables;
        this.plexusXml = null;
        this.root = false;
    }

    @Override
    public PlexusBeanSource configure(Binder binder) {
        binder.bind(ClassSpace.class).toInstance(this.space);
        PlexusTypeBinder plexusTypeBinder = new PlexusTypeBinder(binder);
        HashMap<String, PlexusBeanMetadata> metadataMap = new HashMap<String, PlexusBeanMetadata>();
        PlexusXmlScanner scanner = new PlexusXmlScanner(this.variables, this.plexusXml, metadataMap);
        String source = this.space.toString();
        for (Map.Entry<Component, DeferredClass<?>> entry : scanner.scan(this.space, this.root).entrySet()) {
            plexusTypeBinder.hear(entry.getKey(), entry.getValue(), source);
        }
        return new PlexusXmlBeanSource(metadataMap);
    }

    private static final class PlexusXmlBeanSource
    implements PlexusBeanSource {
        private Map<String, PlexusBeanMetadata> metadataMap;

        PlexusXmlBeanSource(Map<String, PlexusBeanMetadata> metadataMap) {
            this.metadataMap = metadataMap;
        }

        @Override
        public PlexusBeanMetadata getBeanMetadata(Class<?> implementation) {
            if (this.metadataMap == null) {
                return null;
            }
            PlexusBeanMetadata metadata = this.metadataMap.remove(implementation.getName());
            if (this.metadataMap.isEmpty()) {
                this.metadataMap = null;
            }
            return metadata;
        }
    }
}

