/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.customization.console;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.analysis.customization.console.ClassInfoResolver;
import com.intellij.analysis.customization.console.ProbableClassName;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.execution.filters.HyperlinkInfoFactory;
import com.intellij.execution.filters.impl.MultipleFilesHyperlinkInfoBase;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbModeBlockedFunctionality;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.awt.RelativePoint;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B3\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/analysis/customization/console/OnFlyMultipleFilesHyperlinkInfo;", "Lcom/intellij/execution/filters/impl/MultipleFilesHyperlinkInfoBase;", "myInfoCache", "Lcom/intellij/analysis/customization/console/ClassInfoResolver;", "probableClassName", "Lcom/intellij/analysis/customization/console/ProbableClassName;", "lineNumber", "", "project", "Lcom/intellij/openapi/project/Project;", "action", "Lcom/intellij/execution/filters/HyperlinkInfoFactory$HyperlinkHandler;", "<init>", "(Lcom/intellij/analysis/customization/console/ClassInfoResolver;Lcom/intellij/analysis/customization/console/ProbableClassName;ILcom/intellij/openapi/project/Project;Lcom/intellij/execution/filters/HyperlinkInfoFactory$HyperlinkHandler;)V", "getFiles", "", "Lcom/intellij/psi/PsiFile;", "showNotFound", "", "hyperlinkLocationPoint", "Lcom/intellij/ui/awt/RelativePoint;", "getDescriptor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "intellij.jvm.analysis.impl"})
@ApiStatus.Internal
public final class OnFlyMultipleFilesHyperlinkInfo
extends MultipleFilesHyperlinkInfoBase {
    @NotNull
    private final ClassInfoResolver myInfoCache;
    @NotNull
    private final ProbableClassName probableClassName;

    public OnFlyMultipleFilesHyperlinkInfo(@NotNull ClassInfoResolver myInfoCache, @NotNull ProbableClassName probableClassName, int lineNumber, @NotNull Project project, @Nullable HyperlinkInfoFactory.HyperlinkHandler action) {
        Intrinsics.checkNotNullParameter((Object)myInfoCache, (String)"myInfoCache");
        Intrinsics.checkNotNullParameter((Object)probableClassName, (String)"probableClassName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(lineNumber, project, action);
        this.myInfoCache = myInfoCache;
        this.probableClassName = probableClassName;
    }

    @NotNull
    public List<PsiFile> getFiles(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (DumbService.Companion.isDumb(project)) {
            return CollectionsKt.emptyList();
        }
        String string = StringUtil.getPackageName((String)this.probableClassName.getFullClassName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
        String packageName = string;
        if (packageName.length() == this.probableClassName.getFullClassName().length()) {
            return CollectionsKt.emptyList();
        }
        String string2 = this.probableClassName.getFullClassName().substring(packageName.length() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String className = string2;
        ClassInfoResolver.ClassResolveInfo resolvedClasses = this.myInfoCache.resolveClasses(className, packageName);
        List currentFiles = new ArrayList();
        for (VirtualFile file : resolvedClasses.getClasses().values()) {
            PsiFile psiFile;
            if (!file.isValid() || (psiFile = PsiManager.getInstance((Project)project).findFile(file)) == null) continue;
            PsiElement navigationElement = psiFile.getNavigationElement();
            if (navigationElement instanceof PsiFile) {
                currentFiles.add(navigationElement);
                continue;
            }
            currentFiles.add(psiFile);
        }
        return currentFiles;
    }

    protected void showNotFound(@NotNull Project project, @Nullable RelativePoint hyperlinkLocationPoint) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (hyperlinkLocationPoint == null) {
            return;
        }
        if (DumbService.Companion.isDumb(project)) {
            DumbService dumbService = DumbService.Companion.getInstance(project);
            String string = CodeInsightBundle.message((String)"message.navigation.is.not.available.here.during.index.update", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            dumbService.showDumbModeNotificationForFunctionality(string, DumbModeBlockedFunctionality.GotoClass);
            return;
        }
        String message = JvmAnalysisBundle.message("action.find.similar.stack.call.methods.not.found", new Object[0]);
        JComponent jComponent = HintUtil.createWarningLabel((String)message);
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"createWarningLabel(...)");
        JComponent label = jComponent;
        JBPopupFactory.getInstance().createBalloonBuilder(label).setFadeoutTime(4000L).setFillColor(HintUtil.getWarningColor()).createBalloon().show(new RelativePoint(hyperlinkLocationPoint.getScreenPoint()), Balloon.Position.above);
    }

    @Nullable
    public OpenFileDescriptor getDescriptor() {
        return null;
    }
}

