/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.telemetry;

import com.intellij.gradle.toolingExtension.impl.telemetry.GradleTelemetryFormat;
import com.intellij.util.ArrayUtilRt;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class SpanDataSerializer {
    public static byte[] serialize(@NotNull Collection<SpanData> spanData, @NotNull GradleTelemetryFormat format) {
        byte[] byArray;
        if (spanData == null) {
            SpanDataSerializer.$$$reportNull$$$0(0);
        }
        if (format == null) {
            SpanDataSerializer.$$$reportNull$$$0(1);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            if (format == GradleTelemetryFormat.PROTOBUF) {
                SpanDataSerializer.serializeIntoProtobuf(spanData, outputStream);
            } else if (format == GradleTelemetryFormat.JSON) {
                SpanDataSerializer.serializeIntoJson(spanData, outputStream);
            }
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return ArrayUtilRt.EMPTY_BYTE_ARRAY;
            }
        }
        outputStream.close();
        return byArray;
    }

    private static void serializeIntoProtobuf(@NotNull Collection<SpanData> spanData, @NotNull OutputStream outputStream) throws ReflectiveOperationException {
        if (spanData == null) {
            SpanDataSerializer.$$$reportNull$$$0(2);
        }
        if (outputStream == null) {
            SpanDataSerializer.$$$reportNull$$$0(3);
        }
        Object marshaller = Class.forName("io.opentelemetry.exporter.internal.otlp.traces.TraceRequestMarshaler").getMethod("create", Collection.class).invoke(null, spanData);
        marshaller.getClass().getMethod("writeBinaryTo", OutputStream.class).invoke(marshaller, outputStream);
    }

    private static void serializeIntoJson(@NotNull Collection<SpanData> spanData, @NotNull OutputStream outputStream) throws ReflectiveOperationException {
        if (spanData == null) {
            SpanDataSerializer.$$$reportNull$$$0(4);
        }
        if (outputStream == null) {
            SpanDataSerializer.$$$reportNull$$$0(5);
        }
        Object marshaller = Class.forName("io.opentelemetry.exporter.internal.otlp.traces.TraceRequestMarshaler").getMethod("create", Collection.class).invoke(null, spanData);
        marshaller.getClass().getMethod("writeJsonTo", OutputStream.class).invoke(marshaller, outputStream);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spanData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
        }
        objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/telemetry/SpanDataSerializer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "serializeIntoProtobuf";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "serializeIntoJson";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

