/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.RawSink;
import kotlinx.io.Segment;
import kotlinx.io._UtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lkotlinx/io/OutputStreamSink;", "Lkotlinx/io/RawSink;", "out", "Ljava/io/OutputStream;", "<init>", "(Ljava/io/OutputStream;)V", "write", "", "source", "Lkotlinx/io/Buffer;", "byteCount", "", "flush", "close", "toString", "", "kotlinx-io-core"})
@SourceDebugExtension(value={"SMAP\nJvmCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmCore.kt\nkotlinx/io/OutputStreamSink\n+ 2 -Util.kt\nkotlinx/io/_UtilKt\n*L\n1#1,116:1\n109#2:117\n*S KotlinDebug\n*F\n+ 1 JvmCore.kt\nkotlinx/io/OutputStreamSink\n*L\n47#1:117\n*E\n"})
class OutputStreamSink
implements RawSink {
    @NotNull
    private final OutputStream out;

    public OutputStreamSink(@NotNull OutputStream out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.out = out;
    }

    @Override
    public void write(@NotNull Buffer source, long byteCount) {
        int toCopy;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        _UtilKt.checkOffsetAndCount(source.getSize(), 0L, byteCount);
        for (long remaining = byteCount; remaining > 0L; remaining -= (long)toCopy) {
            Segment head;
            Intrinsics.checkNotNull((Object)source.getHead());
            int b$iv = head.getLimit() - head.getPos();
            boolean $i$f$minOf = false;
            toCopy = (int)Math.min(remaining, (long)b$iv);
            this.out.write(head.data, head.getPos(), toCopy);
            head.setPos(head.getPos() + toCopy);
            source.setSizeMut(source.getSizeMut() - (long)toCopy);
            if (head.getPos() != head.getLimit()) continue;
            source.recycleHead$kotlinx_io_core();
        }
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void close() {
        this.out.close();
    }

    @NotNull
    public String toString() {
        return "RawSink(" + this.out + ')';
    }
}

