/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.EOFException;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.CoreKt;
import kotlinx.io.InternalIoApi;
import kotlinx.io.PeekSource;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.Segment;
import kotlinx.io.SegmentPool;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import kotlinx.io._UtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0011H\u0016J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0011H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0011H\u0016J\b\u0010*\u001a\u00020 H\u0017J\b\u0010+\u001a\u00020 H\u0016J\b\u0010,\u001a\u00020 H\u0016J\"\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020\u00002\b\b\u0002\u0010/\u001a\u00020\u00112\b\b\u0002\u00100\u001a\u00020\u0011J\r\u00101\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b2J\u0011\u00103\u001a\u00020$2\u0006\u00104\u001a\u00020\u0011H\u0086\u0002J\u0006\u00105\u001a\u00020 J\u0010\u00106\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0011H\u0016J \u00107\u001a\u00020(2\u0006\u00108\u001a\u0002092\u0006\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020(H\u0016J\u0018\u00107\u001a\u00020\u00112\u0006\u00108\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0011H\u0016J\u0018\u0010:\u001a\u00020 2\u0006\u00108\u001a\u00020;2\u0006\u0010!\u001a\u00020\u0011H\u0016J\u0010\u0010<\u001a\u00020\u00112\u0006\u00108\u001a\u00020;H\u0016J\b\u0010=\u001a\u00020\u0001H\u0016J\u0010\u0010>\u001a\u00020\u00062\u0006\u0010?\u001a\u00020(H\u0001J \u0010@\u001a\u00020 2\u0006\u0010A\u001a\u0002092\u0006\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020(H\u0016J\u0018\u0010@\u001a\u00020 2\u0006\u0010A\u001a\u00020B2\u0006\u0010!\u001a\u00020\u0011H\u0016J\u0018\u0010@\u001a\u00020 2\u0006\u0010A\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0011H\u0016J\u0010\u0010C\u001a\u00020\u00112\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010D\u001a\u00020 2\u0006\u0010E\u001a\u00020$H\u0016J\u0010\u0010F\u001a\u00020 2\u0006\u0010G\u001a\u00020&H\u0016J\u0010\u0010H\u001a\u00020 2\u0006\u0010I\u001a\u00020(H\u0016J\u0010\u0010J\u001a\u00020 2\u0006\u0010K\u001a\u00020\u0011H\u0016J\u0006\u0010L\u001a\u00020\u0000J\b\u0010M\u001a\u00020 H\u0016J\b\u0010N\u001a\u00020OH\u0016J\r\u0010P\u001a\u00020 H\u0000\u00a2\u0006\u0002\bQJ\b\u0010R\u001a\u00020 H\u0001J\u001b\u0010S\u001a\u00020 2\u0006\u0010T\u001a\u00020\u00062\b\b\u0002\u0010U\u001a\u00020\u001eH\u0082\bR&\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0007\u0010\u0004\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR&\u0010\f\u001a\u0004\u0018\u00010\u00068\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\r\u0010\u0004\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\u00020\u00118\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0015\u0010\u0004\u001a\u0004\b\u0016\u0010\u0013\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u00020\u00008\u0016X\u0097\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u0004\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006V"}, d2={"Lkotlinx/io/Buffer;", "Lkotlinx/io/Source;", "Lkotlinx/io/Sink;", "<init>", "()V", "head", "Lkotlinx/io/Segment;", "getHead$annotations", "getHead", "()Lkotlinx/io/Segment;", "setHead", "(Lkotlinx/io/Segment;)V", "tail", "getTail$annotations", "getTail", "setTail", "size", "", "getSize", "()J", "sizeMut", "getSizeMut$annotations", "getSizeMut", "setSizeMut", "(J)V", "buffer", "getBuffer$annotations", "getBuffer", "()Lkotlinx/io/Buffer;", "exhausted", "", "require", "", "byteCount", "request", "readByte", "", "readShort", "", "readInt", "", "readLong", "hintEmit", "emit", "flush", "copyTo", "out", "startIndex", "endIndex", "completeSegmentByteCount", "completeSegmentByteCount$kotlinx_io_core", "get", "position", "clear", "skip", "readAtMostTo", "sink", "", "readTo", "Lkotlinx/io/RawSink;", "transferTo", "peek", "writableSegment", "minimumCapacity", "write", "source", "Lkotlinx/io/RawSource;", "transferFrom", "writeByte", "byte", "writeShort", "short", "writeInt", "int", "writeLong", "long", "copy", "close", "toString", "", "recycleHead", "recycleHead$kotlinx_io_core", "recycleTail", "pushSegment", "newTail", "tryCompact", "kotlinx-io-core"})
@SourceDebugExtension(value={"SMAP\nBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Buffer.kt\nkotlinx/io/Buffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 -Util.kt\nkotlinx/io/_UtilKt\n+ 4 Buffer.kt\nkotlinx/io/BufferKt\n*L\n1#1,738:1\n687#1,14:760\n689#1,12:812\n1#2:739\n1#2:798\n1#2:803\n1#2:806\n1#2:810\n97#3:740\n97#3:741\n97#3:742\n97#3:743\n97#3:744\n97#3:745\n97#3:746\n97#3:747\n97#3:748\n97#3:749\n106#3:750\n106#3:751\n100#3:752\n100#3:753\n100#3:754\n100#3:755\n100#3:756\n100#3:757\n100#3:758\n100#3:759\n52#3:797\n53#3:799\n109#3:800\n38#3:801\n52#3:802\n53#3:804\n52#3:805\n53#3:807\n38#3:808\n52#3:809\n53#3:811\n112#3:824\n713#4,23:774\n*S KotlinDebug\n*F\n+ 1 Buffer.kt\nkotlinx/io/Buffer\n*L\n252#1:760,14\n515#1:812,12\n311#1:798\n347#1:803\n355#1:806\n419#1:810\n107#1:740\n112#1:741\n134#1:742\n135#1:743\n136#1:744\n137#1:745\n143#1:746\n144#1:747\n145#1:748\n146#1:749\n169#1:750\n170#1:751\n176#1:752\n177#1:753\n178#1:754\n179#1:755\n180#1:756\n181#1:757\n182#1:758\n183#1:759\n311#1:797\n311#1:799\n316#1:800\n328#1:801\n347#1:802\n347#1:804\n355#1:805\n355#1:807\n399#1:808\n419#1:809\n419#1:811\n616#1:824\n291#1:774,23\n*E\n"})
public final class Buffer
implements Source,
Sink {
    @Nullable
    private Segment head;
    @Nullable
    private Segment tail;
    private long sizeMut;
    @NotNull
    private final Buffer buffer = this;

    public final /* synthetic */ Segment getHead() {
        return this.head;
    }

    public final /* synthetic */ void setHead(Segment segment) {
        this.head = segment;
    }

    @PublishedApi
    public static /* synthetic */ void getHead$annotations() {
    }

    public final /* synthetic */ Segment getTail() {
        return this.tail;
    }

    public final /* synthetic */ void setTail(Segment segment) {
        this.tail = segment;
    }

    @PublishedApi
    public static /* synthetic */ void getTail$annotations() {
    }

    public final long getSize() {
        return this.sizeMut;
    }

    public final /* synthetic */ long getSizeMut() {
        return this.sizeMut;
    }

    public final /* synthetic */ void setSizeMut(long l) {
        this.sizeMut = l;
    }

    @PublishedApi
    public static /* synthetic */ void getSizeMut$annotations() {
    }

    @Override
    @NotNull
    public Buffer getBuffer() {
        return this.buffer;
    }

    @InternalIoApi
    public static /* synthetic */ void getBuffer$annotations() {
    }

    @Override
    public boolean exhausted() {
        return this.getSize() == 0L;
    }

    @Override
    public void require(long byteCount) {
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount: " + byteCount;
            throw new IllegalArgumentException(string.toString());
        }
        if (this.getSize() < byteCount) {
            throw new EOFException("Buffer doesn't contain required number of bytes (size: " + this.getSize() + ", required: " + byteCount + ')');
        }
    }

    @Override
    public boolean request(long byteCount) {
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount: " + byteCount + " < 0";
            throw new IllegalArgumentException(string.toString());
        }
        return this.getSize() >= byteCount;
    }

    @Override
    public byte readByte() {
        this.require(1L);
        Segment segment = this.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment segment2 = segment;
        int pos = segment2.getPos();
        int limit = segment2.getLimit();
        byte[] data = segment2.data;
        byte b = data[pos++];
        --this.sizeMut;
        if (pos == limit) {
            this.recycleHead$kotlinx_io_core();
        } else {
            segment2.setPos(pos);
        }
        return b;
    }

    @Override
    public short readShort() {
        byte $this$and$iv;
        this.require(2L);
        Segment segment = this.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment segment2 = segment;
        int pos = segment2.getPos();
        int limit = segment2.getLimit();
        if (limit - pos < 2) {
            byte $this$and$iv2;
            byte by = this.readByte();
            int other$iv = 255;
            boolean $i$f$and = false;
            int n = ($this$and$iv2 & other$iv) << 8;
            $this$and$iv2 = this.readByte();
            other$iv = 255;
            $i$f$and = false;
            int s = n | $this$and$iv2 & other$iv;
            return (short)s;
        }
        byte[] data = segment2.data;
        byte other$iv = data[pos++];
        int other$iv2 = 255;
        boolean $i$f$and = false;
        int n = ($this$and$iv & other$iv2) << 8;
        $this$and$iv = data[pos++];
        other$iv2 = 255;
        $i$f$and = false;
        int s = n | $this$and$iv & other$iv2;
        this.sizeMut -= 2L;
        if (pos == limit) {
            this.recycleHead$kotlinx_io_core();
        } else {
            segment2.setPos(pos);
        }
        return (short)s;
    }

    @Override
    public int readInt() {
        byte $this$and$iv;
        this.require(4L);
        Segment segment = this.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment segment2 = segment;
        int pos = segment2.getPos();
        int limit = segment2.getLimit();
        if ((long)(limit - pos) < 4L) {
            byte $this$and$iv2;
            byte by = this.readByte();
            int other$iv = 255;
            boolean $i$f$and = false;
            int n = ($this$and$iv2 & other$iv) << 24;
            $this$and$iv2 = this.readByte();
            other$iv = 255;
            $i$f$and = false;
            int n2 = n | ($this$and$iv2 & other$iv) << 16;
            $this$and$iv2 = this.readByte();
            other$iv = 255;
            $i$f$and = false;
            int n3 = n2 | ($this$and$iv2 & other$iv) << 8;
            $this$and$iv2 = this.readByte();
            other$iv = 255;
            $i$f$and = false;
            return n3 | $this$and$iv2 & other$iv;
        }
        byte[] data = segment2.data;
        byte $i$f$and = data[pos++];
        int other$iv = 255;
        boolean $i$f$and2 = false;
        int n = ($this$and$iv & other$iv) << 24;
        $this$and$iv = data[pos++];
        other$iv = 255;
        $i$f$and2 = false;
        int n4 = n | ($this$and$iv & other$iv) << 16;
        $this$and$iv = data[pos++];
        other$iv = 255;
        $i$f$and2 = false;
        int n5 = n4 | ($this$and$iv & other$iv) << 8;
        $this$and$iv = data[pos++];
        other$iv = 255;
        $i$f$and2 = false;
        int i = n5 | $this$and$iv & other$iv;
        this.sizeMut -= 4L;
        if (pos == limit) {
            this.recycleHead$kotlinx_io_core();
        } else {
            segment2.setPos(pos);
        }
        return i;
    }

    @Override
    public long readLong() {
        byte $this$and$iv;
        this.require(8L);
        Segment segment = this.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment segment2 = segment;
        int pos = segment2.getPos();
        int limit = segment2.getLimit();
        if ((long)(limit - pos) < 8L) {
            int $this$and$iv2;
            int n = this.readInt();
            long other$iv = 0xFFFFFFFFL;
            boolean $i$f$and = false;
            long l = ((long)$this$and$iv2 & other$iv) << 32;
            $this$and$iv2 = this.readInt();
            other$iv = 0xFFFFFFFFL;
            $i$f$and = false;
            return l | (long)$this$and$iv2 & other$iv;
        }
        byte[] data = segment2.data;
        byte $i$f$and = data[pos++];
        long other$iv = 255L;
        boolean $i$f$and2 = false;
        long l = ((long)$this$and$iv & other$iv) << 56;
        $this$and$iv = data[pos++];
        other$iv = 255L;
        $i$f$and2 = false;
        long l2 = l | ((long)$this$and$iv & other$iv) << 48;
        $this$and$iv = data[pos++];
        other$iv = 255L;
        $i$f$and2 = false;
        long l3 = l2 | ((long)$this$and$iv & other$iv) << 40;
        $this$and$iv = data[pos++];
        other$iv = 255L;
        $i$f$and2 = false;
        long l4 = l3 | ((long)$this$and$iv & other$iv) << 32;
        $this$and$iv = data[pos++];
        other$iv = 255L;
        $i$f$and2 = false;
        long l5 = l4 | ((long)$this$and$iv & other$iv) << 24;
        $this$and$iv = data[pos++];
        other$iv = 255L;
        $i$f$and2 = false;
        long l6 = l5 | ((long)$this$and$iv & other$iv) << 16;
        $this$and$iv = data[pos++];
        other$iv = 255L;
        $i$f$and2 = false;
        long l7 = l6 | ((long)$this$and$iv & other$iv) << 8;
        $this$and$iv = data[pos++];
        other$iv = 255L;
        $i$f$and2 = false;
        long v = l7 | (long)$this$and$iv & other$iv;
        this.sizeMut -= 8L;
        if (pos == limit) {
            this.recycleHead$kotlinx_io_core();
        } else {
            segment2.setPos(pos);
        }
        return v;
    }

    @Override
    @InternalIoApi
    public void hintEmit() {
    }

    @Override
    public void emit() {
    }

    @Override
    public void flush() {
    }

    public final void copyTo(@NotNull Buffer out, long startIndex, long endIndex) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        _UtilKt.checkBounds(this.getSize(), startIndex, endIndex);
        if (startIndex == endIndex) {
            return;
        }
        long currentOffset = startIndex;
        long remainingByteCount = endIndex - startIndex;
        out.sizeMut += remainingByteCount;
        Segment s = this.head;
        while (true) {
            Segment segment = s;
            Intrinsics.checkNotNull((Object)segment);
            if (currentOffset < (long)(segment.getLimit() - s.getPos())) break;
            currentOffset -= (long)(s.getLimit() - s.getPos());
            s = s.getNext();
        }
        while (remainingByteCount > 0L) {
            Segment segment = s;
            Intrinsics.checkNotNull((Object)segment);
            Segment copy = segment.sharedCopy$kotlinx_io_core();
            copy.setPos(copy.getPos() + (int)currentOffset);
            copy.setLimit(Math.min(copy.getPos() + (int)remainingByteCount, copy.getLimit()));
            boolean tryCompact$iv = false;
            boolean $i$f$pushSegment = false;
            if (out.getHead() == null) {
                out.setHead(copy);
                out.setTail(copy);
            } else {
                Segment segment2 = out.getTail();
                Intrinsics.checkNotNull((Object)segment2);
                out.setTail(segment2.push$kotlinx_io_core(copy));
            }
            remainingByteCount -= (long)(copy.getLimit() - copy.getPos());
            currentOffset = 0L;
            s = s.getNext();
        }
    }

    public static /* synthetic */ void copyTo$default(Buffer buffer, Buffer buffer2, long l, long l2, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            l2 = buffer.getSize();
        }
        buffer.copyTo(buffer2, l, l2);
    }

    public final long completeSegmentByteCount$kotlinx_io_core() {
        long result = this.getSize();
        if (result == 0L) {
            return 0L;
        }
        Segment segment = this.tail;
        Intrinsics.checkNotNull((Object)segment);
        Segment tail = segment;
        if (tail.getLimit() < 8192 && tail.owner) {
            result -= (long)(tail.getLimit() - tail.getPos());
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final byte get(long position) {
        void offset;
        long nextOffset$iv;
        Segment s$iv;
        if (position < 0L || position >= this.getSize()) {
            throw new IndexOutOfBoundsException("position (" + position + ") is not within the range [0..size(" + this.getSize() + "))");
        }
        Buffer $this$seek$iv = this;
        boolean $i$f$seek = false;
        if ($this$seek$iv.getHead() == null) {
            void offset2;
            long l = -1L;
            Segment s = null;
            boolean bl = false;
            Segment segment = s;
            Intrinsics.checkNotNull(segment);
            return segment.data[(int)((long)s.getPos() + position - offset2)];
        }
        if ($this$seek$iv.getSize() - position < position) {
            void offset3;
            Segment s$iv2;
            long offset$iv = $this$seek$iv.getSize();
            for (s$iv2 = $this$seek$iv.getTail(); s$iv2 != null && offset$iv > position && (offset$iv -= (long)(s$iv2.getLimit() - s$iv2.getPos())) > position; s$iv2 = s$iv2.getPrev()) {
            }
            long l = offset$iv;
            Segment s = s$iv2;
            boolean bl = false;
            Segment segment = s;
            Intrinsics.checkNotNull((Object)segment);
            return segment.data[(int)((long)s.getPos() + position - offset3)];
        }
        long offset$iv = 0L;
        for (s$iv = $this$seek$iv.getHead(); s$iv != null && (nextOffset$iv = offset$iv + (long)(s$iv.getLimit() - s$iv.getPos())) <= position; s$iv = s$iv.getNext()) {
            offset$iv = nextOffset$iv;
        }
        long l = offset$iv;
        Segment s = s$iv;
        boolean bl = false;
        Segment segment = s;
        Intrinsics.checkNotNull((Object)segment);
        return segment.data[(int)((long)s.getPos() + position - offset)];
    }

    public final void clear() {
        this.skip(this.getSize());
    }

    @Override
    public void skip(long byteCount) {
        int toSkip;
        boolean $i$f$checkByteCount = false;
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount (" + byteCount + ") < 0";
            throw new IllegalArgumentException(string.toString());
        }
        for (long remainingByteCount = byteCount; remainingByteCount > 0L; remainingByteCount -= (long)toSkip) {
            Segment head;
            if (this.head == null) {
                throw new EOFException("Buffer exhausted before skipping " + byteCount + " bytes.");
            }
            int b$iv = head.getLimit() - head.getPos();
            boolean $i$f$minOf = false;
            toSkip = (int)Math.min(remainingByteCount, (long)b$iv);
            this.sizeMut -= (long)toSkip;
            head.setPos(head.getPos() + toSkip);
            if (head.getPos() != head.getLimit()) continue;
            this.recycleHead$kotlinx_io_core();
        }
    }

    @Override
    public int readAtMostTo(@NotNull byte[] sink, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        int size$iv = sink.length;
        boolean $i$f$checkBounds = false;
        _UtilKt.checkBounds((long)size$iv, (long)startIndex, (long)endIndex);
        Segment segment = this.head;
        if (segment == null) {
            return -1;
        }
        Segment s = segment;
        int toCopy = Math.min(endIndex - startIndex, s.getLimit() - s.getPos());
        ArraysKt.copyInto((byte[])s.data, (byte[])sink, (int)startIndex, (int)s.getPos(), (int)(s.getPos() + toCopy));
        s.setPos(s.getPos() + toCopy);
        this.sizeMut -= (long)toCopy;
        if (s.getPos() == s.getLimit()) {
            this.recycleHead$kotlinx_io_core();
        }
        return toCopy;
    }

    @Override
    public long readAtMostTo(@NotNull Buffer sink, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        boolean $i$f$checkByteCount = false;
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount (" + byteCount + ") < 0";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.getSize() == 0L) {
            return -1L;
        }
        long bytesWritten = byteCount > this.getSize() ? this.getSize() : byteCount;
        sink.write(this, bytesWritten);
        return bytesWritten;
    }

    @Override
    public void readTo(@NotNull RawSink sink, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        boolean $i$f$checkByteCount = false;
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount (" + byteCount + ") < 0";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.getSize() < byteCount) {
            sink.write(this, this.getSize());
            throw new EOFException("Buffer exhausted before writing " + byteCount + " bytes. Only " + this.getSize() + " bytes were written.");
        }
        sink.write(this, byteCount);
    }

    @Override
    public long transferTo(@NotNull RawSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        long byteCount = this.getSize();
        if (byteCount > 0L) {
            sink.write(this, byteCount);
        }
        return byteCount;
    }

    @Override
    @NotNull
    public Source peek() {
        return CoreKt.buffered(new PeekSource(this));
    }

    @PublishedApi
    public final /* synthetic */ Segment writableSegment(int minimumCapacity) {
        if (!(minimumCapacity >= 1 && minimumCapacity <= 8192)) {
            boolean $i$a$-require-Buffer$writableSegment$22 = false;
            String $i$a$-require-Buffer$writableSegment$22 = "unexpected capacity";
            throw new IllegalArgumentException($i$a$-require-Buffer$writableSegment$22.toString());
        }
        if (this.tail == null) {
            Segment result;
            this.head = result = SegmentPool.take();
            this.tail = result;
            return result;
        }
        Segment segment = this.tail;
        Intrinsics.checkNotNull((Object)segment);
        Segment t = segment;
        if (t.getLimit() + minimumCapacity > 8192 || !t.owner) {
            Segment newTail;
            this.tail = newTail = t.push$kotlinx_io_core(SegmentPool.take());
            return newTail;
        }
        return t;
    }

    @Override
    public void write(@NotNull byte[] source, int startIndex, int endIndex) {
        int toCopy;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        int size$iv = source.length;
        boolean $i$f$checkBounds = false;
        _UtilKt.checkBounds((long)size$iv, (long)startIndex, (long)endIndex);
        for (int currentOffset = startIndex; currentOffset < endIndex; currentOffset += toCopy) {
            Segment tail = this.writableSegment(1);
            toCopy = Math.min(endIndex - currentOffset, 8192 - tail.getLimit());
            ArraysKt.copyInto((byte[])source, (byte[])tail.data, (int)tail.getLimit(), (int)currentOffset, (int)(currentOffset + toCopy));
            tail.setLimit(tail.getLimit() + toCopy);
        }
        this.sizeMut += (long)(endIndex - startIndex);
    }

    @Override
    public void write(@NotNull RawSource source, long byteCount) {
        long read;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        boolean $i$f$checkByteCount = false;
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount (" + byteCount + ") < 0";
            throw new IllegalArgumentException(string.toString());
        }
        for (long remainingByteCount = byteCount; remainingByteCount > 0L; remainingByteCount -= read) {
            read = source.readAtMostTo(this, remainingByteCount);
            if (read != -1L) continue;
            throw new EOFException("Source exhausted before reading " + byteCount + " bytes. Only " + (byteCount - remainingByteCount) + " were read.");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull Buffer source, long byteCount) {
        long movedByteCount;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!(source != this)) {
            boolean bl = false;
            String string = "source == this";
            throw new IllegalArgumentException(string.toString());
        }
        _UtilKt.checkOffsetAndCount(source.sizeMut, 0L, byteCount);
        for (long remainingByteCount = byteCount; remainingByteCount > 0L; remainingByteCount -= movedByteCount) {
            void this_$iv;
            Segment segmentToMove;
            Segment segment = source.head;
            Intrinsics.checkNotNull((Object)segment);
            if (remainingByteCount < (long)segment.getSize()) {
                Segment tail = this.tail;
                if (tail != null && tail.owner && remainingByteCount + (long)tail.getLimit() - (long)(tail.getShared$kotlinx_io_core() ? 0 : tail.getPos()) <= 8192L) {
                    Segment segment2 = source.head;
                    Intrinsics.checkNotNull((Object)segment2);
                    segment2.writeTo$kotlinx_io_core(tail, (int)remainingByteCount);
                    source.sizeMut -= remainingByteCount;
                    this.sizeMut += remainingByteCount;
                    return;
                }
                Segment segment3 = source.head;
                Intrinsics.checkNotNull((Object)segment3);
                source.head = segment3.split$kotlinx_io_core((int)remainingByteCount);
            }
            Intrinsics.checkNotNull((Object)source.head);
            movedByteCount = segmentToMove.getSize();
            source.head = segmentToMove.pop$kotlinx_io_core();
            if (source.head == null) {
                source.tail = null;
            }
            Buffer buffer = this;
            boolean tryCompact$iv = true;
            boolean $i$f$pushSegment = false;
            if (this_$iv.getHead() == null) {
                this_$iv.setHead(segmentToMove);
                this_$iv.setTail(segmentToMove);
            } else {
                Segment segment4 = this_$iv.getTail();
                Intrinsics.checkNotNull((Object)segment4);
                this_$iv.setTail(segment4.push$kotlinx_io_core(segmentToMove).compact$kotlinx_io_core());
                Segment segment5 = this_$iv.getTail();
                Intrinsics.checkNotNull((Object)segment5);
                if (segment5.getPrev() == null) {
                    this_$iv.setHead(this_$iv.getTail());
                }
            }
            source.sizeMut -= movedByteCount;
            this.sizeMut += movedByteCount;
        }
    }

    @Override
    public long transferFrom(@NotNull RawSource source) {
        long readCount;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        long totalBytesRead = 0L;
        while ((readCount = source.readAtMostTo(this, 8192L)) != -1L) {
            totalBytesRead += readCount;
        }
        return totalBytesRead;
    }

    @Override
    public void writeByte(byte by) {
        Segment tail = this.writableSegment(1);
        byte[] byArray = tail.data;
        int n = tail.getLimit();
        tail.setLimit(n + 1);
        byArray[n] = by;
        ++this.sizeMut;
    }

    @Override
    public void writeShort(short s) {
        Segment tail = this.writableSegment(2);
        byte[] data = tail.data;
        int limit = tail.getLimit();
        data[limit++] = (byte)(s >>> 8 & 0xFF);
        data[limit++] = (byte)(s & 0xFF);
        tail.setLimit(limit);
        this.sizeMut += 2L;
    }

    @Override
    public void writeInt(int n) {
        Segment tail = this.writableSegment(4);
        byte[] data = tail.data;
        int limit = tail.getLimit();
        data[limit++] = (byte)(n >>> 24 & 0xFF);
        data[limit++] = (byte)(n >>> 16 & 0xFF);
        data[limit++] = (byte)(n >>> 8 & 0xFF);
        data[limit++] = (byte)(n & 0xFF);
        tail.setLimit(limit);
        this.sizeMut += 4L;
    }

    @Override
    public void writeLong(long l) {
        Segment tail = this.writableSegment(8);
        byte[] data = tail.data;
        int limit = tail.getLimit();
        data[limit++] = (byte)(l >>> 56 & 0xFFL);
        data[limit++] = (byte)(l >>> 48 & 0xFFL);
        data[limit++] = (byte)(l >>> 40 & 0xFFL);
        data[limit++] = (byte)(l >>> 32 & 0xFFL);
        data[limit++] = (byte)(l >>> 24 & 0xFFL);
        data[limit++] = (byte)(l >>> 16 & 0xFFL);
        data[limit++] = (byte)(l >>> 8 & 0xFFL);
        data[limit++] = (byte)(l & 0xFFL);
        tail.setLimit(limit);
        this.sizeMut += 8L;
    }

    @NotNull
    public final Buffer copy() {
        Segment headCopy;
        Buffer result = new Buffer();
        if (this.getSize() == 0L) {
            return result;
        }
        Segment segment = this.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment head = segment;
        result.head = headCopy = head.sharedCopy$kotlinx_io_core();
        result.tail = headCopy;
        for (Segment s = head.getNext(); s != null; s = s.getNext()) {
            Segment segment2 = result.tail;
            Intrinsics.checkNotNull((Object)segment2);
            result.tail = segment2.push$kotlinx_io_core(s.sharedCopy$kotlinx_io_core());
        }
        result.sizeMut = this.getSize();
        return result;
    }

    @Override
    public void close() {
    }

    @NotNull
    public String toString() {
        if (this.getSize() == 0L) {
            return "Buffer(size=0)";
        }
        int maxPrintableBytes = 64;
        long b$iv = this.getSize();
        boolean $i$f$minOf = false;
        int len = (int)Math.min((long)maxPrintableBytes, b$iv);
        StringBuilder builder = new StringBuilder(len * 2 + (this.getSize() > (long)maxPrintableBytes ? 1 : 0));
        Segment segment = this.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment curr = segment;
        int pos = curr.getPos();
        for (int bytesWritten = 0; bytesWritten < len; ++bytesWritten) {
            if (pos == curr.getLimit()) {
                Intrinsics.checkNotNull((Object)curr.getNext());
                pos = curr.getPos();
            }
            byte b = curr.data[pos++];
            builder.append(_UtilKt.getHEX_DIGIT_CHARS()[b >> 4 & 0xF]).append(_UtilKt.getHEX_DIGIT_CHARS()[b & 0xF]);
        }
        if (this.getSize() > (long)maxPrintableBytes) {
            builder.append('\u2026');
        }
        return "Buffer(size=" + this.getSize() + " hex=" + builder + ')';
    }

    public final void recycleHead$kotlinx_io_core() {
        Segment nextHead;
        Segment segment = this.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment oldHead = segment;
        this.head = nextHead = oldHead.getNext();
        if (nextHead == null) {
            this.tail = null;
        } else {
            nextHead.setPrev(null);
        }
        oldHead.setNext(null);
        SegmentPool.recycle(oldHead);
    }

    @PublishedApi
    public final /* synthetic */ void recycleTail() {
        Segment newTail;
        Segment segment = this.tail;
        Intrinsics.checkNotNull((Object)segment);
        Segment oldTail = segment;
        this.tail = newTail = oldTail.getPrev();
        if (newTail == null) {
            this.head = null;
        } else {
            newTail.setNext(null);
        }
        oldTail.setPrev(null);
        SegmentPool.recycle(oldTail);
    }

    private final void pushSegment(Segment newTail, boolean tryCompact) {
        boolean $i$f$pushSegment = false;
        if (this.getHead() == null) {
            this.setHead(newTail);
            this.setTail(newTail);
        } else if (tryCompact) {
            Segment segment = this.getTail();
            Intrinsics.checkNotNull((Object)segment);
            this.setTail(segment.push$kotlinx_io_core(newTail).compact$kotlinx_io_core());
            Segment segment2 = this.getTail();
            Intrinsics.checkNotNull((Object)segment2);
            if (segment2.getPrev() == null) {
                this.setHead(this.getTail());
            }
        } else {
            Segment segment = this.getTail();
            Intrinsics.checkNotNull((Object)segment);
            this.setTail(segment.push$kotlinx_io_core(newTail));
        }
    }

    static /* synthetic */ void pushSegment$default(Buffer $this, Segment newTail, boolean tryCompact, int n, Object object) {
        if ((n & 2) != 0) {
            tryCompact = false;
        }
        boolean $i$f$pushSegment = false;
        if ($this.getHead() == null) {
            $this.setHead(newTail);
            $this.setTail(newTail);
        } else if (tryCompact) {
            Segment segment = $this.getTail();
            Intrinsics.checkNotNull((Object)segment);
            $this.setTail(segment.push$kotlinx_io_core(newTail).compact$kotlinx_io_core());
            Segment segment2 = $this.getTail();
            Intrinsics.checkNotNull((Object)segment2);
            if (segment2.getPrev() == null) {
                $this.setHead($this.getTail());
            }
        } else {
            Segment segment = $this.getTail();
            Intrinsics.checkNotNull((Object)segment);
            $this.setTail(segment.push$kotlinx_io_core(newTail));
        }
    }
}

