/*
 * Decompiled with CFR 0.152.
 */
package korlibs.crypto.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0017\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0000\u001a0\u0010\u0000\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0000\u001a \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0004H\u0000\u001a \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\bH\u0000\u001a\u001a\u0010\u0010\u001a\u00020\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u0004H\u0000\u001a\u0015\u0010\u0013\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0080\b\u001a\u0014\u0010\u0014\u001a\u00020\u0004*\u00020\u00012\u0006\u0010\f\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u0015\u001a\u00020\u0004*\u00020\u00012\u0006\u0010\f\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u0016\u001a\u00020\u0004*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u0018\u001a\u00020\u0004*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u0019\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u001b\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0000\u001a\u001c\u0010\u001d\u001a\u00020\n*\u00020\u00012\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0000\u001a\f\u0010\u001f\u001a\u00020\u0001*\u00020\bH\u0000\u001a\f\u0010 \u001a\u00020\b*\u00020\u0001H\u0000\u00a8\u0006!"}, d2={"arraycopy", "", "src", "srcPos", "", "dst", "dstPos", "count", "", "arrayxor", "", "data", "offset", "xor", "size", "xoroffset", "getIV", "srcIV", "blockSize", "ext8", "getInt", "getu", "readS32_be", "o", "readU8", "rotateLeft", "bits", "rotateRight", "amount", "setInt", "value", "toByteArray", "toIntArray", "krypto"})
@SourceDebugExtension(value={"SMAP\nKryptoTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KryptoTools.kt\nkorlibs/crypto/internal/KryptoToolsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
public final class KryptoToolsKt {
    public static final int ext8(int $this$ext8, int offset) {
        boolean $i$f$ext8 = false;
        return $this$ext8 >>> offset & 0xFF;
    }

    public static final int rotateRight(int $this$rotateRight, int amount) {
        return $this$rotateRight >>> amount | $this$rotateRight << 32 - amount;
    }

    public static final int rotateLeft(int $this$rotateLeft, int bits) {
        return $this$rotateLeft << bits | $this$rotateLeft >>> 32 - bits;
    }

    @NotNull
    public static final byte[] arraycopy(@NotNull byte[] src, int srcPos, @NotNull byte[] dst, int dstPos, int count) {
        return ArraysKt.copyInto((byte[])src, (byte[])dst, (int)dstPos, (int)srcPos, (int)(srcPos + count));
    }

    @NotNull
    public static final int[] arraycopy(@NotNull int[] src, int srcPos, @NotNull int[] dst, int dstPos, int count) {
        return ArraysKt.copyInto((int[])src, (int[])dst, (int)dstPos, (int)srcPos, (int)(srcPos + count));
    }

    public static final int readU8(@NotNull byte[] $this$readU8, int o) {
        return $this$readU8[o] & 0xFF;
    }

    public static final int readS32_be(@NotNull byte[] $this$readS32_be, int o) {
        return KryptoToolsKt.readU8($this$readS32_be, o + 3) << 0 | KryptoToolsKt.readU8($this$readS32_be, o + 2) << 8 | KryptoToolsKt.readU8($this$readS32_be, o + 1) << 16 | KryptoToolsKt.readU8($this$readS32_be, o + 0) << 24;
    }

    public static final int getu(@NotNull byte[] $this$getu, int offset) {
        return $this$getu[offset] & 0xFF;
    }

    public static final int getInt(@NotNull byte[] $this$getInt, int offset) {
        return KryptoToolsKt.getu($this$getInt, offset + 0) << 24 | KryptoToolsKt.getu($this$getInt, offset + 1) << 16 | KryptoToolsKt.getu($this$getInt, offset + 2) << 8 | KryptoToolsKt.getu($this$getInt, offset + 3) << 0;
    }

    public static final void setInt(@NotNull byte[] $this$setInt, int offset, int value) {
        $this$setInt[offset + 0] = (byte)(value >> 24 & 0xFF);
        $this$setInt[offset + 1] = (byte)(value >> 16 & 0xFF);
        $this$setInt[offset + 2] = (byte)(value >> 8 & 0xFF);
        $this$setInt[offset + 3] = (byte)(value >> 0 & 0xFF);
    }

    @NotNull
    public static final int[] toIntArray(@NotNull byte[] $this$toIntArray) {
        int[] nArray;
        int[] it = nArray = new int[$this$toIntArray.length / 4];
        boolean bl = false;
        int n = it.length;
        for (int n2 = 0; n2 < n; ++n2) {
            it[n2] = KryptoToolsKt.getInt($this$toIntArray, n2 * 4);
        }
        return nArray;
    }

    @NotNull
    public static final byte[] toByteArray(@NotNull int[] $this$toByteArray) {
        byte[] byArray;
        byte[] it = byArray = new byte[$this$toByteArray.length * 4];
        boolean bl = false;
        int n = $this$toByteArray.length;
        for (int n2 = 0; n2 < n; ++n2) {
            KryptoToolsKt.setInt(it, n2 * 4, $this$toByteArray[n2]);
        }
        return byArray;
    }

    @NotNull
    public static final byte[] getIV(@Nullable byte[] srcIV, int blockSize) {
        if (srcIV == null) {
            String string = "IV not provided";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        if (srcIV.length < blockSize) {
            throw new IllegalArgumentException("Wrong IV length: must be " + blockSize + " bytes long");
        }
        byte[] byArray = Arrays.copyOf(srcIV, blockSize);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, newSize)");
        return byArray;
    }

    public static final void arrayxor(@NotNull byte[] data, int offset, @NotNull byte[] xor) {
        int n = xor.length;
        for (int n2 = 0; n2 < n; ++n2) {
            data[offset + n2] = (byte)(data[offset + n2] ^ xor[n2]);
        }
    }

    public static final void arrayxor(@NotNull int[] data, int offset, @NotNull int[] xor) {
        int n = xor.length;
        for (int n2 = 0; n2 < n; ++n2) {
            data[offset + n2] = data[offset + n2] ^ xor[n2];
        }
    }

    public static final void arrayxor(@NotNull byte[] data, int offset, int size2, @NotNull byte[] xor, int xoroffset) {
        for (int n = 0; n < size2; ++n) {
            data[offset + n] = (byte)(data[offset + n] ^ xor[xoroffset + n]);
        }
    }
}

