/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.debugger.impl.frontend.evaluate.quick.common;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorMouseHoverPopupManager;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.debugger.impl.frontend.evaluate.quick.XQuickEvaluateHandler;
import com.intellij.platform.debugger.impl.frontend.evaluate.quick.common.RemoteValueHint;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.evaluate.ValueLookupManagerController;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.QuickEvaluateHandler;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ValueLookupManager
implements EditorMouseMotionListener,
EditorMouseListener {
    private final Project myProject;
    private final Alarm myAlarm;
    private HintRequest myHintRequest;
    private AbstractValueHint myCurrentHint;
    @NotNull
    private final QuickEvaluateHandler myXQuickEvaluateHandler;
    private boolean myListening;

    public ValueLookupManager(@NotNull Project project) {
        if (project == null) {
            ValueLookupManager.$$$reportNull$$$0(0);
        }
        this.myHintRequest = null;
        this.myCurrentHint = null;
        this.myXQuickEvaluateHandler = new XQuickEvaluateHandler();
        this.myProject = project;
        this.myAlarm = new Alarm((Disposable)project);
    }

    public void startListening() {
        if (!this.myListening) {
            this.myListening = true;
            EditorFactory.getInstance().getEventMulticaster().addEditorMouseMotionListener((EditorMouseMotionListener)this, (Disposable)this.myProject);
            EditorFactory.getInstance().getEventMulticaster().addEditorMouseListener((EditorMouseListener)this, (Disposable)this.myProject);
        }
    }

    public void mouseExited(@NotNull EditorMouseEvent e) {
        if (e == null) {
            ValueLookupManager.$$$reportNull$$$0(1);
        }
        this.cancelAll();
    }

    private void cancelAll() {
        this.myAlarm.cancelAllRequests();
        if (this.myHintRequest != null) {
            this.myHintRequest.cancellableHint.tryCancel();
            this.myHintRequest = null;
        }
    }

    public void mouseMoved(@NotNull EditorMouseEvent e) {
        if (e == null) {
            ValueLookupManager.$$$reportNull$$$0(2);
        }
        if (e.isConsumed() || !Registry.is((String)"debugger.valueTooltipAutoShow")) {
            return;
        }
        Editor editor = e.getEditor();
        if (editor.getProject() != null && editor.getProject() != this.myProject) {
            return;
        }
        ValueHintType type = AbstractValueHint.getHintType((EditorMouseEvent)e);
        if (e.getArea() != EditorMouseEventArea.EDITING_AREA || ValueLookupManagerController.DISABLE_VALUE_LOOKUP.get((UserDataHolder)editor) == Boolean.TRUE || type == null) {
            this.cancelAll();
            return;
        }
        if (type == ValueHintType.MOUSE_OVER_HINT && !ApplicationManager.getApplication().isActive()) {
            this.hideHint();
            return;
        }
        if (type != ValueHintType.MOUSE_CLICK_HINT && (this.myHintRequest != null && this.myHintRequest.type == ValueHintType.MOUSE_CLICK_HINT || this.myCurrentHint != null && this.myCurrentHint.getType() == ValueHintType.MOUSE_CLICK_HINT)) {
            return;
        }
        Point point = e.getMouseEvent().getPoint();
        if (this.myXQuickEvaluateHandler.isEnabled(this.myProject)) {
            this.requestHint(this.myXQuickEvaluateHandler, editor, point, e, type);
            return;
        }
        for (DebuggerSupport support : DebuggerSupport.getDebuggerSupports()) {
            QuickEvaluateHandler handler = support.getQuickEvaluateHandler();
            if (!handler.isEnabled(this.myProject)) continue;
            this.requestHint(handler, editor, point, e, type);
            return;
        }
        this.hideHint();
    }

    private void requestHint(QuickEvaluateHandler handler, Editor editor, Point point, @NotNull EditorMouseEvent e, @NotNull ValueHintType type) {
        if (e == null) {
            ValueLookupManager.$$$reportNull$$$0(3);
        }
        if (type == null) {
            ValueLookupManager.$$$reportNull$$$0(4);
        }
        Rectangle area = editor.getScrollingModel().getVisibleArea();
        this.cancelAll();
        if (type == ValueHintType.MOUSE_OVER_HINT) {
            if (Registry.is((String)"debugger.valueTooltipAutoShow")) {
                this.myAlarm.addRequest(() -> {
                    if (area.equals(editor.getScrollingModel().getVisibleArea())) {
                        this.showHint(handler, editor, point, e, type);
                    }
                }, this.getDelay(handler));
            }
        } else {
            this.showHint(handler, editor, point, e, type);
        }
    }

    private int getDelay(QuickEvaluateHandler handler) {
        int delay = handler.getValueLookupDelay(this.myProject);
        if (this.myCurrentHint != null && !this.myCurrentHint.isHintHidden()) {
            delay = Math.max(100, delay);
        }
        return delay;
    }

    public void hideHint() {
        if (this.myCurrentHint != null) {
            if (this.myCurrentHint instanceof RemoteValueHint) {
                ((RemoteValueHint)this.myCurrentHint).hideHint(true);
            } else {
                this.myCurrentHint.hideHint();
            }
            this.myCurrentHint = null;
        }
    }

    public void showHint(@NotNull QuickEvaluateHandler handler, @NotNull Editor editor, @NotNull Point point, @Nullable EditorMouseEvent e, @NotNull ValueHintType type) {
        if (handler == null) {
            ValueLookupManager.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            ValueLookupManager.$$$reportNull$$$0(6);
        }
        if (point == null) {
            ValueLookupManager.$$$reportNull$$$0(7);
        }
        if (type == null) {
            ValueLookupManager.$$$reportNull$$$0(8);
        }
        PsiDocumentManager.getInstance((Project)this.myProject).performWhenAllCommitted(() -> this.doShowHint(handler, editor, point, e, type));
    }

    private void doShowHint(@NotNull QuickEvaluateHandler handler, @NotNull Editor editor, @NotNull Point point, @Nullable EditorMouseEvent event, @NotNull ValueHintType type) {
        if (handler == null) {
            ValueLookupManager.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            ValueLookupManager.$$$reportNull$$$0(10);
        }
        if (point == null) {
            ValueLookupManager.$$$reportNull$$$0(11);
        }
        if (type == null) {
            ValueLookupManager.$$$reportNull$$$0(12);
        }
        this.cancelAll();
        if (editor.isDisposed() || !handler.canShowHint(this.myProject)) {
            return;
        }
        if (this.myCurrentHint != null && this.myCurrentHint.isInsideHint(editor, point)) {
            return;
        }
        if (event != null && !event.isOverText()) {
            return;
        }
        try {
            HintRequest hintRequest;
            QuickEvaluateHandler.CancellableHint cancellableHint = handler.createValueHintAsync(this.myProject, editor, point, type);
            this.myHintRequest = hintRequest = new HintRequest(cancellableHint, type);
            cancellableHint.hintPromise().onProcessed(hint -> {
                if (this.myHintRequest == hintRequest) {
                    this.myHintRequest = null;
                }
                if (hint == null) {
                    UIUtil.invokeLaterIfNeeded(() -> {
                        this.hideHint();
                        if (event != null) {
                            EditorMouseHoverPopupManager.getInstance().showInfoTooltip(event);
                        }
                    });
                    return;
                }
                if (this.myCurrentHint != null && this.myCurrentHint.equals(hint)) {
                    return;
                }
                if (event != null) {
                    hint.setEditorMouseEvent(event);
                }
                UIUtil.invokeLaterIfNeeded(() -> {
                    this.hideHint();
                    this.myCurrentHint = hint;
                    this.myCurrentHint.invokeHint(() -> {
                        if (this.myCurrentHint == hint) {
                            this.myCurrentHint = null;
                        }
                    });
                });
            });
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    public static ValueLookupManager getInstance(Project project) {
        return (ValueLookupManager)project.getService(ValueLookupManager.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        objectArray2[1] = "com/intellij/platform/debugger/impl/frontend/evaluate/quick/common/ValueLookupManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseExited";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseMoved";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "requestHint";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "showHint";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "doShowHint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private record HintRequest(@NotNull QuickEvaluateHandler.CancellableHint cancellableHint, @NotNull ValueHintType type) {
        @NotNull
        private final QuickEvaluateHandler.CancellableHint cancellableHint;
        @NotNull
        private final ValueHintType type;

        private HintRequest(@NotNull QuickEvaluateHandler.CancellableHint cancellableHint, @NotNull ValueHintType type) {
            if (cancellableHint == null) {
                HintRequest.$$$reportNull$$$0(0);
            }
            if (type == null) {
                HintRequest.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public QuickEvaluateHandler.CancellableHint cancellableHint() {
            QuickEvaluateHandler.CancellableHint cancellableHint = this.cancellableHint;
            if (cancellableHint == null) {
                HintRequest.$$$reportNull$$$0(2);
            }
            return cancellableHint;
        }

        @NotNull
        public ValueHintType type() {
            ValueHintType valueHintType = this.type;
            if (valueHintType == null) {
                HintRequest.$$$reportNull$$$0(3);
            }
            return valueHintType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cancellableHint";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/debugger/impl/frontend/evaluate/quick/common/ValueLookupManager$HintRequest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/debugger/impl/frontend/evaluate/quick/common/ValueLookupManager$HintRequest";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cancellableHint";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

