/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.JvmAnnotationNamesKt;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassConstructorDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\r\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J2\u0010\u000e\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaAnnotationCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "reportDeprecatedJavaAnnotation", "reportErrorsOnPositionedArguments", "reportOnValueArgument", "arguments", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Companion", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nJavaAnnotationCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaAnnotationCallChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JavaAnnotationCallChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,84:1\n1#2:85\n216#3,2:86\n*S KotlinDebug\n*F\n+ 1 JavaAnnotationCallChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JavaAnnotationCallChecker\n*L\n56#1:86,2\n*E\n"})
public final class JavaAnnotationCallChecker
implements CallChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor().getOriginal();
        Intrinsics.checkNotNullExpressionValue(callableDescriptor, "getOriginal(...)");
        CallableDescriptor resultingDescriptor = callableDescriptor;
        if (!(resultingDescriptor instanceof JavaClassConstructorDescriptor) || ((JavaClassConstructorDescriptor)resultingDescriptor).getContainingDeclaration().getKind() != ClassKind.ANNOTATION_CLASS) {
            return;
        }
        this.reportErrorsOnPositionedArguments(resolvedCall2, context);
        this.reportDeprecatedJavaAnnotation(resolvedCall2, context);
    }

    private final void reportDeprecatedJavaAnnotation(ResolvedCall<?> resolvedCall2, CallCheckerContext context) {
        block4: {
            FqName fqName;
            KtElement ktElement = resolvedCall2.getCall().getCallElement();
            KtAnnotationEntry ktAnnotationEntry = ktElement instanceof KtAnnotationEntry ? (KtAnnotationEntry)ktElement : null;
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry annotationEntry = ktAnnotationEntry;
            KotlinType kotlinType = (KotlinType)context.getTrace().get(BindingContext.TYPE, annotationEntry.getTypeReference());
            if (kotlinType == null) {
                return;
            }
            KotlinType type2 = kotlinType;
            Map<FqName, FqName> map = JvmAnnotationNamesKt.getJavaToKotlinNameMap();
            ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor != null) {
                ClassifierDescriptor it = classifierDescriptor;
                boolean bl = false;
                fqName = DescriptorUtils.getFqNameSafe(it);
            } else {
                fqName = null;
            }
            FqName fqName2 = map.get(fqName);
            if (fqName2 == null) break block4;
            FqName it = fqName2;
            boolean bl = false;
            context.getTrace().report(ErrorsJvm.DEPRECATED_JAVA_ANNOTATION.on((KtAnnotationEntry)((PsiElement)annotationEntry), it));
        }
    }

    private final void reportErrorsOnPositionedArguments(ResolvedCall<?> resolvedCall2, CallCheckerContext context) {
        Map<ValueParameterDescriptor, ResolvedValueArgument> $this$forEach$iv = Companion.getJavaAnnotationCallValueArgumentsThatShouldBeNamed(resolvedCall2);
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> element$iv;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> it = element$iv = iterator2.next();
            boolean bl = false;
            DiagnosticFactory0<KtExpression> diagnosticFactory0 = ErrorsJvm.POSITIONED_VALUE_ARGUMENT_FOR_JAVA_ANNOTATION;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, "POSITIONED_VALUE_ARGUMENT_FOR_JAVA_ANNOTATION");
            this.reportOnValueArgument(context, it, diagnosticFactory0);
        }
    }

    private final void reportOnValueArgument(CallCheckerContext context, Map.Entry<? extends ValueParameterDescriptor, ? extends ResolvedValueArgument> arguments, DiagnosticFactory0<KtExpression> diagnostic) {
        for (ValueArgument valueArgument : arguments.getValue().getArguments()) {
            KtExpression argumentExpression;
            if (valueArgument.getArgumentExpression() == null) continue;
            context.getTrace().report(diagnostic.on((KtExpression)((PsiElement)argumentExpression)));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaAnnotationCallChecker$Companion;", "", "<init>", "()V", "getJavaAnnotationCallValueArgumentsThatShouldBeNamed", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "frontend.java"})
    @SourceDebugExtension(value={"SMAP\nJavaAnnotationCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaAnnotationCallChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JavaAnnotationCallChecker$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,84:1\n535#2:85\n520#2,6:86\n*S KotlinDebug\n*F\n+ 1 JavaAnnotationCallChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JavaAnnotationCallChecker$Companion\n*L\n76#1:85\n76#1:86,6\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final Map<ValueParameterDescriptor, ResolvedValueArgument> getJavaAnnotationCallValueArgumentsThatShouldBeNamed(@NotNull ResolvedCall<?> resolvedCall) {
            Intrinsics.checkNotNullParameter(resolvedCall, "resolvedCall");
            v0 = resolvedCall.getValueArguments();
            Intrinsics.checkNotNullExpressionValue(v0, "getValueArguments(...)");
            $this$filter$iv = v0;
            $i$f$filter = false;
            var4_4 = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap<K, V>();
            $i$f$filterTo = false;
            var7_7 = $this$filterTo$iv$iv.entrySet().iterator();
            while (var7_7.hasNext()) {
                p = element$iv$iv = var7_7.next();
                $i$a$-filter-JavaAnnotationCallChecker$Companion$getJavaAnnotationCallValueArgumentsThatShouldBeNamed$1 = false;
                if (Intrinsics.areEqual(((ValueParameterDescriptor)p.getKey()).getName(), JvmAnnotationNames.DEFAULT_ANNOTATION_MEMBER_NAME) || !(p.getValue() instanceof ExpressionValueArgument)) ** GOTO lbl-1000
                v1 = p.getValue();
                Intrinsics.checkNotNull(v1, "null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument");
                v2 = ((ExpressionValueArgument)v1).getValueArgument();
                if (!(v2 != null ? v2.isNamed() : true)) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                if (!v3) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            return destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

