/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.perforce.ConnectionId;
import org.jetbrains.idea.perforce.perforce.PerforcePhysicalConnectionParameters;
import org.jetbrains.idea.perforce.perforce.PerforcePhysicalConnectionParametersI;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionParameters;
import org.jetbrains.idea.perforce.perforce.connections.P4ParametersConnection;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0002\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eJ&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014*\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\fH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/idea/perforce/perforce/connections/P4ClientParser;", "", "<init>", "()V", "getPerforceClients", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/idea/perforce/perforce/connections/P4ClientParser$PerforceClient;", "project", "Lcom/intellij/openapi/project/Project;", "parametersSet", "", "Lorg/jetbrains/idea/perforce/perforce/connections/P4ConnectionParameters;", "contentRoots", "", "", "settings", "Lorg/jetbrains/idea/perforce/perforce/PerforcePhysicalConnectionParametersI;", "parameters", "toConnectArgs", "", "", "(Lorg/jetbrains/idea/perforce/perforce/connections/P4ConnectionParameters;)[Ljava/lang/String;", "parseClientLine", "line", "PerforceClient", "Companion", "intellij.vcs.perforce"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nP4ClientParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 P4ClientParser.kt\norg/jetbrains/idea/perforce/perforce/connections/P4ClientParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,108:1\n1611#2,9:109\n1863#2:118\n1062#2:119\n295#2,2:120\n1864#2:124\n1620#2:125\n1863#2,2:126\n1#3:122\n1#3:123\n37#4,2:128\n14#5:130\n*S KotlinDebug\n*F\n+ 1 P4ClientParser.kt\norg/jetbrains/idea/perforce/perforce/connections/P4ClientParser\n*L\n25#1:109,9\n25#1:118\n28#1:119\n29#1:120,2\n25#1:124\n25#1:125\n49#1:126,2\n25#1:123\n83#1:128,2\n104#1:130\n*E\n"})
public final class P4ClientParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Regex CLIENT_REGEX;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<VirtualFile, PerforceClient> getPerforceClients(@NotNull Project project, @NotNull Set<? extends P4ConnectionParameters> parametersSet, @NotNull Collection<? extends VirtualFile> contentRoots) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(parametersSet, (String)"parametersSet");
        Intrinsics.checkNotNullParameter(contentRoots, (String)"contentRoots");
        PerforcePhysicalConnectionParameters settings = PerforceSettings.getSettings(project).getPhysicalSettings(false);
        for (P4ConnectionParameters p4ConnectionParameters : parametersSet) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNull((Object)settings);
            List<PerforceClient> perforceClients = this.getPerforceClients(project, settings, p4ConnectionParameters);
            Iterable $this$mapNotNull$iv = contentRoots;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Pair pair;
                Object v0;
                VirtualFile root;
                block5: {
                    void $this$firstOrNull$iv;
                    Iterable $this$sortedByDescending$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    root = (VirtualFile)element$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)FileUtil.toSystemDependentName((String)root.getPath()), (String)"toSystemDependentName(...)");
                    Iterable iterable2 = perforceClients;
                    boolean $i$f$sortedByDescending = false;
                    $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            PerforceClient client = (PerforceClient)b;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)client.getLastUpdate());
                            client = (PerforceClient)a;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)client.getLastUpdate())));
                        }
                    });
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        String contentRootPath;
                        PerforceClient client = (PerforceClient)element$iv;
                        boolean bl3 = false;
                        if (!VcsFileUtil.isAncestor((String)client.getWorkspaceRootPath(), (String)contentRootPath, (boolean)false)) continue;
                        v0 = element$iv;
                        break block5;
                    }
                    v0 = null;
                }
                PerforceClient perforceClient = v0;
                if (perforceClient != null) {
                    PerforceClient it = perforceClient;
                    boolean bl = false;
                    pair = TuplesKt.to((Object)root, (Object)it);
                } else {
                    pair = null;
                }
                if (pair == null) continue;
                Pair it$iv$iv = pair;
                boolean bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Map perforceClientsForRoots = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            if (!(!perforceClientsForRoots.isEmpty())) continue;
            return perforceClientsForRoots;
        }
        return MapsKt.emptyMap();
    }

    private final List<PerforceClient> getPerforceClients(Project project, PerforcePhysicalConnectionParametersI settings, P4ConnectionParameters parameters) {
        List clients = new ArrayList();
        try {
            if (parameters.getUser() == null) {
                return CollectionsKt.emptyList();
            }
            String string = project.getBasePath();
            if (string == null) {
                return CollectionsKt.emptyList();
            }
            String workingDir = string;
            String string2 = parameters.getUser();
            if (string2 == null) {
                return CollectionsKt.emptyList();
            }
            String user = string2;
            String[] stringArray = new String[]{"clients", "-u", user};
            String string3 = new P4ParametersConnection(parameters, new ConnectionId(null, workingDir)).runP4CommandLine(settings, this.toConnectArgs(parameters), stringArray, null).getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getStdout(...)");
            Iterable $this$forEach$iv = StringsKt.lines((CharSequence)string3);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PerforceClient it;
                String line = (String)element$iv;
                boolean bl = false;
                if (this.parseClientLine(line, parameters) == null) continue;
                boolean bl2 = false;
                clients.add(it);
            }
        }
        catch (VcsException e) {
            LOG.warn("Error while getting perforce clients: ", (Throwable)e);
        }
        return clients;
    }

    private final String[] toConnectArgs(P4ConnectionParameters $this$toConnectArgs) {
        String pass;
        CharSequence charSequence;
        String user;
        CharSequence charSequence2;
        String client;
        CharSequence charSequence3;
        ArrayList<String> args = new ArrayList<String>();
        String server = $this$toConnectArgs.getServer();
        CharSequence charSequence4 = server;
        if (!(charSequence4 == null || StringsKt.isBlank((CharSequence)charSequence4))) {
            args.add("-p");
            args.add(server);
        }
        if (!((charSequence3 = (CharSequence)(client = $this$toConnectArgs.getClient())) == null || StringsKt.isBlank((CharSequence)charSequence3))) {
            args.add("-c");
            args.add(client);
        }
        if (!((charSequence2 = (CharSequence)(user = $this$toConnectArgs.getUser())) == null || StringsKt.isBlank((CharSequence)charSequence2))) {
            args.add("-u");
            args.add(user);
        }
        if (!((charSequence = (CharSequence)(pass = $this$toConnectArgs.getPassword())) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            args.add("-P");
            args.add(pass);
        }
        Collection $this$toTypedArray$iv = args;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    private final PerforceClient parseClientLine(String line, P4ConnectionParameters parameters) {
        MatchResult matchResult = Regex.find$default((Regex)CLIENT_REGEX, (CharSequence)line, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult.Destructured destructured = matchResult.getDestructured();
        String clientName = (String)destructured.getMatch().getGroupValues().get(1);
        String lastUpdate = (String)destructured.getMatch().getGroupValues().get(2);
        String rootPath = (String)destructured.getMatch().getGroupValues().get(3);
        String description = (String)destructured.getMatch().getGroupValues().get(4);
        return new PerforceClient(clientName, lastUpdate, rootPath, description, parameters);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(P4ClientParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        CLIENT_REGEX = new Regex("Client (\\S+)\\s+(\\d+/\\d+/\\d+)\\s+root (\\S+) '(.+)'");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/perforce/perforce/connections/P4ClientParser$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "CLIENT_REGEX", "Lkotlin/text/Regex;", "intellij.vcs.perforce"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J;\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/idea/perforce/perforce/connections/P4ClientParser$PerforceClient;", "", "clientName", "", "lastUpdate", "workspaceRootPath", "description", "parameters", "Lorg/jetbrains/idea/perforce/perforce/connections/P4ConnectionParameters;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/idea/perforce/perforce/connections/P4ConnectionParameters;)V", "getClientName", "()Ljava/lang/String;", "getLastUpdate", "getWorkspaceRootPath", "getDescription", "getParameters", "()Lorg/jetbrains/idea/perforce/perforce/connections/P4ConnectionParameters;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.vcs.perforce"})
    public static final class PerforceClient {
        @NotNull
        private final String clientName;
        @NotNull
        private final String lastUpdate;
        @NotNull
        private final String workspaceRootPath;
        @NotNull
        private final String description;
        @NotNull
        private final P4ConnectionParameters parameters;

        public PerforceClient(@NotNull String clientName, @NotNull String lastUpdate, @NotNull String workspaceRootPath, @NotNull String description, @NotNull P4ConnectionParameters parameters) {
            Intrinsics.checkNotNullParameter((Object)clientName, (String)"clientName");
            Intrinsics.checkNotNullParameter((Object)lastUpdate, (String)"lastUpdate");
            Intrinsics.checkNotNullParameter((Object)workspaceRootPath, (String)"workspaceRootPath");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            this.clientName = clientName;
            this.lastUpdate = lastUpdate;
            this.workspaceRootPath = workspaceRootPath;
            this.description = description;
            this.parameters = parameters;
        }

        @NotNull
        public final String getClientName() {
            return this.clientName;
        }

        @NotNull
        public final String getLastUpdate() {
            return this.lastUpdate;
        }

        @NotNull
        public final String getWorkspaceRootPath() {
            return this.workspaceRootPath;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final P4ConnectionParameters getParameters() {
            return this.parameters;
        }

        @NotNull
        public final String component1() {
            return this.clientName;
        }

        @NotNull
        public final String component2() {
            return this.lastUpdate;
        }

        @NotNull
        public final String component3() {
            return this.workspaceRootPath;
        }

        @NotNull
        public final String component4() {
            return this.description;
        }

        @NotNull
        public final P4ConnectionParameters component5() {
            return this.parameters;
        }

        @NotNull
        public final PerforceClient copy(@NotNull String clientName, @NotNull String lastUpdate, @NotNull String workspaceRootPath, @NotNull String description, @NotNull P4ConnectionParameters parameters) {
            Intrinsics.checkNotNullParameter((Object)clientName, (String)"clientName");
            Intrinsics.checkNotNullParameter((Object)lastUpdate, (String)"lastUpdate");
            Intrinsics.checkNotNullParameter((Object)workspaceRootPath, (String)"workspaceRootPath");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            return new PerforceClient(clientName, lastUpdate, workspaceRootPath, description, parameters);
        }

        public static /* synthetic */ PerforceClient copy$default(PerforceClient perforceClient, String string, String string2, String string3, String string4, P4ConnectionParameters p4ConnectionParameters, int n, Object object) {
            if ((n & 1) != 0) {
                string = perforceClient.clientName;
            }
            if ((n & 2) != 0) {
                string2 = perforceClient.lastUpdate;
            }
            if ((n & 4) != 0) {
                string3 = perforceClient.workspaceRootPath;
            }
            if ((n & 8) != 0) {
                string4 = perforceClient.description;
            }
            if ((n & 0x10) != 0) {
                p4ConnectionParameters = perforceClient.parameters;
            }
            return perforceClient.copy(string, string2, string3, string4, p4ConnectionParameters);
        }

        @NotNull
        public String toString() {
            return "PerforceClient(clientName=" + this.clientName + ", lastUpdate=" + this.lastUpdate + ", workspaceRootPath=" + this.workspaceRootPath + ", description=" + this.description + ", parameters=" + this.parameters + ")";
        }

        public int hashCode() {
            int result = this.clientName.hashCode();
            result = result * 31 + this.lastUpdate.hashCode();
            result = result * 31 + this.workspaceRootPath.hashCode();
            result = result * 31 + this.description.hashCode();
            result = result * 31 + this.parameters.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PerforceClient)) {
                return false;
            }
            PerforceClient perforceClient = (PerforceClient)other;
            if (!Intrinsics.areEqual((Object)this.clientName, (Object)perforceClient.clientName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastUpdate, (Object)perforceClient.lastUpdate)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.workspaceRootPath, (Object)perforceClient.workspaceRootPath)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.description, (Object)perforceClient.description)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.parameters, (Object)perforceClient.parameters);
        }
    }
}

