/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.CommonBundle;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageLogger;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.filters.ModifiedFilesFilter;
import com.intellij.coverage.view.CoverageListNode;
import com.intellij.coverage.view.CoverageRowSorter;
import com.intellij.coverage.view.CoverageTableModel;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.CoverageViewTreeStructure;
import com.intellij.coverage.view.PercentageParser;
import com.intellij.coverage.view.PercentageRecord;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.impl.RunDialog;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionButtonUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBTreeTable;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverageView
extends BorderLayoutPanel
implements UiDataProvider,
Disposable {
    @NonNls
    private static final String ACTION_DRILL_DOWN = "DrillDown";
    @NonNls
    static final String HELP_ID = "reference.toolWindows.Coverage";
    private static final Icon FILTER_ICON = AllIcons.General.Filter;
    private final CoverageTableModel myModel;
    private final JBTreeTable myTable;
    private final Project myProject;
    private final CoverageViewManager.StateBean myStateBean;
    private final CoverageSuitesBundle mySuitesBundle;
    private final CoverageViewExtension myViewExtension;
    private final CoverageViewTreeStructure myTreeStructure;
    private boolean myHasVCSFilter = false;
    private boolean myHasFullyCoveredFilter = false;

    public CoverageView(Project project, CoverageSuitesBundle bundle) {
        this.myProject = project;
        this.myStateBean = CoverageViewManager.getInstance(project).getStateBean();
        this.mySuitesBundle = bundle;
        this.myViewExtension = this.mySuitesBundle.getCoverageEngine().createCoverageViewExtension(this.myProject, this.mySuitesBundle);
        this.myTreeStructure = new CoverageViewTreeStructure(project, this.mySuitesBundle);
        this.myModel = new CoverageTableModel(this.mySuitesBundle, project, this.myTreeStructure);
        Disposer.register((Disposable)this, (Disposable)this.myModel);
        this.myTable = new JBTreeTable((TreeTableModel)this.myModel);
        TreeUtil.expand((JTree)this.myTable.getTree(), (int)2);
        this.myTable.getTree().setCellRenderer((TreeCellRenderer)new NodeRenderer(){

            @NotNull
            protected SimpleTextAttributes getSimpleTextAttributes(@NotNull PresentationData presentation, Color color, @NotNull Object node) {
                if (presentation == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (this.mySelected) {
                    color = null;
                }
                SimpleTextAttributes simpleTextAttributes = super.getSimpleTextAttributes(presentation, color, node);
                if (simpleTextAttributes == null) {
                    1.$$$reportNull$$$0(2);
                }
                return simpleTextAttributes;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "presentation";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/coverage/view/CoverageView$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/coverage/view/CoverageView$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSimpleTextAttributes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getSimpleTextAttributes";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        });
        this.myTable.setDefaultRenderer(String.class, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setBackground(UIUtil.getTableBackground((boolean)isSelected, (boolean)CoverageView.this.myTable.hasFocus()));
                return component;
            }
        });
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Coverage");
        boolean isHorizontalView = toolWindow != null && toolWindow.getAnchor().isHorizontal();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("CoverageView", this.createToolbarActions(), !isHorizontalView);
        actionToolbar.setTargetComponent((JComponent)this.myTable);
        JComponent toolbarComponent = actionToolbar.getComponent();
        if (isHorizontalView) {
            this.addToLeft(toolbarComponent);
        } else {
            this.addToTop(toolbarComponent);
        }
        this.setUpShowRootNode(actionToolbar);
        CoverageLogger.logViewOpen(project, this.myStateBean.isShowOnlyModified(), this.myHasVCSFilter, this.myStateBean.isHideFullyCovered(), this.myHasFullyCoveredFilter);
        CoverageRowSorter rowSorter = new CoverageRowSorter(this.myTable, this.myModel);
        this.myTable.setRowSorter((RowSorter)rowSorter);
        if (this.myStateBean.mySortingColumn < 0 || this.myStateBean.mySortingColumn >= this.myModel.getColumnCount()) {
            this.myStateBean.myAscendingOrder = true;
            this.myStateBean.mySortingColumn = 0;
        }
        RowSorter.SortKey sortKey = new RowSorter.SortKey(this.myStateBean.mySortingColumn, this.myStateBean.myAscendingOrder ? SortOrder.ASCENDING : SortOrder.DESCENDING);
        rowSorter.setSortKeys(Collections.singletonList(sortKey));
        this.addToCenter((Component)this.myTable);
        this.attachFileStatusListener();
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                CoverageView.this.enterSelected(false);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/coverage/view/CoverageView$3", "onDoubleClick"));
            }
        }.installOn((Component)this.myTable.getTree());
        TreeSpeedSearch speedSearch = TreeSpeedSearch.installOn((JTree)this.myTable.getTree(), (boolean)false, path -> path.getLastPathComponent().toString());
        speedSearch.setCanExpand(true);
        speedSearch.setClearSearchOnNavigateNoMatch(true);
        PopupHandler.installPopupMenu((JComponent)this.myTable, (ActionGroup)CoverageView.createPopupGroup(), (String)"CoverageViewPopup");
        this.myTable.getTree().registerKeyboardAction(e -> this.resetView(null), KeyStroke.getKeyStroke(92, ClientSystemInfo.isMac() ? 256 : 128), 0);
        this.myTable.getTree().getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), ACTION_DRILL_DOWN);
        this.myTable.getTree().getInputMap(0).put(KeyStroke.getKeyStroke(34, ClientSystemInfo.isMac() ? 256 : 128), ACTION_DRILL_DOWN);
        this.myTable.getTree().getActionMap().put(ACTION_DRILL_DOWN, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageView.this.enterSelected(true);
            }
        });
        this.addLoggingListeners();
    }

    private void resetIfAllFiltered(AbstractTreeNode<?> root, ActionToolbar actionToolbar) {
        boolean hasChildren = this.myViewExtension.hasChildren(root);
        if (this.hasVCSFilteredNodes() && this.myStateBean.isShowOnlyModified() && this.myStateBean.isDefaultFilters()) {
            if (!hasChildren) {
                this.resetView(() -> this.myStateBean.setShowOnlyModified(false));
            } else {
                ActionButton filterAction;
                GotItTooltip gotIt = this.createGotIt();
                if (gotIt.canShow() && (filterAction = ActionButtonUtil.findToolbarActionButton((ActionToolbar)actionToolbar, button -> button.getIcon() == FILTER_ICON)) != null) {
                    gotIt.show((JComponent)filterAction, GotItTooltip.BOTTOM_MIDDLE);
                }
            }
        }
    }

    @NotNull
    private GotItTooltip createGotIt() {
        String branchName = this.getFilteredBranchName();
        if (branchName != null) {
            return new GotItTooltip("coverage.view.elements.by.branch.filter", CoverageBundle.message("coverage.filter.branch.gotit", this.myViewExtension.getElementsName()), (Disposable)this);
        }
        return new GotItTooltip("coverage.view.elements.filter", CoverageBundle.message("coverage.filter.gotit", this.myViewExtension.getElementsName()), (Disposable)this);
    }

    private boolean hasVCSFilteredNodes() {
        ModifiedFilesFilter filter = this.getModifiedFilesFilter();
        return filter != null && filter.getHasFilteredFiles();
    }

    @Nullable
    private ModifiedFilesFilter getModifiedFilesFilter() {
        CoverageAnnotator annotator = this.mySuitesBundle.getCoverageEngine().getCoverageAnnotator(this.myProject);
        return annotator.getModifiedFilesFilter();
    }

    private void setUpShowRootNode(final ActionToolbar actionToolbar) {
        final Ref showFull = new Ref((Object)false);
        this.myModel.addTreeModelListener(new TreeModelListener(){
            private volatile boolean called = false;

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                this.onModelUpdate(e);
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                this.onModelUpdate(e);
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                this.onModelUpdate(e);
            }

            private void onModelUpdate(TreeModelEvent e) {
                Object root = CoverageView.this.myModel.getRoot();
                if (e.getTreePath().getLastPathComponent() == root) {
                    AbstractTreeNode<?> nodeRoot;
                    boolean showRoot;
                    CoverageView.this.setUpEmptyText();
                    int childCount = CoverageView.this.myModel.getChildCount(root);
                    boolean bl = showRoot = childCount > 1 || childCount == 1 && (Boolean)showFull.get() != false;
                    if (showRoot && !CoverageView.this.myStateBean.isShowOnlyModified() && !CoverageView.this.myStateBean.isHideFullyCovered()) {
                        showFull.set((Object)true);
                    }
                    if (showRoot != CoverageView.this.myTable.getTree().isRootVisible()) {
                        CoverageView.this.myTable.getTree().setRootVisible(showRoot);
                    }
                    if (!this.called && (nodeRoot = CoverageView.this.myModel.getCoverageNode(root)) != null) {
                        this.called = true;
                        CoverageView.this.setWidth(nodeRoot);
                        CoverageView.this.resetIfAllFiltered(nodeRoot, actionToolbar);
                        CoverageView.this.logTotalCoverage(nodeRoot);
                    }
                }
            }
        });
    }

    private void attachFileStatusListener() {
        FileStatusListener fileStatusListener = new FileStatusListener(){

            public void fileStatusesChanged() {
                CoverageView.this.myTable.repaint();
            }

            public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    6.$$$reportNull$$$0(0);
                }
                CoverageView.this.myTable.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/coverage/view/CoverageView$6", "fileStatusChanged"));
            }
        };
        FileStatusManager.getInstance((Project)this.myProject).addFileStatusListener(fileStatusListener, (Disposable)this);
    }

    private void setUpEmptyText() {
        boolean hasFullyCovered = this.myViewExtension.hasFullyCoveredNodes();
        this.myTable.getTree().getEmptyText().clear();
        StatusText emptyText = this.myTable.getTable().getEmptyText();
        emptyText.setText(CoverageBundle.message("coverage.view.no.coverage.results", new Object[0]));
        RunConfigurationBase configuration = this.mySuitesBundle.getRunConfiguration();
        if (configuration != null) {
            emptyText.appendLine(CoverageBundle.message("coverage.view.edit.run.configuration.0", new Object[0]) + " ");
            emptyText.appendText(CoverageBundle.message("coverage.view.edit.run.configuration.1", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, e -> {
                RunnerAndConfigurationSettings configurationSettings = RunManager.getInstance((Project)this.myProject).findSettings((RunConfiguration)configuration);
                if (configurationSettings != null) {
                    RunDialog.editConfiguration((Project)this.myProject, (RunnerAndConfigurationSettings)configurationSettings, (String)ExecutionBundle.message((String)"edit.run.configuration.for.item.dialog.title", (Object[])new Object[]{configuration.getName()}));
                } else {
                    Messages.showErrorDialog((Project)this.myProject, (String)CoverageBundle.message("coverage.view.configuration.was.not.found", configuration.getName()), (String)CommonBundle.getErrorTitle());
                }
            });
            emptyText.appendText(" " + CoverageBundle.message("coverage.view.edit.run.configuration.2", new Object[0]));
        }
        if (this.myStateBean.isShowOnlyModified() && this.hasVCSFilteredNodes()) {
            emptyText.appendLine(CoverageBundle.message("coverage.show.unmodified.elements", this.myViewExtension.getElementsName()), SimpleTextAttributes.LINK_ATTRIBUTES, e -> this.resetView(() -> this.myStateBean.setShowOnlyModified(false)));
        }
        if (hasFullyCovered && this.myStateBean.isHideFullyCovered()) {
            emptyText.appendLine(CoverageBundle.message("coverage.show.fully.covered.elements", this.myViewExtension.getElementsName()), SimpleTextAttributes.LINK_ATTRIBUTES, e -> this.resetView(() -> this.myStateBean.setHideFullyCovered(false)));
        }
    }

    public void dispose() {
        if (!this.myProject.isDisposed()) {
            CoverageDataManager.getInstance(this.myProject).closeSuitesBundle(this.mySuitesBundle);
        }
    }

    void saveSize() {
        List<RowSorter.SortKey> keys;
        int columns = this.myTable.getTable().getColumnCount();
        ArrayList<Integer> widths = new ArrayList<Integer>();
        TableColumnModel columnModel = this.myTable.getTable().getColumnModel();
        for (int i = 0; i < columns; ++i) {
            widths.add(columnModel.getColumn(i).getWidth());
        }
        widths.add(this.myTable.getWidth() - this.myTable.getTable().getWidth());
        this.myStateBean.myColumnSize = widths;
        RowSorter sorter = this.myTable.getTable().getRowSorter();
        RowSorter.SortKey sortKey = null;
        if (sorter != null && (keys = sorter.getSortKeys()) != null && !keys.isEmpty()) {
            sortKey = keys.get(0);
        }
        if (sortKey != null && sortKey.getSortOrder() != SortOrder.UNSORTED) {
            this.myStateBean.mySortingColumn = sortKey.getColumn();
            this.myStateBean.myAscendingOrder = sortKey.getSortOrder() == SortOrder.ASCENDING;
        }
    }

    private void setWidth(AbstractTreeNode<?> root) {
        int nameWidth;
        int columns = this.myTable.getTable().getColumnCount();
        TableColumnModel columnModel = this.myTable.getTable().getColumnModel();
        int tableWidth = 0;
        if (this.myStateBean.myColumnSize != null && this.myStateBean.myColumnSize.size() == columns + 1) {
            for (int column = 0; column < columns; ++column) {
                int width = this.myStateBean.myColumnSize.get(column);
                columnModel.getColumn(column).setPreferredWidth(width);
                tableWidth += width;
            }
            nameWidth = this.myStateBean.myColumnSize.get(columns);
        } else {
            for (int column = 0; column < columns; ++column) {
                int width = Math.max(this.getStringWidth(this.myModel.getColumnName(column)), this.getColumnWidth(column, root));
                columnModel.getColumn(column).setPreferredWidth(width);
                tableWidth += width;
            }
            nameWidth = Math.max(this.getStringWidth(this.myModel.getColumnName(0)), JBUIScale.scale((int)150));
        }
        this.myTable.setColumnProportion((float)tableWidth / (float)(nameWidth + tableWidth) / (float)columns);
    }

    private int getColumnWidth(int column, AbstractTreeNode<?> root) {
        String preferredString = this.myViewExtension.getPercentage(column, root);
        if (preferredString == null) {
            return JBUIScale.scale((int)60);
        }
        return this.getStringWidth(preferredString);
    }

    private int getStringWidth(@NotNull String preferredString) {
        if (preferredString == null) {
            CoverageView.$$$reportNull$$$0(0);
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        return fontMetrics.stringWidth(preferredString);
    }

    private static ActionGroup createPopupGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(ActionManager.getInstance().getAction("EditSource"));
        return actionGroup;
    }

    private ActionGroup createToolbarActions() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        if (this.myViewExtension.supportFlattenPackages()) {
            actionGroup.add((AnAction)new FlattenPackagesAction());
        }
        this.installAutoScrollToSource(actionGroup);
        this.installAutoScrollFromSource(actionGroup);
        actionGroup.add(ActionManager.getInstance().getAction("GenerateCoverageReport"));
        actionGroup.add(ActionManager.getInstance().getAction("ImportCoverage"));
        List<AnAction> extraActions = this.myViewExtension.createExtraToolbarActions();
        extraActions.forEach(arg_0 -> ((DefaultActionGroup)actionGroup).add(arg_0));
        boolean hasFilters = false;
        DefaultActionGroup filtersActionGroup = new DefaultActionGroup();
        if (ProjectLevelVcsManager.getInstance((Project)this.myProject).hasActiveVcss() && this.getModifiedFilesFilter() != null) {
            filtersActionGroup.add((AnAction)new ShowOnlyModifiedAction(this.getModifiedActionName()));
            hasFilters = true;
            this.myHasVCSFilter = true;
        }
        if (this.myViewExtension.supportFlattenPackages()) {
            filtersActionGroup.add((AnAction)new HideFullyCoveredAction());
            hasFilters = true;
            this.myHasFullyCoveredFilter = true;
        }
        if (hasFilters) {
            filtersActionGroup.setPopup(true);
            filtersActionGroup.getTemplatePresentation().setIcon(FILTER_ICON);
            filtersActionGroup.getTemplatePresentation().setText(CoverageBundle.messagePointer("coverage.view.filters.group", new Object[0]));
            actionGroup.add((AnAction)filtersActionGroup);
        }
        return actionGroup;
    }

    private void installAutoScrollFromSource(DefaultActionGroup actionGroup) {
        MyAutoScrollFromSourceHandler handler = new MyAutoScrollFromSourceHandler();
        handler.install();
        actionGroup.add((AnAction)handler.createToggleAction());
    }

    private void installAutoScrollToSource(DefaultActionGroup actionGroup) {
        AutoScrollToSourceHandler autoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return CoverageView.this.myStateBean.myAutoScrollToSource;
            }

            protected void setAutoScrollMode(boolean state) {
                CoverageView.this.myStateBean.myAutoScrollToSource = state;
            }
        };
        autoScrollToSourceHandler.install((JTree)this.myTable.getTree());
        actionGroup.add((AnAction)autoScrollToSourceHandler.createToggleAction());
    }

    private void enterSelected(boolean expand) {
        TreePath path = this.getSelectedPath();
        AbstractTreeNode<?> element = this.getLast(path);
        if (element == null) {
            return;
        }
        if (this.myModel.isLeaf(path.getLastPathComponent())) {
            if (element.canNavigate()) {
                CoverageLogger.logNavigation(this.myProject);
                element.navigate(true);
            }
            return;
        }
        if (!expand) {
            return;
        }
        if (!this.myTable.getTree().isExpanded(path)) {
            this.myTable.getTree().expandPath(path);
        } else {
            this.myTable.getTree().collapsePath(path);
        }
    }

    private TreePath getSelectedPath() {
        return this.myTable.getTree().getSelectionPath();
    }

    private AbstractTreeNode<?> getLast(@Nullable TreePath path) {
        if (path == null) {
            return null;
        }
        return this.myModel.getCoverageNode(path.getLastPathComponent());
    }

    private AbstractTreeNode<?> getSelectedValue() {
        return this.getLast(this.getSelectedPath());
    }

    boolean canSelect(VirtualFile file) {
        return this.myViewExtension.canSelectInCoverageView(file);
    }

    void select(VirtualFile file) {
        this.select(this.myViewExtension.getElementToSelect(file));
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            CoverageView.$$$reportNull$$$0(1);
        }
        sink.set(CommonDataKeys.NAVIGATABLE, this.getSelectedValue());
        sink.set(PlatformCoreDataKeys.HELP_ID, (Object)HELP_ID);
    }

    private void resetView(@Nullable Runnable updateSettings) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (updateSettings != null) {
                updateSettings.run();
            }
            this.myTreeStructure.reset();
            this.myModel.reset(true);
        });
    }

    private void addLoggingListeners() {
        this.myTable.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                CoverageLogger.logTreeNodeSelected(CoverageView.this.myProject);
            }
        });
        this.myTable.getTree().addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                this.logToggle(event, true);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                this.logToggle(event, false);
            }

            private void logToggle(TreeExpansionEvent event, boolean expanded) {
                AbstractTreeNode<?> treeNode = CoverageView.this.getLast(event.getPath());
                if (treeNode == null) {
                    return;
                }
                boolean isRoot = CoverageView.this.myModel.getRoot() == treeNode;
                CoverageLogger.logTreeNodeExpansionToggle(CoverageView.this.myProject, isRoot, expanded);
            }
        });
    }

    private void logTotalCoverage(AbstractTreeNode<?> root) {
        for (int column = 1; column < this.myModel.getColumnCount(); ++column) {
            String columnName = this.myModel.getColumnName(column);
            Object valueAt = this.myModel.getValueAt(root, column);
            if (!(valueAt instanceof String)) continue;
            String s = (String)valueAt;
            PercentageRecord percentage = PercentageParser.parse(s);
            CoverageLogger.logCoverageMetrics(this.myProject, columnName, percentage.getPercentage(), percentage.getTotal());
        }
    }

    @Nls
    @NotNull
    private String getModifiedActionName() {
        String elementName = this.myViewExtension.getElementsCapitalisedName();
        String branchName = this.getFilteredBranchName();
        if (branchName != null) {
            String string = CoverageBundle.message("coverage.show.only.elements.in.feature.branch", elementName, branchName);
            if (string == null) {
                CoverageView.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = CoverageBundle.message("coverage.show.only.modified.elements", elementName);
        if (string == null) {
            CoverageView.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    private String getFilteredBranchName() {
        ModifiedFilesFilter filter = this.getModifiedFilesFilter();
        return filter == null ? null : filter.getBranchName();
    }

    private void select(Object object) {
        ReadAction.nonBlocking(() -> {
            final PsiElement element = this.myViewExtension.getElementToSelect(object);
            final VirtualFile file = this.myViewExtension.getVirtualFile(object);
            this.myModel.accept(new TreeVisitor(){

                @NotNull
                public TreeVisitor.Action visit(@NotNull TreePath path) {
                    CoverageListNode coverageNode;
                    AbstractTreeNode<?> node;
                    if (path == null) {
                        10.$$$reportNull$$$0(0);
                    }
                    if (Comparing.equal((Object)(node = CoverageView.this.getLast(path)).getValue(), (Object)element)) {
                        TreeVisitor.Action action = TreeVisitor.Action.INTERRUPT;
                        if (action == null) {
                            10.$$$reportNull$$$0(1);
                        }
                        return action;
                    }
                    if (node instanceof CoverageListNode && (coverageNode = (CoverageListNode)node).contains(file)) {
                        TreeVisitor.Action action = TreeVisitor.Action.CONTINUE;
                        if (action == null) {
                            10.$$$reportNull$$$0(2);
                        }
                        return action;
                    }
                    TreeVisitor.Action action = TreeVisitor.Action.SKIP_CHILDREN;
                    if (action == null) {
                        10.$$$reportNull$$$0(3);
                    }
                    return action;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1, 2, 3 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "path";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/coverage/view/CoverageView$10";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/coverage/view/CoverageView$10";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "visit";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "visit";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1, 2, 3 -> new IllegalStateException(string);
                    };
                }
            }).onSuccess(path -> {
                if (path != null) {
                    TreeUtil.promiseSelect((JTree)this.myTable.getTree(), (TreePath)path);
                }
            });
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferredString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/view/CoverageView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/view/CoverageView";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiedActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStringWidth";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private final class FlattenPackagesAction
    extends ToggleAction {
        private FlattenPackagesAction() {
            super(IdeBundle.messagePointer((String)"action.flatten.packages", (Object[])new Object[0]), CoverageBundle.messagePointer("coverage.flatten.packages", new Object[0]), AllIcons.ObjectBrowser.FlattenPackages);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                FlattenPackagesAction.$$$reportNull$$$0(0);
            }
            return CoverageView.this.myStateBean.isFlattenPackages();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                FlattenPackagesAction.$$$reportNull$$$0(1);
            }
            CoverageView.this.resetView(() -> CoverageView.this.myStateBean.setFlattenPackages(state));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                FlattenPackagesAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/coverage/view/CoverageView$FlattenPackagesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/coverage/view/CoverageView$FlattenPackagesAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class ShowOnlyModifiedAction
    extends ToggleAction {
        private ShowOnlyModifiedAction(String name) {
            super(name);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowOnlyModifiedAction.$$$reportNull$$$0(0);
            }
            return CoverageView.this.myStateBean.isShowOnlyModified();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowOnlyModifiedAction.$$$reportNull$$$0(1);
            }
            CoverageView.this.resetView(() -> CoverageView.this.myStateBean.setShowOnlyModified(state));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ShowOnlyModifiedAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/coverage/view/CoverageView$ShowOnlyModifiedAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/coverage/view/CoverageView$ShowOnlyModifiedAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class HideFullyCoveredAction
    extends ToggleAction {
        private HideFullyCoveredAction() {
            super(CoverageBundle.messagePointer("coverage.hide.fully.covered.elements", CoverageView.this.myViewExtension.getElementsCapitalisedName()));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                HideFullyCoveredAction.$$$reportNull$$$0(0);
            }
            return CoverageView.this.myStateBean.isHideFullyCovered();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                HideFullyCoveredAction.$$$reportNull$$$0(1);
            }
            CoverageView.this.resetView(() -> CoverageView.this.myStateBean.setHideFullyCovered(state));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                HideFullyCoveredAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/coverage/view/CoverageView$HideFullyCoveredAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/coverage/view/CoverageView$HideFullyCoveredAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private class MyAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler {
        MyAutoScrollFromSourceHandler() {
            super(CoverageView.this.myProject, (JComponent)((Object)CoverageView.this), (Disposable)CoverageView.this);
        }

        protected boolean isAutoScrollEnabled() {
            return CoverageView.this.myStateBean.myAutoScrollFromSource;
        }

        protected void setAutoScrollEnabled(boolean state) {
            CoverageView.this.myStateBean.myAutoScrollFromSource = state;
        }

        protected void selectElementFromEditor(@NotNull FileEditor editor) {
            if (editor == null) {
                MyAutoScrollFromSourceHandler.$$$reportNull$$$0(0);
            }
            if (this.myProject.isDisposed() || !CoverageView.this.isShowing()) {
                return;
            }
            if (!CoverageView.this.myStateBean.myAutoScrollFromSource) {
                return;
            }
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            ReadAction.nonBlocking(() -> {
                VirtualFile file = editor.getFile();
                if (file != null && CoverageView.this.canSelect(file)) {
                    VirtualFile e = null;
                    if (editor instanceof TextEditor) {
                        int offset = ((TextEditor)editor).getEditor().getCaretModel().getOffset();
                        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
                        if (psiFile != null) {
                            e = psiFile.findElementAt(offset);
                        }
                    }
                    CoverageView.this.select((Object)(e != null ? e : file));
                }
            }).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/coverage/view/CoverageView$MyAutoScrollFromSourceHandler", "selectElementFromEditor"));
        }
    }
}

