/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.actions;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.ImplementationViewComponent;
import com.intellij.codeInsight.hint.PsiImplementationViewElement;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageLogger;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.PanelWithText;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.ui.popup.NotLookupOrSearchCondition;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ShowCoveringTestsAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(ShowCoveringTestsAction.class);
    private final CoverageSuitesBundle myBundle;
    private final String myClassFQName;
    private final LineData myLineData;
    private final boolean myTestsAvailable;

    public ShowCoveringTestsAction(@Nullable Project project, CoverageSuitesBundle bundle, String classFQName, LineData lineData) {
        super(CoverageBundle.message("action.text.show.tests.covering.line", new Object[0]), CoverageBundle.message("action.description.show.tests.covering.line", new Object[0]), PlatformIcons.TEST_SOURCE_FOLDER);
        this.myBundle = bundle;
        this.myClassFQName = classFQName;
        this.myLineData = lineData;
        this.myTestsAvailable = ShowCoveringTestsAction.isEnabled(project, bundle, lineData);
    }

    @ApiStatus.Internal
    public static boolean isEnabled(Project project, CoverageSuitesBundle bundle, LineData lineData) {
        if (lineData != null && lineData.getStatus() != 0 && project != null) {
            return bundle != null && bundle.isCoverageByTestEnabled() && bundle.getCoverageEngine().wasTestDataCollected(project, bundle);
        }
        return false;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ShowCoveringTestsAction.$$$reportNull$$$0(0);
        }
        LOG.assertTrue((project = e.getProject()) != null);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        LOG.assertTrue(editor != null);
        LOG.assertTrue(this.myBundle != null);
        CoverageEngine coverageEngine = this.myBundle.getCoverageEngine();
        HashSet tests = new HashSet();
        if (((Boolean)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> tests.addAll(coverageEngine.getTestsForLine(project, this.myBundle, this.myClassFQName, this.myLineData.getLineNumber())), CoverageBundle.message("extract.information.about.tests", new Object[0]), false, project)).booleanValue()) {
            ComponentPopupBuilder popupBuilder;
            ImplementationViewComponent component;
            Object[] testNames = ArrayUtilRt.toStringArray(tests);
            Arrays.sort(testNames);
            CoverageLogger.logShowCoveringTests(project, testNames.length);
            if (testNames.length == 0) {
                HintManager.getInstance().showErrorHint(editor, CoverageBundle.message("hint.text.failed.to.load.covered.tests", new Object[0]));
                return;
            }
            ThrowableComputable computeTestElements = () -> ShowCoveringTestsAction.lambda$actionPerformed$3(coverageEngine, (String[])testNames, project);
            List elements = (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(computeTestElements, CoverageBundle.message("dialog.title.find.tests.by.names", new Object[0]), true, project);
            String title = CoverageBundle.message("popup.title.tests.covering.line", this.myClassFQName, this.myLineData.getLineNumber());
            if (!elements.isEmpty()) {
                Consumer<ImplementationViewComponent> processor = viewComponent -> viewComponent.showInUsageView();
                component = new ImplementationViewComponent((Collection)elements, 0);
                component.setShowInFindWindowProcessor(processor);
                popupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component, component.getPreferredFocusableComponent()).setDimensionServiceKey(project, "ShowTestsPopup", false).addListener(new JBPopupListener(){

                    public void onClosed(@NotNull LightweightWindowEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        component.cleanup();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/coverage/actions/ShowCoveringTestsAction$1", "onClosed"));
                    }
                });
            } else {
                component = null;
                @NonNls String testsPresentation = StringUtil.join((String[])testNames, (String)"<br/>").replace("_", ".");
                PanelWithText panel = new PanelWithText(CoverageBundle.message("following.test.could.not.be.found.1", testNames.length, testsPresentation));
                popupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, null);
            }
            JBPopup popup = popupBuilder.setRequestFocusCondition(project, (Condition)NotLookupOrSearchCondition.INSTANCE).setProject(project).setResizable(true).setMovable(true).setTitle(title).createPopup();
            popup.showInBestPositionFor(editor);
            if (component != null) {
                component.setHint(popup, title);
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowCoveringTestsAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(this.myTestsAvailable);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowCoveringTestsAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ List lambda$actionPerformed$3(CoverageEngine coverageEngine, String[] testNames, Project project) throws RuntimeException {
        return ContainerUtil.map(coverageEngine.findTestsByNames(testNames, project), el -> (PsiImplementationViewElement)ReadAction.compute(() -> new PsiImplementationViewElement(el)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/actions/ShowCoveringTestsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/actions/ShowCoveringTestsAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

