/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.LineMarkerRendererWithErrorStripe;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverageSuitesBundle {
    private static final Logger LOG = Logger.getInstance(CoverageSuitesBundle.class);
    private final CoverageSuite[] mySuites;
    private final CoverageEngine myEngine;
    private Set<Module> myProcessedModules;
    private CachedValue<GlobalSearchScope> myCachedValue;
    private SoftReference<ProjectData> myData = new SoftReference<Object>(null);
    private boolean myShouldActivateToolWindow = true;

    public CoverageSuitesBundle(CoverageSuite suite) {
        this(new CoverageSuite[]{suite});
    }

    public CoverageSuitesBundle(CoverageSuite[] suites) {
        this.mySuites = suites;
        LOG.assertTrue(this.mySuites.length > 0);
        this.myEngine = this.mySuites[0].getCoverageEngine();
        for (CoverageSuite suite : suites) {
            CoverageEngine engine = suite.getCoverageEngine();
            LOG.assertTrue(Comparing.equal((Object)engine, (Object)this.myEngine));
        }
    }

    public boolean isValid() {
        for (CoverageSuite suite : this.mySuites) {
            if (suite.isValid()) continue;
            return false;
        }
        return true;
    }

    public Project getProject() {
        return this.mySuites[0].getProject();
    }

    public long getLastCoverageTimeStamp() {
        long max = 0L;
        for (CoverageSuite suite : this.mySuites) {
            max = Math.max(max, suite.getLastCoverageTimeStamp());
        }
        return max;
    }

    @ApiStatus.Internal
    public boolean isCoverageByTestApplicable() {
        for (CoverageSuite suite : this.mySuites) {
            if (!suite.isCoverageByTestApplicable()) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public boolean isCoverageByTestEnabled() {
        for (CoverageSuite suite : this.mySuites) {
            if (!suite.isCoverageByTestEnabled()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public ProjectData getCoverageData() {
        ProjectData data2;
        ProjectData projectData = this.myData.get();
        if (projectData != null) {
            return projectData;
        }
        List<ProjectData> dataList = Arrays.stream(this.mySuites).map(suite -> suite.getCoverageData(null)).filter(data -> data != null).toList();
        if (dataList.size() == 1) {
            data2 = dataList.get(0);
        } else {
            data2 = new ProjectData();
            for (ProjectData coverageData : dataList) {
                data2.merge((CoverageData)coverageData);
            }
            data2.setIncludePatterns(CoverageSuitesBundle.mergeIncludeFilters(dataList));
        }
        this.myData = new SoftReference<ProjectData>(data2);
        return data2;
    }

    public boolean isTrackTestFolders() {
        for (CoverageSuite suite : this.mySuites) {
            if (!suite.isTrackTestFolders()) continue;
            return true;
        }
        return false;
    }

    public boolean isBranchCoverage() {
        for (CoverageSuite suite : this.mySuites) {
            if (!suite.isBranchCoverage()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public CoverageEngine getCoverageEngine() {
        CoverageEngine coverageEngine = this.myEngine;
        if (coverageEngine == null) {
            CoverageSuitesBundle.$$$reportNull$$$0(0);
        }
        return coverageEngine;
    }

    @ApiStatus.Internal
    public LineMarkerRendererWithErrorStripe getLineMarkerRenderer(int lineNumber, @Nullable String className, @NotNull TreeMap<Integer, LineData> lines, boolean coverageByTestApplicable, @NotNull CoverageSuitesBundle coverageSuite, Function<? super Integer, Integer> newToOldConverter, Function<? super Integer, Integer> oldToNewConverter, boolean subCoverageActive) {
        if (lines == null) {
            CoverageSuitesBundle.$$$reportNull$$$0(1);
        }
        if (coverageSuite == null) {
            CoverageSuitesBundle.$$$reportNull$$$0(2);
        }
        return this.myEngine.getLineMarkerRenderer(lineNumber, className, lines, coverageByTestApplicable, coverageSuite, newToOldConverter, oldToNewConverter, subCoverageActive);
    }

    public CoverageAnnotator getAnnotator(@NotNull Project project) {
        if (project == null) {
            CoverageSuitesBundle.$$$reportNull$$$0(3);
        }
        return this.myEngine.getCoverageAnnotator(project);
    }

    public CoverageSuite @NotNull [] getSuites() {
        if (this.mySuites == null) {
            CoverageSuitesBundle.$$$reportNull$$$0(4);
        }
        return this.mySuites;
    }

    public boolean contains(CoverageSuite suite) {
        return ArrayUtilRt.find((Object[])this.mySuites, (Object)suite) > -1;
    }

    public void setCoverageData(ProjectData projectData) {
        this.myData = new SoftReference<ProjectData>(projectData);
    }

    void restoreCoverageData() {
        this.myData = new SoftReference<Object>(null);
        for (CoverageSuite suite : this.mySuites) {
            suite.restoreCoverageData();
        }
    }

    public String getPresentableName() {
        return StringUtil.join((Object[])this.mySuites, coverageSuite -> coverageSuite.getPresentableName(), (String)", ");
    }

    @ApiStatus.Internal
    public boolean isModuleChecked(Module module) {
        return this.myProcessedModules != null && this.myProcessedModules.contains(module);
    }

    @ApiStatus.Internal
    public void checkModule(Module module) {
        if (this.myProcessedModules == null) {
            this.myProcessedModules = new HashSet<Module>();
        }
        this.myProcessedModules.add(module);
    }

    @Nullable
    public RunConfigurationBase getRunConfiguration() {
        for (CoverageSuite suite : this.mySuites) {
            RunConfigurationBase<?> configuration;
            if (!(suite instanceof BaseCoverageSuite) || (configuration = ((BaseCoverageSuite)suite).getConfiguration()) == null) continue;
            return configuration;
        }
        return null;
    }

    @ApiStatus.Internal
    public GlobalSearchScope getSearchScope(Project project) {
        if (this.myCachedValue == null) {
            this.myCachedValue = CachedValuesManager.getManager((Project)project).createCachedValue(() -> new CachedValueProvider.Result((Object)this.getSearchScopeInner(project), new Object[]{ProjectRootModificationTracker.getInstance((Project)project)}), false);
        }
        return (GlobalSearchScope)this.myCachedValue.getValue();
    }

    private GlobalSearchScope getSearchScopeInner(Project project) {
        List<GlobalSearchScope> suiteScopes = Arrays.stream(this.mySuites).filter(suite -> suite instanceof BaseCoverageSuite).map(suite -> ((BaseCoverageSuite)suite).getSearchScope(project)).filter(Objects::nonNull).toList();
        if (suiteScopes.size() != this.mySuites.length) {
            return this.isTrackTestFolders() ? GlobalSearchScope.projectScope((Project)project) : GlobalSearchScopesCore.projectProductionScope((Project)project);
        }
        return GlobalSearchScope.union(suiteScopes);
    }

    public boolean shouldActivateToolWindow() {
        return this.myShouldActivateToolWindow;
    }

    public void setShouldActivateToolWindow(boolean shouldActivateToolWindow) {
        this.myShouldActivateToolWindow = shouldActivateToolWindow;
    }

    boolean ensureReportFilesExist() {
        return ContainerUtil.and((Object[])this.mySuites, s -> s.getCoverageDataFileProvider().ensureFileExists());
    }

    @Nullable
    private static List<Pattern> mergeIncludeFilters(@NotNull List<ProjectData> dataList) {
        if (dataList == null) {
            CoverageSuitesBundle.$$$reportNull$$$0(5);
        }
        boolean hasEmptyFilters = false;
        HashSet result = new HashSet();
        for (ProjectData data : dataList) {
            List patterns = data.getIncludePatterns();
            if (patterns == null || patterns.isEmpty()) {
                hasEmptyFilters = true;
                continue;
            }
            result.addAll(ContainerUtil.map((Collection)patterns, Pattern::pattern));
        }
        if (hasEmptyFilters) {
            if (!result.isEmpty()) {
                LOG.warn("CoverageSuitesBundle contains suites with filters impossible to merge. Please consider setting more precise filters for all suites. No filters applied.");
            }
            return null;
        }
        return ContainerUtil.map(result, Pattern::compile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/CoverageSuitesBundle";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageSuite";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageEngine";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/CoverageSuitesBundle";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuites";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerRenderer";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotator";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mergeIncludeFilters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5 -> new IllegalArgumentException(string);
        };
    }
}

