/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import java.beans.Introspector;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u001c\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0002\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0002H\u0002\u001a\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0002H\u0002\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0014\u0010\u000b\u001a\u00020\b*\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0000\u001a\u000e\u0010\u000e\u001a\u00020\b*\u0004\u0018\u00010\u000fH\u0002\u001a\f\u0010\u0010\u001a\u00020\b*\u00020\u0002H\u0000\u001a\u0012\u0010\u0011\u001a\u00020\u0002*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u0002*\u00020\u00032\u0006\u0010\u0014\u001a\u00020\f\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u0002*\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0002\u00a8\u0006\u0016"}, d2={"getPropertyNameAndKind", "Lkotlin/Pair;", "", "Lcom/intellij/lang/java/beans/PropertyKind;", "accessorName", "getKindByPrefix", "getPropertyNameInner", "checkBaseName", "", "prefixLength", "", "checkKind", "Lcom/intellij/psi/PsiMethod;", "kind", "isBooleanOrBoxed", "Lcom/intellij/psi/PsiType;", "isPropertyName", "getAccessorName", "propertyName", "getPropertyName", "method", "methodName", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\npropertyUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 propertyUtil.kt\norg/jetbrains/plugins/groovy/lang/psi/util/PropertyUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class PropertyUtilKt {
    @Nullable
    public static final Pair<String, PropertyKind> getPropertyNameAndKind(@NotNull String accessorName) {
        Intrinsics.checkNotNullParameter((Object)accessorName, (String)"accessorName");
        PropertyKind propertyKind = PropertyUtilKt.getKindByPrefix(accessorName);
        if (propertyKind == null) {
            return null;
        }
        PropertyKind propertyKind2 = propertyKind;
        String string = PropertyUtilKt.getPropertyNameInner(propertyKind2, accessorName);
        if (string == null) {
            return null;
        }
        String propertyName = string;
        return TuplesKt.to((Object)propertyName, (Object)propertyKind2);
    }

    private static final PropertyKind getKindByPrefix(String accessorName) {
        PropertyKind propertyKind;
        block1: {
            PropertyKind[] propertyKindArray = PropertyKind.values();
            int n = propertyKindArray.length;
            for (int j = 0; j < n; ++j) {
                PropertyKind propertyKind2;
                PropertyKind it = propertyKind2 = propertyKindArray[j];
                boolean bl = false;
                String string = it.prefix;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"prefix");
                if (!StringsKt.startsWith$default((String)accessorName, (String)string, (boolean)false, (int)2, null)) continue;
                propertyKind = propertyKind2;
                break block1;
            }
            propertyKind = null;
        }
        return propertyKind;
    }

    private static final String getPropertyNameInner(PropertyKind $this$getPropertyNameInner, String accessorName) {
        int prefixLength = $this$getPropertyNameInner.prefix.length();
        if (!PropertyUtilKt.checkBaseName(accessorName, prefixLength)) {
            return null;
        }
        String string = accessorName.substring(prefixLength);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return Introspector.decapitalize(string);
    }

    private static final boolean checkBaseName(String accessorName, int prefixLength) {
        if (accessorName.length() <= prefixLength) {
            return false;
        }
        if (Character.isUpperCase(accessorName.charAt(prefixLength))) {
            return true;
        }
        if (accessorName.length() <= prefixLength + 1) {
            return false;
        }
        return Character.isUpperCase(accessorName.charAt(prefixLength + 1));
    }

    public static final boolean checkKind(@NotNull PsiMethod $this$checkKind, @NotNull PropertyKind kind) {
        int expectedParamCount;
        Intrinsics.checkNotNullParameter((Object)$this$checkKind, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        int n = expectedParamCount = kind == PropertyKind.SETTER ? 1 : 0;
        if ($this$checkKind.getParameterList().getParametersCount() != expectedParamCount) {
            return false;
        }
        if (kind == PropertyKind.GETTER && Intrinsics.areEqual((Object)$this$checkKind.getReturnType(), (Object)PsiTypes.voidType())) {
            return false;
        }
        return kind != PropertyKind.BOOLEAN_GETTER || PropertyUtilKt.isBooleanOrBoxed($this$checkKind.getReturnType());
    }

    private static final boolean isBooleanOrBoxed(PsiType $this$isBooleanOrBoxed) {
        return Intrinsics.areEqual((Object)$this$isBooleanOrBoxed, (Object)PsiTypes.booleanType()) || Intrinsics.areEqual((Object)PsiPrimitiveType.getUnboxedType((PsiType)$this$isBooleanOrBoxed), (Object)PsiTypes.booleanType());
    }

    public static final boolean isPropertyName(@NotNull String $this$isPropertyName) {
        Intrinsics.checkNotNullParameter((Object)$this$isPropertyName, (String)"<this>");
        return GroovyPropertyUtils.isPropertyName($this$isPropertyName);
    }

    @NotNull
    public static final String getAccessorName(@NotNull PropertyKind $this$getAccessorName, @NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)$this$getAccessorName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        String suffix = propertyName.length() > 1 && Character.isUpperCase(propertyName.charAt(1)) ? propertyName : StringsKt.capitalize((String)propertyName);
        return $this$getAccessorName.prefix + suffix;
    }

    @Nullable
    public static final String getPropertyName(@NotNull PropertyKind $this$getPropertyName, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)$this$getPropertyName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = PropertyUtilKt.getPropertyName($this$getPropertyName, string);
        if (string2 == null) {
            return null;
        }
        String propertyName = string2;
        return PropertyUtilKt.checkKind(method, $this$getPropertyName) ? propertyName : null;
    }

    @Nullable
    public static final String getPropertyName(@NotNull PropertyKind $this$getPropertyName, @NotNull String methodName) {
        Intrinsics.checkNotNullParameter((Object)$this$getPropertyName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        String string = $this$getPropertyName.prefix;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"prefix");
        if (!StringsKt.startsWith$default((String)methodName, (String)string, (boolean)false, (int)2, null)) {
            return null;
        }
        return PropertyUtilKt.getPropertyNameInner($this$getPropertyName, methodName);
    }
}

