/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.dynamic;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicManager;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicPropertyFix;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicDialog;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicElementSettings;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicPropertyDialog;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;

public class DynamicPropertyFromLabelFix
extends DynamicPropertyFix {
    private final SmartPsiElementPointer<GrArgumentLabel> myLabelPointer;
    private final SmartPsiElementPointer<PsiClass> myTargetClassPointer;

    public DynamicPropertyFromLabelFix(@NotNull GrArgumentLabel argumentLabel, @NotNull PsiClass targetClass) {
        if (argumentLabel == null) {
            DynamicPropertyFromLabelFix.$$$reportNull$$$0(0);
        }
        if (targetClass == null) {
            DynamicPropertyFromLabelFix.$$$reportNull$$$0(1);
        }
        this.myLabelPointer = SmartPointersKt.createSmartPointer((PsiElement)argumentLabel);
        this.myTargetClassPointer = SmartPointersKt.createSmartPointer((PsiElement)targetClass);
    }

    @Override
    @Nullable
    protected String getRefName() {
        GrArgumentLabel namedArgument = (GrArgumentLabel)this.myLabelPointer.getElement();
        return namedArgument == null ? null : namedArgument.getName();
    }

    @Override
    @NotNull
    protected DynamicDialog createDialog() {
        return new DynamicPropertyDialog((GrArgumentLabel)this.myLabelPointer.getElement(), (PsiClass)this.myTargetClassPointer.getElement());
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            DynamicPropertyFromLabelFix.$$$reportNull$$$0(2);
        }
        return this.myLabelPointer.getElement() != null && this.myTargetClassPointer.getElement() != null;
    }

    @Override
    public void invoke(Project project) throws IncorrectOperationException {
        GrArgumentLabel argumentLabel = (GrArgumentLabel)this.myLabelPointer.getElement();
        if (argumentLabel == null) {
            return;
        }
        PsiClass targetClass = (PsiClass)this.myTargetClassPointer.getElement();
        if (targetClass == null) {
            return;
        }
        DynamicElementSettings settings = QuickfixUtil.createSettings(argumentLabel, targetClass);
        DynamicManager.getInstance(project).addProperty(settings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentLabel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicPropertyFromLabelFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

