/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class GrHighlightUtil {
    private static final Logger LOG = Logger.getInstance(GrHighlightUtil.class);

    private static Set<GrVariable> getReassignedVariables(PsiElement scope) {
        return (Set)CachedValuesManager.getCachedValue((PsiElement)scope, () -> CachedValueProvider.Result.create(GrHighlightUtil.collectReassignedVariables(scope), (Object[])new Object[]{scope}));
    }

    private static Set<GrVariable> collectReassignedVariables(PsiElement scope) {
        final HashSet<GrVariable> result2 = new HashSet<GrVariable>();
        PsiTreeUtil.processElements((PsiElement)scope, (PsiElementProcessor)new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                PsiElement target;
                GrReferenceExpression ref2;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(element instanceof GrReferenceExpression) || (ref2 = (GrReferenceExpression)element).isQualified()) {
                    return true;
                }
                if (GrHighlightUtil.isWriteAccess(ref2) && ((target = ref2.resolve()) instanceof GrVariable && ((GrVariable)target).getInitializerGroovy() != null || target instanceof GrParameter)) {
                    result2.add((GrVariable)target);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/annotator/GrHighlightUtil$1", "execute"));
            }
        });
        return result2;
    }

    private static boolean isWriteAccess(GrReferenceExpression element) {
        return PsiUtil.isLValue(element) || element.getParent() instanceof GrUnaryExpression && ((GrUnaryExpression)element.getParent()).isPostfix();
    }

    public static boolean isReassigned(GrVariable var) {
        LOG.assertTrue(!DumbService.getInstance((Project)var.getProject()).isDumb());
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)var, PsiMethod.class);
        PsiMethod scope = method == null ? var.getContainingFile() : method;
        return scope != null && GrHighlightUtil.getReassignedVariables((PsiElement)scope).contains(var);
    }

    public static boolean isDeclarationAssignment(GrReferenceExpression refExpr) {
        return GrHighlightUtil.isAssignmentLhs(refExpr) && GrHighlightUtil.isScriptPropertyAccess(refExpr);
    }

    private static boolean isAssignmentLhs(GrReferenceExpression refExpr) {
        return refExpr.getParent() instanceof GrAssignmentExpression && refExpr.equals(((GrAssignmentExpression)refExpr.getParent()).getLValue());
    }

    private static boolean isScriptPropertyAccess(GrReferenceExpression refExpr) {
        GrExpression qualifier = refExpr.getQualifierExpression();
        if (qualifier == null) {
            PsiClass clazz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)refExpr, PsiClass.class);
            return clazz == null;
        }
        PsiType type = qualifier.getType();
        if (type instanceof PsiClassType) {
            PsiClass psiClass;
            PsiClassType classType = (PsiClassType)type;
            if (!(qualifier instanceof GrReferenceExpression && ((GrReferenceExpression)qualifier).resolve() instanceof GroovyScriptClass || !((psiClass = classType.resolve()) instanceof GroovyScriptClass))) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static TextRange getMethodHeaderTextRange(@NotNull PsiMethod method) {
        if (method == null) {
            GrHighlightUtil.$$$reportNull$$$0(0);
        }
        int startOffset = method.getTextRange().getStartOffset();
        int endOffset = method.getParameterList().getTextRange().getEndOffset();
        return new TextRange(startOffset, endOffset);
    }

    public static TextRange getClassHeaderTextRange(GrTypeDefinition clazz) {
        GrExtendsClause extendsClause;
        GrModifierList modifierList = clazz.getModifierList();
        int startOffset = modifierList != null ? modifierList.getTextOffset() : clazz.getTextOffset();
        GrImplementsClause implementsClause = clazz.getImplementsClause();
        int endOffset = implementsClause != null ? implementsClause.getTextRange().getEndOffset() : ((extendsClause = clazz.getExtendsClause()) != null ? extendsClause.getTextRange().getEndOffset() : clazz.getNameIdentifierGroovy().getTextRange().getEndOffset());
        return new TextRange(startOffset, endOffset);
    }

    public static TextRange getInitializerHeaderTextRange(GrClassInitializer initializer) {
        GrModifierList modifierList = initializer.getModifierList();
        GrOpenBlock block = initializer.getBlock();
        TextRange textRange = modifierList.getTextRange();
        LOG.assertTrue(textRange != null, (Object)(initializer.getClass() + ":" + initializer.getText()));
        int startOffset = textRange.getStartOffset();
        int endOffset = block.getLBrace().getTextRange().getEndOffset() + 1;
        return new TextRange(startOffset, endOffset);
    }

    @Nullable
    public static GrMember findClassMemberContainer(@NotNull GrReferenceExpression ref2, @NotNull PsiClass aClass) {
        if (ref2 == null) {
            GrHighlightUtil.$$$reportNull$$$0(1);
        }
        if (aClass == null) {
            GrHighlightUtil.$$$reportNull$$$0(2);
        }
        for (PsiElement parent = ref2.getParent(); parent != null && parent != aClass; parent = parent.getParent()) {
            if (!(parent instanceof GrMember) || ((GrMember)parent).getContainingClass() != aClass) continue;
            return (GrMember)parent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/GrHighlightUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getMethodHeaderTextRange";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findClassMemberContainer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

