/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.statistics.MavenPluginCoordinatesWhitelistValidationRule;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/idea/maven/statistics/MavenPluginCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "groupArtifactId", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "pluginVersion", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "", "isExtension", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "hasConfiguration", "mavenPluginId", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "getGroup", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenPluginCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenPluginCollector.kt\norg/jetbrains/idea/maven/statistics/MavenPluginCollector\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,70:1\n103#2,3:71\n*S KotlinDebug\n*F\n+ 1 MavenPluginCollector.kt\norg/jetbrains/idea/maven/statistics/MavenPluginCollector\n*L\n17#1:71,3\n*E\n"})
public final class MavenPluginCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("maven.plugins", 5, null, 4, null);
    @NotNull
    private final StringEventField groupArtifactId;
    @NotNull
    private final PrimitiveEventField<String> pluginVersion;
    @NotNull
    private final BooleanEventField isExtension;
    @NotNull
    private final BooleanEventField hasConfiguration;
    @NotNull
    private final VarargEventId mavenPluginId;

    public MavenPluginCollector() {
        EventField[] eventFieldArray = EventFields.INSTANCE;
        String name$iv = "group_artifact_id";
        String description$iv = null;
        boolean $i$f$StringValidatedByCustomRule = false;
        this.groupArtifactId = EventFields.StringValidatedByCustomRule((String)name$iv, MavenPluginCoordinatesWhitelistValidationRule.class, description$iv);
        this.pluginVersion = EventFields.Version;
        this.isExtension = EventFields.Boolean((String)"extension");
        this.hasConfiguration = EventFields.Boolean((String)"has_configuration");
        eventFieldArray = new EventField[]{this.groupArtifactId, this.pluginVersion, this.isExtension, this.hasConfiguration};
        this.mavenPluginId = this.getGroup().registerVarargEvent("maven.plugins.used", eventFieldArray);
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
        if (!manager.isMavenizedProject()) {
            return SetsKt.emptySet();
        }
        List<MavenProject> list = manager.getProjects();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getProjects(...)");
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)list), MavenPluginCollector::getMetrics$lambda$0), arg_0 -> MavenPluginCollector.getMetrics$lambda$1(this, arg_0)));
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    private static final Iterable getMetrics$lambda$0(MavenProject it) {
        return it.getDeclaredPlugins();
    }

    private static final MetricEvent getMetrics$lambda$1(MavenPluginCollector this$0, MavenPlugin it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EventPair[] eventPairArray = new EventPair[]{this$0.groupArtifactId.with((Object)(it.getGroupId() + ":" + it.getArtifactId())), this$0.pluginVersion.with((Object)it.getVersion()), this$0.isExtension.with((Object)it.isExtensions()), this$0.hasConfiguration.with((Object)(it.getConfigurationElement() != null ? 1 : 0))};
        return this$0.mavenPluginId.metric(eventPairArray);
    }
}

