/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenParentDesc;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.idea.maven.utils.MavenUtil;

public abstract class MavenParentProjectFileProcessor<RESULT_TYPE> {
    private final Project myProject;

    public MavenParentProjectFileProcessor(Project project) {
        this.myProject = project;
    }

    @Nullable
    public RESULT_TYPE process(@NotNull MavenGeneralSettings generalSettings, @NotNull VirtualFile projectFile, @Nullable MavenParentDesc parentDesc) {
        VirtualFile superPom;
        if (generalSettings == null) {
            MavenParentProjectFileProcessor.$$$reportNull$$$0(0);
        }
        if (projectFile == null) {
            MavenParentProjectFileProcessor.$$$reportNull$$$0(1);
        }
        if ((superPom = MavenUtil.getEffectiveSuperPomWithNoRespectToWrapper(this.myProject)) == null || projectFile.equals(superPom)) {
            return null;
        }
        RESULT_TYPE result2 = null;
        if (parentDesc == null) {
            return this.processSuperParent(superPom);
        }
        VirtualFile parentFile = this.findManagedFile(parentDesc.getParentId());
        if (parentFile != null) {
            result2 = this.processManagedParent(parentFile);
        }
        if (result2 == null && Strings.isEmpty((String)parentDesc.getParentRelativePath()) && (result2 = (RESULT_TYPE)this.findInLocalRepository(generalSettings, parentDesc)) == null) {
            parentDesc = new MavenParentDesc(parentDesc.getParentId(), "../pom.xml");
        }
        if (result2 == null && projectFile.getParent() != null) {
            parentFile = projectFile.getParent().findFileByRelativePath(parentDesc.getParentRelativePath());
            if (parentFile != null && parentFile.isDirectory()) {
                parentFile = parentFile.findFileByRelativePath("pom.xml");
            }
            if (parentFile != null) {
                result2 = this.processRelativeParent(parentFile);
            }
        }
        if (result2 == null) {
            result2 = this.findInLocalRepository(generalSettings, parentDesc);
        }
        return result2;
    }

    private RESULT_TYPE findInLocalRepository(@NotNull MavenGeneralSettings generalSettings, @NotNull MavenParentDesc parentDesc) {
        if (generalSettings == null) {
            MavenParentProjectFileProcessor.$$$reportNull$$$0(2);
        }
        if (parentDesc == null) {
            MavenParentProjectFileProcessor.$$$reportNull$$$0(3);
        }
        RESULT_TYPE result2 = null;
        Path parentIoFile = MavenArtifactUtil.getArtifactFile(generalSettings.getEffectiveLocalRepository(), parentDesc.getParentId(), "pom");
        VirtualFile parentFile = LocalFileSystem.getInstance().findFileByNioFile(parentIoFile);
        if (parentFile != null) {
            result2 = this.processRepositoryParent(parentFile);
        }
        return result2;
    }

    @Nullable
    protected abstract VirtualFile findManagedFile(@NotNull MavenId var1);

    @Nullable
    protected RESULT_TYPE processManagedParent(VirtualFile parentFile) {
        return this.doProcessParent(parentFile);
    }

    @Nullable
    protected RESULT_TYPE processRelativeParent(VirtualFile parentFile) {
        return this.doProcessParent(parentFile);
    }

    @Nullable
    protected RESULT_TYPE processRepositoryParent(VirtualFile parentFile) {
        return this.doProcessParent(parentFile);
    }

    @Nullable
    protected RESULT_TYPE processSuperParent(VirtualFile parentFile) {
        return this.doProcessParent(parentFile);
    }

    @Nullable
    protected abstract RESULT_TYPE doProcessParent(VirtualFile var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generalSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDesc";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/project/MavenParentProjectFileProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findInLocalRepository";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

