/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.fixture;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.util.regex.Pattern;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import org.assertj.core.description.Description;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.swing.cell.JTableCellReader;
import org.assertj.swing.cell.JTableCellWriter;
import org.assertj.swing.core.MouseButton;
import org.assertj.swing.core.MouseClickInfo;
import org.assertj.swing.core.Robot;
import org.assertj.swing.data.TableCell;
import org.assertj.swing.data.TableCellFinder;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.ComponentDriver;
import org.assertj.swing.driver.JTableDriver;
import org.assertj.swing.fixture.AbstractJPopupMenuInvokerFixture;
import org.assertj.swing.fixture.ColorFixture;
import org.assertj.swing.fixture.FontFixture;
import org.assertj.swing.fixture.JPopupMenuFixture;
import org.assertj.swing.fixture.JTableCellFixture;
import org.assertj.swing.fixture.JTableHeaderFixture;

public class JTableFixture
extends AbstractJPopupMenuInvokerFixture<JTableFixture, JTable, JTableDriver> {
    public JTableFixture(@Nonnull Robot robot, @Nonnull JTable target) {
        super(JTableFixture.class, robot, target);
    }

    public JTableFixture(@Nonnull Robot robot, @Nullable String tableName) {
        super(JTableFixture.class, robot, tableName, JTable.class);
    }

    @Override
    @Nonnull
    protected JTableDriver createDriver(@Nonnull Robot robot) {
        return new JTableDriver(robot);
    }

    public FontFixture fontAt(@Nonnull TableCell cell) {
        Font font = ((JTableDriver)this.driver()).font((JTable)this.target(), cell);
        return new FontFixture(Preconditions.checkNotNull(font), this.cellProperty(cell, "font"));
    }

    @Nonnull
    public ColorFixture backgroundAt(@Nonnull TableCell cell) {
        Color background = ((JTableDriver)this.driver()).background((JTable)this.target(), cell);
        return new ColorFixture(Preconditions.checkNotNull(background), this.cellProperty(cell, "background"));
    }

    @Nonnull
    public ColorFixture foregroundAt(@Nonnull TableCell cell) {
        Color foreground = ((JTableDriver)this.driver()).foreground((JTable)this.target(), cell);
        return new ColorFixture(Preconditions.checkNotNull(foreground), this.cellProperty(cell, "foreground"));
    }

    @Nonnull
    private Description cellProperty(TableCell cell, String propertyName) {
        return ComponentDriver.propertyName(this.target(), Strings.concat(propertyName, " ", cell));
    }

    @Nonnull
    public JTableCellFixture cell(String value) {
        TableCell cell = ((JTableDriver)this.driver()).cell((JTable)this.target(), value);
        return new JTableCellFixture(this, cell);
    }

    @Nonnull
    public JTableCellFixture cell(@Nonnull Pattern valuePattern) {
        TableCell cell = ((JTableDriver)this.driver()).cell((JTable)this.target(), valuePattern);
        return new JTableCellFixture(this, cell);
    }

    @Nonnull
    public JTableCellFixture cell(@Nonnull TableCellFinder cellFinder) {
        TableCell cell = ((JTableDriver)this.driver()).cell((JTable)this.target(), cellFinder);
        return new JTableCellFixture(this, cell);
    }

    @Nonnull
    public JTableCellFixture cell(@Nonnull TableCell cell) {
        ((JTableDriver)this.driver()).checkCellIndicesInBounds((JTable)this.target(), cell);
        return new JTableCellFixture(this, cell);
    }

    @Nonnull
    public JTableHeaderFixture tableHeader() {
        JTableHeader tableHeader = ((JTableDriver)this.driver()).tableHeaderOf((JTable)this.target());
        return new JTableHeaderFixture(this.robot(), Preconditions.checkNotNull(tableHeader));
    }

    @Nullable
    public String selectionValue() {
        return ((JTableDriver)this.driver()).selectionValue((JTable)this.target());
    }

    @Nonnull
    public Point pointAt(@Nonnull TableCell cell) {
        return ((JTableDriver)this.driver()).pointAt((JTable)this.target(), cell);
    }

    @Nonnull
    public String[][] contents() {
        return ((JTableDriver)this.driver()).contents((JTable)this.target());
    }

    public int rowCount() {
        return ((JTableDriver)this.driver()).rowCountOf((JTable)this.target());
    }

    @Nullable
    public String valueAt(@Nonnull TableCell cell) {
        return ((JTableDriver)this.driver()).value((JTable)this.target(), cell);
    }

    @Nonnull
    public JTableFixture selectCell(@Nonnull TableCell cell) {
        ((JTableDriver)this.driver()).selectCell((JTable)this.target(), cell);
        return this;
    }

    @Nonnull
    public JTableFixture selectCells(TableCell ... cells) {
        ((JTableDriver)this.driver()).selectCells((JTable)this.target(), cells);
        return this;
    }

    @Nonnull
    public JTableFixture selectRows(int ... rows) {
        ((JTableDriver)this.driver()).selectRows((JTable)this.target(), rows);
        return this;
    }

    @Nonnull
    public JTableFixture unselectCell(@Nonnull TableCell cell) {
        ((JTableDriver)this.driver()).unselectCell((JTable)this.target(), cell);
        return this;
    }

    @Nonnull
    public JTableFixture unselectCells(TableCell ... cells) {
        ((JTableDriver)this.driver()).unselectCells((JTable)this.target(), cells);
        return this;
    }

    @Nonnull
    public JTableFixture unselectRows(int ... rows) {
        ((JTableDriver)this.driver()).unselectRows((JTable)this.target(), rows);
        return this;
    }

    @Nonnull
    public JTableFixture drag(@Nonnull TableCell cell) {
        ((JTableDriver)this.driver()).drag((JTable)this.target(), cell);
        return this;
    }

    @Nonnull
    public JTableFixture drop(@Nonnull TableCell cell) {
        ((JTableDriver)this.driver()).drop((JTable)this.target(), cell);
        return this;
    }

    @Nonnull
    public JTableFixture click(@Nonnull TableCell cell, @Nonnull MouseButton button2) {
        this.click(cell, button2, 1);
        return this;
    }

    @Nonnull
    public JTableFixture click(@Nonnull TableCell cell, @Nonnull MouseClickInfo mouseClickInfo) {
        Preconditions.checkNotNull(mouseClickInfo);
        this.click(cell, mouseClickInfo.button(), mouseClickInfo.times());
        return this;
    }

    void click(@Nonnull TableCell cell, @Nonnull MouseButton button2, int times) {
        ((JTableDriver)this.driver()).click((JTable)this.target(), cell, button2, times);
    }

    @Nonnull
    public JTableFixture enterValue(@Nonnull TableCell cell, @Nonnull String value) {
        ((JTableDriver)this.driver()).enterValueInCell((JTable)this.target(), cell, value);
        return this;
    }

    public void replaceCellReader(@Nonnull JTableCellReader cellReader) {
        ((JTableDriver)this.driver()).replaceCellReader(cellReader);
    }

    @Nonnull
    public JTableFixture requireRowCount(int expected) {
        ((JTableDriver)this.driver()).requireRowCount((JTable)this.target(), expected);
        return this;
    }

    @Nonnull
    public JTableFixture requireSelectedRows(int ... rows) {
        ((JTableDriver)this.driver()).requireSelectedRows((JTable)this.target(), rows);
        return this;
    }

    @Nonnull
    public JTableFixture requireColumnCount(int expected) {
        ((JTableDriver)this.driver()).requireColumnCount((JTable)this.target(), expected);
        return this;
    }

    @Nonnull
    public JTableFixture requireEditable(@Nonnull TableCell cell) {
        ((JTableDriver)this.driver()).requireEditable((JTable)this.target(), cell);
        return this;
    }

    @Nonnull
    public JTableFixture requireNotEditable(@Nonnull TableCell cell) {
        ((JTableDriver)this.driver()).requireNotEditable((JTable)this.target(), cell);
        return this;
    }

    @Nonnull
    public JTableFixture requireNoSelection() {
        ((JTableDriver)this.driver()).requireNoSelection((JTable)this.target());
        return this;
    }

    @Nonnull
    public JTableFixture requireCellValue(@Nonnull TableCell cell, @Nullable String value) {
        ((JTableDriver)this.driver()).requireCellValue((JTable)this.target(), cell, value);
        return this;
    }

    @Nonnull
    public JTableFixture requireCellValue(@Nonnull TableCell cell, @Nonnull Pattern pattern) {
        ((JTableDriver)this.driver()).requireCellValue((JTable)this.target(), cell, pattern);
        return this;
    }

    @Nonnull
    public JTableFixture requireContents(@Nonnull String[][] contents) {
        ((JTableDriver)this.driver()).requireContents((JTable)this.target(), contents);
        return this;
    }

    public void replaceCellWriter(JTableCellWriter cellWriter) {
        ((JTableDriver)this.driver()).replaceCellWriter(cellWriter);
    }

    public int columnIndexFor(@Nonnull Object columnName) {
        return ((JTableDriver)this.driver()).columnIndex((JTable)this.target(), columnName);
    }

    public JTableFixture requireColumnNamed(String columnName) {
        this.columnIndexFor(columnName);
        return this;
    }

    @Nonnull
    public JPopupMenuFixture showPopupMenuAt(@Nonnull TableCell cell) {
        return new JPopupMenuFixture(this.robot(), ((JTableDriver)this.driver()).showPopupMenuAt((JTable)this.target(), cell));
    }
}

