/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.diff.comparison.TrimUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.commit.message.CommitMessageInspectionProfile;
import com.intellij.vcs.commit.message.SubjectLimitInspection;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CommitPresentationUtil {
    @NotNull
    private static final Pattern HASH_PATTERN = Pattern.compile("[0-9a-f]{7,40}", 2);
    @NotNull
    @NlsSafe
    private static final String GO_TO_HASH = "go-to-hash:";
    @NotNull
    @NlsSafe
    private static final String SHOW_HIDE_BRANCHES = "show-hide-branches";
    @NlsSafe
    private static final String ELLIPSIS = "...";
    private static final int BIG_CUT_SIZE = 10;
    private static final double EPSILON = 1.5;
    private static final String ROBOTIC_REPORTERS_KEY = "vcs.log.git.committers.robots";
    @Nullable
    private static Set<String> myRoboticReporters = null;

    public static boolean isShowHideBranches(@NotNull HyperlinkEvent e) {
        if (e == null) {
            CommitPresentationUtil.$$$reportNull$$$0(0);
        }
        return SHOW_HIDE_BRANCHES.equals(e.getDescription());
    }

    public static boolean isGoToHash(@NotNull HyperlinkEvent e) {
        if (e == null) {
            CommitPresentationUtil.$$$reportNull$$$0(1);
        }
        return e.getDescription().startsWith(GO_TO_HASH);
    }

    @NotNull
    public static String getAuthorPresentation(@NotNull VcsShortCommitDetails details) {
        if (details == null) {
            CommitPresentationUtil.$$$reportNull$$$0(2);
        }
        VcsUser author = details.getAuthor();
        VcsUser committer = details.getCommitter();
        String authorString = VcsUserUtil.getShortPresentation((VcsUser)author);
        Set<String> robots = CommitPresentationUtil.getRoboticReporters();
        String asterisk = VcsUserUtil.isSamePerson((VcsUser)author, (VcsUser)committer) || robots.contains(committer.getEmail()) ? "" : "*";
        String string = authorString + asterisk;
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static Set<String> getRoboticReporters() {
        Set<String> rr = myRoboticReporters;
        if (rr == null) {
            myRoboticReporters = rr = CommitPresentationUtil.prepareRoboticReporters();
        }
        Set<String> set = rr;
        if (set == null) {
            CommitPresentationUtil.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    private static Set<String> prepareRoboticReporters() {
        String str = Registry.stringValue((String)ROBOTIC_REPORTERS_KEY);
        if (str.isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                CommitPresentationUtil.$$$reportNull$$$0(5);
            }
            return set;
        }
        Set<String> set = StringUtil.split((String)str, (String)",", (boolean)true, (boolean)true).stream().map(s -> s.trim()).filter(s -> !s.isEmpty()).collect(Collectors.toUnmodifiableSet());
        if (set == null) {
            CommitPresentationUtil.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    @Nls
    private static String escapeMultipleSpaces(@NotNull @Nls String text) {
        if (text == null) {
            CommitPresentationUtil.$$$reportNull$$$0(7);
        }
        @Nls StringBuilder result = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == ' ') {
                if (i == text.length() - 1 || text.charAt(i + 1) != ' ') {
                    result.append(' ');
                    continue;
                }
                result.append("&nbsp;");
                continue;
            }
            if (text.charAt(i) == '\t') {
                result.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                continue;
            }
            result.append(text.charAt(i));
        }
        String string = result.toString();
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static @NotNull Set<@NlsSafe String> findHashes(@NotNull @NlsSafe String text) {
        if (text == null) {
            CommitPresentationUtil.$$$reportNull$$$0(9);
        }
        HashSet<String> result = new HashSet<String>();
        Matcher matcher = HASH_PATTERN.matcher(text);
        while (matcher.find()) {
            result.add(matcher.group());
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            CommitPresentationUtil.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    @NotNull
    @NlsSafe
    private static String replaceHashes(@NotNull @NlsSafe String s, @NotNull Set<@NlsSafe String> resolvedHashes) {
        if (s == null) {
            CommitPresentationUtil.$$$reportNull$$$0(11);
        }
        if (resolvedHashes == null) {
            CommitPresentationUtil.$$$reportNull$$$0(12);
        }
        Matcher matcher = HASH_PATTERN.matcher(s);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String hash = matcher.group();
            if (resolvedHashes.contains(hash)) {
                hash = HtmlChunk.link((String)(GO_TO_HASH + hash), (String)hash).toString();
            }
            matcher.appendReplacement(result, hash);
        }
        matcher.appendTail(result);
        String string = result.toString();
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static @NotNull Set<@NlsSafe String> findHashes(@NotNull Project project, @NotNull @NlsSafe String message) {
        if (project == null) {
            CommitPresentationUtil.$$$reportNull$$$0(14);
        }
        if (message == null) {
            CommitPresentationUtil.$$$reportNull$$$0(15);
        }
        HashSet<String> unresolvedHashes = new HashSet<String>();
        IssueLinkHtmlRenderer.formatTextWithLinks((Project)project, (String)message, s -> {
            unresolvedHashes.addAll(CommitPresentationUtil.findHashes(s));
            return s;
        });
        HashSet<String> hashSet = unresolvedHashes;
        if (hashSet == null) {
            CommitPresentationUtil.$$$reportNull$$$0(16);
        }
        return hashSet;
    }

    @NotNull
    @NlsSafe
    private static String formatCommitText(@NotNull Project project, @NotNull @NlsSafe String fullMessage, @NotNull Set<@NlsSafe String> resolvedHashes) {
        if (project == null) {
            CommitPresentationUtil.$$$reportNull$$$0(17);
        }
        if (fullMessage == null) {
            CommitPresentationUtil.$$$reportNull$$$0(18);
        }
        if (resolvedHashes == null) {
            CommitPresentationUtil.$$$reportNull$$$0(19);
        }
        fullMessage = VcsUtil.trimCommitMessageToSaneSize((String)fullMessage);
        Font font = FontUtil.getCommitMessageFont();
        Convertor convertor = s -> CommitPresentationUtil.replaceHashes(s, resolvedHashes);
        Object subject = CommitPresentationUtil.getSubject(fullMessage);
        Object description = fullMessage.substring(((String)subject).length());
        if (((String)subject).contains("\n")) {
            return CommitPresentationUtil.formatText(project, fullMessage, font, font.getStyle(), (Convertor<? super String, String>)convertor);
        }
        if (CommitPresentationUtil.isSubjectMarginEnabled(project)) {
            int margin = CommitMessageInspectionProfile.getSubjectRightMargin((Project)project);
            if (margin < ELLIPSIS.length()) {
                margin = 5;
            }
            if ((double)((String)subject).length() > (double)margin * 1.5) {
                int placeToCut;
                for (int i = placeToCut = margin - ELLIPSIS.length(); i >= Math.max(margin - 10, 10); --i) {
                    if (((String)subject).charAt(i) != ' ') continue;
                    placeToCut = i;
                    break;
                }
                Object tail = ((String)subject).substring(placeToCut);
                if (TrimUtil.isPunctuation((char)((String)(subject = ((String)subject).substring(0, placeToCut))).charAt(placeToCut - 1))) {
                    tail = StringUtil.trimStart((String)tail, (String)" ");
                } else {
                    subject = (String)subject + ELLIPSIS;
                    tail = ELLIPSIS + (String)tail;
                }
                description = "\n\n" + (String)tail + (String)description;
            }
        }
        String string = "<b>" + CommitPresentationUtil.formatText(project, (String)subject, font, 1, (Convertor<? super String, String>)convertor) + "</b>" + CommitPresentationUtil.formatText(project, (String)description, font, font.getStyle(), (Convertor<? super String, String>)convertor);
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String getSubject(@NotNull @NlsSafe String fullMessage) {
        int separator;
        if (fullMessage == null) {
            CommitPresentationUtil.$$$reportNull$$$0(21);
        }
        String string = (separator = fullMessage.indexOf("\n\n")) > 0 ? fullMessage.substring(0, separator) : fullMessage;
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    public static boolean isSubjectMarginEnabled(@NotNull Project project) {
        if (project == null) {
            CommitPresentationUtil.$$$reportNull$$$0(23);
        }
        return CommitMessageInspectionProfile.getInstance((Project)project).isToolEnabled(SubjectLimitInspection.class);
    }

    @NotNull
    private static String formatText(@NotNull Project project, @NotNull @Nls String text, @NotNull Font font, int style, @NotNull Convertor<? super String, String> convertor) {
        if (project == null) {
            CommitPresentationUtil.$$$reportNull$$$0(24);
        }
        if (text == null) {
            CommitPresentationUtil.$$$reportNull$$$0(25);
        }
        if (font == null) {
            CommitPresentationUtil.$$$reportNull$$$0(26);
        }
        if (convertor == null) {
            CommitPresentationUtil.$$$reportNull$$$0(27);
        }
        String string = FontUtil.getHtmlWithFonts((String)CommitPresentationUtil.escapeMultipleSpaces(IssueLinkHtmlRenderer.formatTextWithLinks((Project)project, (String)text, convertor)), (int)style, (Font)font);
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(28);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    @Nls
    private static String getAuthorAndCommitterText(@NotNull VcsUser author, long authorTime, @NotNull VcsUser committer, long l) {
        void commitTime;
        if (author == null) {
            CommitPresentationUtil.$$$reportNull$$$0(29);
        }
        if (committer == null) {
            CommitPresentationUtil.$$$reportNull$$$0(30);
        }
        String authorText = VcsLogBundle.message("vcs.log.details.author.on.date.at.time", CommitPresentationUtil.getAuthorName(author), DateFormatUtil.formatDate((long)authorTime), DateFormatUtil.formatTime((long)authorTime));
        HtmlBuilder builder = new HtmlBuilder().appendRaw(authorText);
        if (!VcsUserUtil.isSamePerson((VcsUser)author, (VcsUser)committer)) {
            builder.br().append(CommitPresentationUtil.getCommitterHtml(committer, commitTime != authorTime ? Long.valueOf((long)commitTime) : null));
        } else if (authorTime != commitTime) {
            builder.br().append(CommitPresentationUtil.getCommitterHtml(null, (long)commitTime));
        }
        String string = builder.toString();
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    private static HtmlChunk getCommitterHtml(@Nullable VcsUser committer, @Nullable Long commitTime) {
        String committed;
        if (committer == null && commitTime == null) {
            HtmlChunk htmlChunk = HtmlChunk.empty();
            if (htmlChunk == null) {
                CommitPresentationUtil.$$$reportNull$$$0(32);
            }
            return htmlChunk;
        }
        String style = "color:#" + ColorUtil.toHex((Color)JBColor.GRAY);
        HtmlChunk.Element graySpan = HtmlChunk.span((String)style);
        if (committer == null) {
            String date = DateFormatUtil.formatDate((long)commitTime);
            String time = DateFormatUtil.formatTime((long)commitTime);
            committed = VcsLogBundle.message("vcs.log.details.committer.info.date.time", date, time);
        } else {
            String by = VcsUserUtil.getShortPresentation((VcsUser)committer) + (String)(!committer.getEmail().isEmpty() ? "</span> " + CommitPresentationUtil.getEmailLink(committer) + "<span style=\"" + style + "\">" : "");
            if (commitTime == null) {
                committed = VcsLogBundle.message("vcs.log.details.committer.info.user", by);
            } else {
                String date = DateFormatUtil.formatDate((long)commitTime);
                String time = DateFormatUtil.formatTime((long)commitTime);
                committed = VcsLogBundle.message("vcs.log.details.committer.info.user.date.time", by, date, time);
            }
        }
        HtmlChunk.Element element = new HtmlBuilder().appendRaw(committed).wrapWith(graySpan);
        if (element == null) {
            CommitPresentationUtil.$$$reportNull$$$0(33);
        }
        return element;
    }

    @NotNull
    @NlsSafe
    private static String getAuthorName(@NotNull VcsUser user) {
        if (user == null) {
            CommitPresentationUtil.$$$reportNull$$$0(34);
        }
        String username = VcsUserUtil.getShortPresentation((VcsUser)user);
        Object object = user.getEmail().isEmpty() ? username : username + " " + CommitPresentationUtil.getEmailLink(user);
        if (object == null) {
            CommitPresentationUtil.$$$reportNull$$$0(35);
        }
        return object;
    }

    @NotNull
    private static HtmlChunk.Element getEmailLink(@NotNull VcsUser user) {
        if (user == null) {
            CommitPresentationUtil.$$$reportNull$$$0(36);
        }
        HtmlChunk.Element element = HtmlChunk.link((String)("mailto:" + user.getEmail()), (String)("<" + user.getEmail() + ">"));
        if (element == null) {
            CommitPresentationUtil.$$$reportNull$$$0(37);
        }
        return element;
    }

    @NotNull
    @Nls
    private static String formatCommitHashAndAuthor(@NotNull VcsCommitMetadata commit) {
        if (commit == null) {
            CommitPresentationUtil.$$$reportNull$$$0(38);
        }
        return CommitPresentationUtil.formatCommitHashAndAuthor((Hash)commit.getId(), commit.getAuthor(), commit.getAuthorTime(), commit.getCommitter(), commit.getCommitTime());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    @Nls
    public static String formatCommitHashAndAuthor(@NotNull Hash commitId, @NotNull VcsUser author, long authorTime, @NotNull VcsUser committer, long l) {
        void commitTime;
        if (commitId == null) {
            CommitPresentationUtil.$$$reportNull$$$0(39);
        }
        if (author == null) {
            CommitPresentationUtil.$$$reportNull$$$0(40);
        }
        if (committer == null) {
            CommitPresentationUtil.$$$reportNull$$$0(41);
        }
        Font font = FontUtil.getCommitMetadataFont();
        String string = FontUtil.getHtmlWithFonts((String)(commitId.toShortString() + " " + CommitPresentationUtil.getAuthorAndCommitterText(author, authorTime, committer, (long)commitTime)), (int)font.getStyle(), (Font)font);
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(42);
        }
        return string;
    }

    @NotNull
    @Nls
    public static String getBranchesLinkText(@Nullable List<@NlsSafe String> branches, boolean expanded, int availableWidth, @NotNull FontMetrics metrics) {
        if (metrics == null) {
            CommitPresentationUtil.$$$reportNull$$$0(43);
        }
        if (branches == null) {
            String string = VcsLogBundle.message("vcs.log.details.in.branches.loading", new Object[0]);
            if (string == null) {
                CommitPresentationUtil.$$$reportNull$$$0(44);
            }
            return string;
        }
        if (branches.isEmpty()) {
            String string = VcsLogBundle.message("vcs.log.details.in.branches.empty", new Object[0]);
            if (string == null) {
                CommitPresentationUtil.$$$reportNull$$$0(45);
            }
            return string;
        }
        String head = VcsLogBundle.message("vcs.log.details.in.branches", branches.size()) + " ";
        if (expanded) {
            String string = new HtmlBuilder().append(head).append((HtmlChunk)HtmlChunk.link((String)SHOW_HIDE_BRANCHES, (String)VcsLogBundle.message("vcs.log.details.in.branches.hide", new Object[0]))).toString();
            if (string == null) {
                CommitPresentationUtil.$$$reportNull$$$0(46);
            }
            return string;
        }
        String tail = "\u2026 " + HtmlChunk.link((String)SHOW_HIDE_BRANCHES, (String)VcsLogBundle.message("vcs.log.details.in.branches.show.all", new Object[0]));
        int headAndTailWidth = metrics.stringWidth(head) + metrics.stringWidth(StringUtil.removeHtmlTags((String)tail));
        if (availableWidth <= headAndTailWidth) {
            String string = head + tail;
            if (string == null) {
                CommitPresentationUtil.$$$reportNull$$$0(47);
            }
            return string;
        }
        availableWidth -= headAndTailWidth;
        StringBuilder branchesText = new StringBuilder();
        for (int i = 0; i < branches.size(); ++i) {
            String branch = branches.get(i) + (i != branches.size() - 1 ? ", " : "");
            int branchWidth = metrics.stringWidth(branch);
            if (branchWidth < availableWidth) {
                branchesText.append(branch);
                availableWidth -= branchWidth;
                continue;
            }
            StringBuilder shortenedBranch = new StringBuilder();
            for (char c : branch.toCharArray()) {
                if (metrics.stringWidth(shortenedBranch.toString() + c) >= availableWidth) break;
                shortenedBranch.append(c);
            }
            branchesText.append((CharSequence)shortenedBranch);
            branchesText.append(tail);
            break;
        }
        String string = head + branchesText;
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(48);
        }
        return string;
    }

    @NotNull
    public static CommitPresentation buildPresentation(@NotNull Project project, @NotNull VcsCommitMetadata commit, @NotNull Set<? super String> unresolvedHashes) {
        if (project == null) {
            CommitPresentationUtil.$$$reportNull$$$0(49);
        }
        if (commit == null) {
            CommitPresentationUtil.$$$reportNull$$$0(50);
        }
        if (unresolvedHashes == null) {
            CommitPresentationUtil.$$$reportNull$$$0(51);
        }
        String rawMessage = commit.getFullMessage();
        String hashAndAuthor = CommitPresentationUtil.formatCommitHashAndAuthor(commit);
        Set<String> unresolvedHashesForCommit = CommitPresentationUtil.findHashes(project, rawMessage);
        if (unresolvedHashesForCommit.isEmpty()) {
            return new CommitPresentation(project, commit.getRoot(), rawMessage, hashAndAuthor, (MultiMap<String, CommitId>)MultiMap.empty());
        }
        unresolvedHashes.addAll(unresolvedHashesForCommit);
        return new UnresolvedPresentation(project, commit.getRoot(), rawMessage, hashAndAuthor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 8, 10, 13, 16, 20, 22, 28, 31, 32, 33, 35, 37, 42, 44, 45, 46, 47, 48 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 22: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/frame/CommitPresentationUtil";
                break;
            }
            case 7: 
            case 9: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedHashes";
                break;
            }
            case 14: 
            case 17: 
            case 23: 
            case 24: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullMessage";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
            case 29: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "author";
                break;
            }
            case 30: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "committer";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 38: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metrics";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unresolvedHashes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/frame/CommitPresentationUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthorPresentation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoboticReporters";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareRoboticReporters";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeMultipleSpaces";
                break;
            }
            case 10: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findHashes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceHashes";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "formatCommitText";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubject";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "formatText";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthorAndCommitterText";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitterHtml";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthorName";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmailLink";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "formatCommitHashAndAuthor";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchesLinkText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isShowHideBranches";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isGoToHash";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAuthorPresentation";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 22: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "escapeMultipleSpaces";
                break;
            }
            case 9: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findHashes";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "replaceHashes";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "formatCommitText";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSubject";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isSubjectMarginEnabled";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "formatText";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getAuthorAndCommitterText";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAuthorName";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getEmailLink";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "formatCommitHashAndAuthor";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getBranchesLinkText";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "buildPresentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 8, 10, 13, 16, 20, 22, 28, 31, 32, 33, 35, 37, 42, 44, 45, 46, 47, 48 -> new IllegalStateException(string);
        };
    }

    public static class CommitPresentation {
        @NotNull
        protected final Project myProject;
        @NotNull
        @NlsSafe
        protected final String myRawMessage;
        @NotNull
        @Nls
        protected final String myHashAndAuthor;
        @NotNull
        protected final VirtualFile myRoot;
        private final @NotNull MultiMap<@NlsSafe String, CommitId> myResolvedHashes;

        public CommitPresentation(@NotNull Project project, @NotNull VirtualFile root, @NotNull @NlsSafe String rawMessage, @NotNull @Nls String hashAndAuthor, @NotNull MultiMap<@NlsSafe String, CommitId> resolvedHashes) {
            if (project == null) {
                CommitPresentation.$$$reportNull$$$0(0);
            }
            if (root == null) {
                CommitPresentation.$$$reportNull$$$0(1);
            }
            if (rawMessage == null) {
                CommitPresentation.$$$reportNull$$$0(2);
            }
            if (hashAndAuthor == null) {
                CommitPresentation.$$$reportNull$$$0(3);
            }
            if (resolvedHashes == null) {
                CommitPresentation.$$$reportNull$$$0(4);
            }
            this.myProject = project;
            this.myRoot = root;
            this.myRawMessage = rawMessage;
            this.myHashAndAuthor = hashAndAuthor;
            this.myResolvedHashes = resolvedHashes;
        }

        @NotNull
        @NlsSafe
        public String getText() {
            String string = CommitPresentationUtil.formatCommitText(this.myProject, this.myRawMessage, this.myResolvedHashes.keySet());
            if (string == null) {
                CommitPresentation.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        @Nls
        public String getHashAndAuthor() {
            String string = this.myHashAndAuthor;
            if (string == null) {
                CommitPresentation.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Nullable
        public CommitId parseTargetCommit(@NotNull HyperlinkEvent e) {
            if (e == null) {
                CommitPresentation.$$$reportNull$$$0(7);
            }
            if (!e.getDescription().startsWith(CommitPresentationUtil.GO_TO_HASH)) {
                return null;
            }
            String hash = e.getDescription().substring(CommitPresentationUtil.GO_TO_HASH.length());
            Collection ids2 = this.myResolvedHashes.get((Object)hash);
            if (ids2.size() <= 1) {
                return (CommitId)ContainerUtil.getFirstItem((Collection)ids2);
            }
            for (CommitId id : ids2) {
                if (!this.myRoot.equals(id.getRoot())) continue;
                return id;
            }
            return (CommitId)ContainerUtil.getFirstItem((Collection)ids2);
        }

        @NotNull
        public CommitPresentation resolve(@NotNull MultiMap<String, CommitId> resolvedHashes) {
            if (resolvedHashes == null) {
                CommitPresentation.$$$reportNull$$$0(8);
            }
            CommitPresentation commitPresentation = this;
            if (commitPresentation == null) {
                CommitPresentation.$$$reportNull$$$0(9);
            }
            return commitPresentation;
        }

        public boolean isResolved() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rawMessage";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hashAndAuthor";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolvedHashes";
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/frame/CommitPresentationUtil$CommitPresentation";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/frame/CommitPresentationUtil$CommitPresentation";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHashAndAuthor";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "parseTargetCommit";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 9 -> new IllegalStateException(string);
            };
        }
    }

    private static class UnresolvedPresentation
    extends CommitPresentation {
        UnresolvedPresentation(@NotNull Project project, @NotNull VirtualFile root, @NotNull @NlsSafe String rawMessage, @NotNull @Nls String hashAndAuthor) {
            if (project == null) {
                UnresolvedPresentation.$$$reportNull$$$0(0);
            }
            if (root == null) {
                UnresolvedPresentation.$$$reportNull$$$0(1);
            }
            if (rawMessage == null) {
                UnresolvedPresentation.$$$reportNull$$$0(2);
            }
            if (hashAndAuthor == null) {
                UnresolvedPresentation.$$$reportNull$$$0(3);
            }
            super(project, root, rawMessage, hashAndAuthor, (MultiMap<String, CommitId>)MultiMap.empty());
        }

        @Override
        @NotNull
        public CommitPresentation resolve(@NotNull MultiMap<String, CommitId> resolvedHashes) {
            if (resolvedHashes == null) {
                UnresolvedPresentation.$$$reportNull$$$0(4);
            }
            return new CommitPresentation(this.myProject, this.myRoot, this.myRawMessage, this.myHashAndAuthor, resolvedHashes);
        }

        @Override
        public boolean isResolved() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rawMessage";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hashAndAuthor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolvedHashes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/frame/CommitPresentationUtil$UnresolvedPresentation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolve";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

