/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.FilterPopupComponent;
import com.intellij.vcs.log.ui.filter.MultilinePopupBuilder;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class MultipleValueFilterPopupComponent<Filter, Model extends FilterModel<Filter>>
extends FilterPopupComponent<Filter, Model> {
    private static final int MAX_FILTER_VALUE_LENGTH = 20;
    @NotNull
    protected final MainVcsLogUiProperties myUiProperties;
    @NonNls
    @NotNull
    private final String myName;

    MultipleValueFilterPopupComponent(@NonNls @NotNull String filterName, @NotNull @NotNull Supplier<@NlsContexts.Label @NotNull String> displayName, @NotNull MainVcsLogUiProperties uiProperties, @NotNull Model filterModel) {
        if (filterName == null) {
            MultipleValueFilterPopupComponent.$$$reportNull$$$0(0);
        }
        if (displayName == null) {
            MultipleValueFilterPopupComponent.$$$reportNull$$$0(1);
        }
        if (uiProperties == null) {
            MultipleValueFilterPopupComponent.$$$reportNull$$$0(2);
        }
        if (filterModel == null) {
            MultipleValueFilterPopupComponent.$$$reportNull$$$0(3);
        }
        super(displayName, filterModel);
        this.myName = filterName;
        this.myUiProperties = uiProperties;
    }

    @NotNull
    protected List<List<String>> getRecentValuesFromSettings() {
        List<List<String>> list = this.myUiProperties.getRecentlyFilteredGroups(this.myName);
        if (list == null) {
            MultipleValueFilterPopupComponent.$$$reportNull$$$0(4);
        }
        return list;
    }

    protected void rememberValuesInSettings(@NotNull Collection<String> values) {
        if (values == null) {
            MultipleValueFilterPopupComponent.$$$reportNull$$$0(5);
        }
        this.myUiProperties.addRecentlyFilteredGroup(this.myName, this.parseLocalizedValues(values));
    }

    @NotNull
    protected abstract List<String> getAllValues();

    @Nullable
    protected abstract Filter createFilter(@NotNull List<String> var1);

    @NotNull
    protected abstract List<String> getFilterValues(@NotNull Filter var1);

    @NotNull
    protected List<AnAction> createRecentItemsActionGroup() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        List<List<String>> recentlyFiltered = this.getRecentValuesFromSettings();
        if (!recentlyFiltered.isEmpty()) {
            group.add((AnAction)Separator.create((String)VcsLogBundle.message("vcs.log.filter.recent", new Object[0])));
            for (List<String> recentGroup : recentlyFiltered) {
                if (recentGroup.isEmpty()) continue;
                group.add((AnAction)new PredefinedValueAction(this, recentGroup));
            }
            group.add((AnAction)Separator.getInstance());
        }
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            MultipleValueFilterPopupComponent.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected String getText(@NotNull Filter filter) {
        if (filter == null) {
            MultipleValueFilterPopupComponent.$$$reportNull$$$0(7);
        }
        return MultipleValueFilterPopupComponent.displayableText(this.getLocalizedValues(this.getFilterValues(filter)), 20);
    }

    @Override
    @Nls
    protected String getToolTip(@NotNull Filter filter) {
        if (filter == null) {
            MultipleValueFilterPopupComponent.$$$reportNull$$$0(8);
        }
        return this.getTooltip(this.getFilterValues(filter));
    }

    @NotNull
    @NlsContexts.Tooltip
    protected String getTooltip(@NotNull Collection<String> values) {
        if (values == null) {
            MultipleValueFilterPopupComponent.$$$reportNull$$$0(9);
        }
        String string = StringUtil.join(this.getLocalizedValues(values), (String)", ");
        if (string == null) {
            MultipleValueFilterPopupComponent.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    protected abstract List<String> parseLocalizedValues(@NotNull Collection<String> var1);

    protected abstract @NotNull List<@Nls String> getLocalizedValues(@NotNull Collection<String> var1);

    @NotNull
    protected AnAction createSelectMultipleValuesAction() {
        return new SelectMultipleValuesAction();
    }

    @ApiStatus.Internal
    @Nullable
    protected MultilinePopupBuilder.CompletionPrefixProvider getCompletionPrefixProvider() {
        return null;
    }

    @NotNull
    protected String getActionName(@NotNull List<String> values) {
        List<String> localizedValues;
        if (values == null) {
            MultipleValueFilterPopupComponent.$$$reportNull$$$0(11);
        }
        if ((localizedValues = this.getLocalizedValues(values)).size() == 1) {
            String string = Objects.requireNonNull((String)ContainerUtil.getFirstItem(localizedValues));
            if (string == null) {
                MultipleValueFilterPopupComponent.$$$reportNull$$$0(12);
            }
            return string;
        }
        return MultipleValueFilterPopupComponent.displayableText(localizedValues, 40);
    }

    @NotNull
    @Nls
    static String displayableText(@NotNull Collection<@Nls String> values, int maxLength) {
        if (values == null) {
            MultipleValueFilterPopupComponent.$$$reportNull$$$0(13);
        }
        String text = values.size() == 1 ? Objects.requireNonNull((String)ContainerUtil.getFirstItem(values)) : StringUtil.join(values, (String)"|");
        String string = StringUtil.shortenTextWithEllipsis((String)text, (int)maxLength, (int)0, (boolean)true);
        if (string == null) {
            MultipleValueFilterPopupComponent.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 10, 12, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterModel";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentValuesFromSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createRecentItemsActionGroup";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltip";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "displayableText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 12: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "rememberValuesInSettings";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getToolTip";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTooltip";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getActionName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "displayableText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 10, 12, 14 -> new IllegalStateException(string);
        };
    }

    protected class PredefinedValueAction
    extends DumbAwareAction {
        @NotNull
        protected final List<String> myValues;
        private final boolean myAddToRecent;
        final /* synthetic */ MultipleValueFilterPopupComponent this$0;

        public PredefinedValueAction(@NotNull MultipleValueFilterPopupComponent this$0, List<String> values) {
            if (values == null) {
                PredefinedValueAction.$$$reportNull$$$0(0);
            }
            this(this$0, values, null, true);
        }

        public PredefinedValueAction(@NotNull MultipleValueFilterPopupComponent this$0, @Nullable List<String> values, Supplier<String> displayName, boolean addToRecent) {
            if (values == null) {
                PredefinedValueAction.$$$reportNull$$$0(1);
            }
            this.this$0 = this$0;
            super(null, this$0.getTooltip(values), null);
            this.getTemplatePresentation().setText(displayName != null ? displayName : () -> this.this$0.getActionName(values), false);
            this.myValues = values;
            this.myAddToRecent = addToRecent;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                PredefinedValueAction.$$$reportNull$$$0(2);
            }
            this.this$0.myFilterModel.setFilter(this.this$0.createFilter(this.myValues));
            if (this.myAddToRecent) {
                this.this$0.rememberValuesInSettings(this.myValues);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent$PredefinedValueAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SelectMultipleValuesAction
    extends DumbAwareAction {
        @NotNull
        private final Collection<String> myVariants;

        SelectMultipleValuesAction() {
            super(VcsLogBundle.messagePointer("vcs.log.filter.action.select", new Object[0]));
            this.myVariants = MultipleValueFilterPopupComponent.this.getAllValues();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                SelectMultipleValuesAction.$$$reportNull$$$0(0);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            Object filter = MultipleValueFilterPopupComponent.this.myFilterModel.getFilter();
            List<String> values = filter == null ? Collections.emptyList() : MultipleValueFilterPopupComponent.this.getLocalizedValues(MultipleValueFilterPopupComponent.this.getFilterValues(filter));
            final MultilinePopupBuilder popupBuilder = new MultilinePopupBuilder(project, this.myVariants, SelectMultipleValuesAction.getPopupText(values), MultipleValueFilterPopupComponent.this.getCompletionPrefixProvider());
            JBPopup popup = popupBuilder.createPopup();
            popup.addListener(new JBPopupListener(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event.isOk()) {
                        List<String> selectedValues = MultipleValueFilterPopupComponent.this.parseLocalizedValues(popupBuilder.getSelectedValues());
                        if (selectedValues.isEmpty()) {
                            MultipleValueFilterPopupComponent.this.myFilterModel.setFilter(null);
                        } else {
                            MultipleValueFilterPopupComponent.this.myFilterModel.setFilter(MultipleValueFilterPopupComponent.this.createFilter(selectedValues));
                            MultipleValueFilterPopupComponent.this.rememberValuesInSettings(selectedValues);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent$SelectMultipleValuesAction$1", "onClosed"));
                }
            });
            popup.showUnderneathOf((Component)((Object)MultipleValueFilterPopupComponent.this));
        }

        @NotNull
        private static String getPopupText(@Nullable Collection<String> selectedValues) {
            String string = selectedValues == null || selectedValues.isEmpty() ? "" : StringUtil.join(selectedValues, (String)"\n");
            if (string == null) {
                SelectMultipleValuesAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent$SelectMultipleValuesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent$SelectMultipleValuesAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPopupText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

