/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.editor;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManagerKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.impl.CannotAddVcsLogWindowException;
import com.intellij.vcs.log.impl.VcsLogEditorUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabLocation;
import com.intellij.vcs.log.impl.VcsLogTabsManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.editor.VcsLogEditorTabNameCache;
import com.intellij.vcs.log.ui.editor.VcsLogFile;
import com.intellij.vcs.log.ui.editor.VcsLogVirtualFileSystem;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\fH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\fH\u0016J\b\u0010\u001e\u001a\u00020\fH\u0016J\u0013\u0010\u001f\u001a\u00020\u001c2\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR$\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f8@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lcom/intellij/vcs/log/ui/editor/DefaultVcsLogFile;", "Lcom/intellij/vcs/log/ui/editor/VcsLogFile;", "Lcom/intellij/openapi/vfs/VirtualFilePathWrapper;", "pathId", "Lcom/intellij/vcs/log/ui/editor/VcsLogVirtualFileSystem$VcsLogComplexPath;", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "<init>", "(Lcom/intellij/vcs/log/ui/editor/VcsLogVirtualFileSystem$VcsLogComplexPath;Lcom/intellij/vcs/log/VcsLogFilterCollection;)V", "fileSystemInstance", "Lcom/intellij/vcs/log/ui/editor/VcsLogVirtualFileSystem;", "tabId", "", "getTabId$intellij_platform_vcs_log_impl", "()Ljava/lang/String;", "value", "tabName", "getTabName$intellij_platform_vcs_log_impl", "setTabName$intellij_platform_vcs_log_impl", "(Ljava/lang/String;)V", "createMainComponent", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "getFileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "getPath", "enforcePresentableName", "", "getPresentableName", "getPresentablePath", "equals", "other", "", "hashCode", "", "Companion", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nDefaultVcsLogFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultVcsLogFile.kt\ncom/intellij/vcs/log/ui/editor/DefaultVcsLogFile\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,129:1\n40#2,3:130\n40#2,3:133\n14#3:136\n*S KotlinDebug\n*F\n+ 1 DefaultVcsLogFile.kt\ncom/intellij/vcs/log/ui/editor/DefaultVcsLogFile\n*L\n33#1:130,3\n34#1:133,3\n88#1:136\n*E\n"})
public final class DefaultVcsLogFile
extends VcsLogFile
implements VirtualFilePathWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VcsLogVirtualFileSystem.VcsLogComplexPath pathId;
    @Nullable
    private VcsLogFilterCollection filters;
    @NotNull
    private final VcsLogVirtualFileSystem fileSystemInstance;
    @NotNull
    private static final Logger LOG;

    public DefaultVcsLogFile(@NotNull VcsLogVirtualFileSystem.VcsLogComplexPath pathId, @Nullable VcsLogFilterCollection filters) {
        Intrinsics.checkNotNullParameter((Object)pathId, (String)"pathId");
        super(VcsLogTabsManager.Companion.getFullName(pathId.getLogId()));
        this.pathId = pathId;
        this.filters = filters;
        this.fileSystemInstance = VcsLogVirtualFileSystem.Holder.getInstance();
        this.putUserData(FileEditorManagerKeys.FORBID_TAB_SPLIT, true);
    }

    public /* synthetic */ DefaultVcsLogFile(VcsLogVirtualFileSystem.VcsLogComplexPath vcsLogComplexPath, VcsLogFilterCollection vcsLogFilterCollection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            vcsLogFilterCollection = null;
        }
        this(vcsLogComplexPath, vcsLogFilterCollection);
    }

    @NotNull
    public final String getTabId$intellij_platform_vcs_log_impl() {
        return this.pathId.getLogId();
    }

    @NotNull
    public final String getTabName$intellij_platform_vcs_log_impl() {
        boolean $i$f$service = false;
        Class<VcsLogEditorTabNameCache> serviceClass$iv = VcsLogEditorTabNameCache.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        String string = ((VcsLogEditorTabNameCache)((Object)object)).getTabName(this.getPath());
        if (string == null) {
            String string2 = this.getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        }
        return string;
    }

    public final void setTabName$intellij_platform_vcs_log_impl(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean $i$f$service = false;
        Class<VcsLogEditorTabNameCache> serviceClass$iv = VcsLogEditorTabNameCache.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((VcsLogEditorTabNameCache)((Object)object)).putTabName(this.getPath(), value);
    }

    @Override
    @NotNull
    public JComponent createMainComponent(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JBPanelWithEmptyText jBPanelWithEmptyText = new JBPanelWithEmptyText((LayoutManager)new BorderLayout()).withEmptyText(VcsLogBundle.message("vcs.log.is.loading", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)jBPanelWithEmptyText, (String)"withEmptyText(...)");
        JBPanelWithEmptyText panel = jBPanelWithEmptyText;
        VcsLogUtil.runWhenVcsAndLogIsReady(project, (Consumer<? super VcsLogManager>)((Consumer)arg_0 -> DefaultVcsLogFile.createMainComponent$lambda$2(arg_0 -> DefaultVcsLogFile.createMainComponent$lambda$1(project, this, panel, arg_0), arg_0)));
        return (JComponent)panel;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        return (VirtualFileSystem)this.fileSystemInstance;
    }

    @NotNull
    public String getPath() {
        return this.fileSystemInstance.getPath(this.pathId);
    }

    public boolean enforcePresentableName() {
        return true;
    }

    @NotNull
    public String getPresentableName() {
        return this.getTabName$intellij_platform_vcs_log_impl();
    }

    @NotNull
    public String getPresentablePath() {
        return this.getTabName$intellij_platform_vcs_log_impl();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.vcs.log.ui.editor.DefaultVcsLogFile");
        DefaultVcsLogFile cfr_ignored_0 = (DefaultVcsLogFile)((Object)other);
        return Intrinsics.areEqual((Object)this.getTabId$intellij_platform_vcs_log_impl(), (Object)((DefaultVcsLogFile)((Object)other)).getTabId$intellij_platform_vcs_log_impl());
    }

    public int hashCode() {
        return this.getTabId$intellij_platform_vcs_log_impl().hashCode();
    }

    private static final Unit createMainComponent$lambda$1$lambda$0(DefaultVcsLogFile this$0, MainVcsLogUi $ui, Project $project) {
        this$0.setTabName$intellij_platform_vcs_log_impl(VcsLogTabsManager.Companion.generateDisplayName($ui));
        VcsLogEditorUtil.INSTANCE.updateTabName$intellij_platform_vcs_log_impl($project, $ui);
        return Unit.INSTANCE;
    }

    private static final Unit createMainComponent$lambda$1(Project $project, DefaultVcsLogFile this$0, JBPanelWithEmptyText $panel, VcsLogManager logManager2) {
        VcsProjectLog projectLog = VcsProjectLog.Companion.getInstance($project);
        VcsLogTabsManager vcsLogTabsManager = projectLog.getTabManager();
        if (vcsLogTabsManager == null) {
            return Unit.INSTANCE;
        }
        VcsLogTabsManager tabsManager = vcsLogTabsManager;
        try {
            VcsLogManager.VcsLogUiFactory<MainVcsLogUi> factory = tabsManager.getPersistentVcsLogUiFactory(this$0.getTabId$intellij_platform_vcs_log_impl(), VcsLogTabLocation.EDITOR, this$0.filters);
            MainVcsLogUi mainVcsLogUi = logManager2.createLogUi(factory, VcsLogTabLocation.EDITOR);
            Intrinsics.checkNotNullExpressionValue((Object)mainVcsLogUi, (String)"createLogUi(...)");
            MainVcsLogUi ui = mainVcsLogUi;
            this$0.setTabName$intellij_platform_vcs_log_impl(VcsLogTabsManager.Companion.generateDisplayName(ui));
            VcsLogTabsManager.Companion.onDisplayNameChange(ui, (Function0<Unit>)((Function0)() -> DefaultVcsLogFile.createMainComponent$lambda$1$lambda$0(this$0, ui, $project)));
            if (this$0.filters != null) {
                this$0.filters = null;
            }
            Intrinsics.checkNotNull((Object)logManager2);
            $panel.add((Component)((Object)new VcsLogPanel(logManager2, ui)), (Object)"Center");
        }
        catch (CannotAddVcsLogWindowException e) {
            LOG.error((Throwable)e);
            $panel.getEmptyText().setText(VcsLogBundle.message("vcs.log.duplicated.tab.id.error", new Object[0]));
        }
        return Unit.INSTANCE;
    }

    private static final void createMainComponent$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DefaultVcsLogFile.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/vcs/log/ui/editor/DefaultVcsLogFile$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

