/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.AbstractList;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class IntIntMultiMap {
    private static final int[] EMPTY = new int[0];
    private final Int2ObjectMap<int[]> myKeyToArrayMap = new Int2ObjectOpenHashMap();

    public void putValue(int key, int value) {
        int[] newValues;
        int[] values = (int[])this.myKeyToArrayMap.get(key);
        if (values == null) {
            newValues = new int[]{value};
        } else {
            newValues = new int[values.length + 1];
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == value) {
                    return;
                }
                newValues[i] = values[i];
            }
            newValues[newValues.length - 1] = value;
        }
        this.myKeyToArrayMap.put(key, (Object)newValues);
    }

    public void remove(int key, int value) {
        int removeIndex = -1;
        int[] values = (int[])this.myKeyToArrayMap.get(key);
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != value) continue;
            removeIndex = i;
            break;
        }
        if (removeIndex == -1) {
            return;
        }
        if (values.length == 1) {
            this.myKeyToArrayMap.remove(key);
            return;
        }
        int[] newValues = new int[values.length - 1];
        for (int i = 0; i < newValues.length; ++i) {
            newValues[i] = i >= removeIndex ? values[i + 1] : values[i];
        }
        this.myKeyToArrayMap.put(key, (Object)newValues);
    }

    @NotNull
    public Collection<Integer> get(int key) {
        final int[] asArray = this.getAsArray(key);
        return new AbstractList<Integer>(){

            @Override
            @NotNull
            public Integer get(int index) {
                Integer n = asArray[index];
                if (n == null) {
                    1.$$$reportNull$$$0(0);
                }
                return n;
            }

            @Override
            public int size() {
                return asArray.length;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/IntIntMultiMap$1", "get"));
            }
        };
    }

    public int @NotNull [] getAsArray(int key) {
        int[] result = (int[])this.myKeyToArrayMap.get(key);
        if (result == null) {
            if (EMPTY == null) {
                IntIntMultiMap.$$$reportNull$$$0(0);
            }
            return EMPTY;
        }
        if (result == null) {
            IntIntMultiMap.$$$reportNull$$$0(1);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.myKeyToArrayMap.isEmpty();
    }

    public boolean containsKey(int key) {
        return this.myKeyToArrayMap.containsKey(key);
    }

    public int @NotNull [] keys() {
        int[] nArray = this.myKeyToArrayMap.keySet().toIntArray();
        if (nArray == null) {
            IntIntMultiMap.$$$reportNull$$$0(2);
        }
        return nArray;
    }

    public void clear() {
        this.myKeyToArrayMap.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/vcs/log/graph/utils/IntIntMultiMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsArray";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "keys";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

