/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogUserResolver;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\f\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0018\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00070\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00070\u00110\u0010H\u0004J.\u0010\u0019\u001a(\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00070\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00070\u0011\u0018\u00010\u0010H\u0004J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\u001d\u001a\u00020\u0006H\u0016R\u001e\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR8\u0010\u000e\u001a,\u0012(\u0012&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00070\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00070\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00070\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R \u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00070\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lcom/intellij/vcs/log/data/VcsLogUserResolverBase;", "Lcom/intellij/vcs/log/data/VcsLogUserResolver;", "<init>", "()V", "currentUsers", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsUser;", "getCurrentUsers", "()Ljava/util/Map;", "allUsers", "", "getAllUsers", "()Ljava/util/Set;", "cachedUsers", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "Lkotlin/Pair;", "Lcom/intellij/util/containers/MultiMap;", "", "allUsersByNames", "getAllUsersByNames", "()Lcom/intellij/util/containers/MultiMap;", "allUsersByEmails", "getAllUsersByEmails", "buildCache", "clearCache", "resolveUserName", "name", "resolveCurrentUser", "root", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nVcsLogUserResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogUserResolver.kt\ncom/intellij/vcs/log/data/VcsLogUserResolverBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1557#2:69\n1628#2,3:70\n774#2:73\n865#2,2:74\n*S KotlinDebug\n*F\n+ 1 VcsLogUserResolver.kt\ncom/intellij/vcs/log/data/VcsLogUserResolverBase\n*L\n58#1:69\n58#1:70,3\n59#1:73\n59#1:74,2\n*E\n"})
public abstract class VcsLogUserResolverBase
implements VcsLogUserResolver {
    @NotNull
    private final SynchronizedClearableLazy<Pair<MultiMap<String, VcsUser>, MultiMap<String, VcsUser>>> cachedUsers = new SynchronizedClearableLazy(() -> VcsLogUserResolverBase.cachedUsers$lambda$0(this));

    @NotNull
    public abstract Map<VirtualFile, VcsUser> getCurrentUsers();

    @NotNull
    public abstract Set<VcsUser> getAllUsers();

    private final MultiMap<String, VcsUser> getAllUsersByNames() {
        return (MultiMap)((Pair)this.cachedUsers.getValue()).getFirst();
    }

    private final MultiMap<String, VcsUser> getAllUsersByEmails() {
        return (MultiMap)((Pair)this.cachedUsers.getValue()).getSecond();
    }

    @NotNull
    protected final Pair<MultiMap<String, VcsUser>, MultiMap<String, VcsUser>> buildCache() {
        return (Pair)this.cachedUsers.getValue();
    }

    @Nullable
    protected final Pair<MultiMap<String, VcsUser>, MultiMap<String, VcsUser>> clearCache() {
        return (Pair)this.cachedUsers.drop();
    }

    @Override
    @NotNull
    public Set<VcsUser> resolveUserName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = VcsUserUtil.getNameInStandardForm((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameInStandardForm(...)");
        String standardName = string;
        Collection collection = this.getAllUsersByNames().get((Object)standardName);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        Iterable iterable = collection;
        Collection collection2 = this.getAllUsersByEmails().get((Object)standardName);
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"get(...)");
        return CollectionsKt.union((Iterable)iterable, (Iterable)collection2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<VcsUser> resolveCurrentUser(@NotNull VirtualFile root) {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        VcsUser vcsUser = this.getCurrentUsers().get(root);
        if (vcsUser == null) {
            return SetsKt.emptySet();
        }
        String string = vcsUser.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Set<VcsUser> usersByName = this.resolveUserName(string);
        String string2 = VcsUserUtil.getNameFromEmail((String)vcsUser.getEmail());
        if (string2 == null) {
            return usersByName;
        }
        String emailNamePart = string2;
        Iterable $this$map$iv = usersByName;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void user;
            VcsUser vcsUser2 = (VcsUser)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(VcsUserUtil.emailToLowerCase((String)user.getEmail()));
        }
        Set emails = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$filter$iv = this.resolveUserName(emailNamePart);
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VcsUser candidateUser = (VcsUser)element$iv$iv;
            boolean bl = false;
            if (!emails.contains(VcsUserUtil.emailToLowerCase((String)candidateUser.getEmail()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List usersByEmail = (List)destination$iv$iv2;
        return SetsKt.plus(usersByName, (Iterable)usersByEmail);
    }

    private static final Pair cachedUsers$lambda$0(VcsLogUserResolverBase this$0) {
        MultiMap multiMap = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"create(...)");
        MultiMap usersByNames = multiMap;
        MultiMap multiMap2 = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap2, (String)"create(...)");
        MultiMap usersByEmails = multiMap2;
        for (VcsUser user : this$0.getAllUsers()) {
            String email;
            String name;
            Intrinsics.checkNotNullExpressionValue((Object)user.getName(), (String)"getName(...)");
            if (((CharSequence)name).length() > 0) {
                usersByNames.putValue((Object)VcsUserUtil.getNameInStandardForm((String)name), (Object)user);
            }
            Intrinsics.checkNotNullExpressionValue((Object)user.getEmail(), (String)"getEmail(...)");
            String nameFromEmail = VcsUserUtil.getNameFromEmail((String)email);
            if (nameFromEmail == null) continue;
            usersByEmails.putValue((Object)VcsUserUtil.getNameInStandardForm((String)nameFromEmail), (Object)user);
        }
        return new Pair((Object)usersByNames, (Object)usersByEmails);
    }
}

