/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.repo.GitBranchState;
import git4idea.repo.GitHooksInfo;
import git4idea.repo.GitRefUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepositoryFiles;
import git4idea.util.StringScanner;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 12\u00020\u0001:\u0004./01B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0018H\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u001f\u001a\u00020\u0018H\u0002J\b\u0010 \u001a\u00020\u0018H\u0002J\b\u0010!\u001a\u00020\u0018H\u0002J\b\u0010\"\u001a\u00020\u0018H\u0002J\u0014\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020%0$H\u0002J\u0016\u0010&\u001a\u00020\u00142\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0014\u0010'\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020%0$H\u0002J\"\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00100)2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\n\u0010*\u001a\u0004\u0018\u00010\u001cH\u0002J\n\u0010+\u001a\u0004\u0018\u00010,H\u0002J\n\u0010-\u001a\u0004\u0018\u00010\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lgit4idea/repo/GitRepositoryReader;", "", "project", "Lcom/intellij/openapi/project/Project;", "gitFiles", "Lgit4idea/repo/GitRepositoryFiles;", "<init>", "(Lcom/intellij/openapi/project/Project;Lgit4idea/repo/GitRepositoryFiles;)V", "readState", "Lgit4idea/repo/GitBranchState;", "remotes", "", "Lgit4idea/repo/GitRemote;", "parseHeadState", "Lgit4idea/repo/GitRepositoryReader$GitHeadState;", "headInfo", "Lgit4idea/repo/GitRepositoryReader$HeadInfo;", "state", "Lcom/intellij/dvcs/repo/Repository$State;", "branches", "Lgit4idea/repo/GitRepositoryReader$GitBranches;", "readHooksInfo", "Lgit4idea/repo/GitHooksInfo;", "hasShallowCommits", "", "readRepositoryState", "isOnBranch", "findRebaseBranch", "Lgit4idea/GitLocalBranch;", "fixCurrentBranchCase", "currentBranch", "isMergeInProgress", "isRebaseInProgress", "isCherryPickInProgress", "isRevertInProgress", "readPackedBranches", "", "", "readBranches", "readBranchRefsFromFiles", "readBranchesFromGit", "Lkotlin/Pair;", "resolveCurrentBranch", "resolveHeadRevision", "Lcom/intellij/vcs/log/Hash;", "readHead", "HeadInfo", "GitBranches", "GitHeadState", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitRepositoryReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRepositoryReader.kt\ngit4idea/repo/GitRepositoryReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,407:1\n1#2:408\n*E\n"})
public final class GitRepositoryReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final GitRepositoryFiles gitFiles;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String DETACHED_HEAD = "detached HEAD";

    public GitRepositoryReader(@NotNull Project project, @NotNull GitRepositoryFiles gitFiles) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)gitFiles, (String)"gitFiles");
        this.project = project;
        this.gitFiles = gitFiles;
    }

    @NotNull
    public final GitBranchState readState(@NotNull Collection<GitRemote> remotes) {
        Intrinsics.checkNotNullParameter(remotes, (String)"remotes");
        HeadInfo headInfo = this.readHead();
        GitBranches branches = null;
        if (headInfo != null && Registry.Companion.is("git.read.branches.from.disk")) {
            branches = this.readBranches(remotes);
        } else {
            Pair<GitBranches, HeadInfo> pair = this.readBranchesFromGit(remotes);
            branches = (GitBranches)pair.getFirst();
            headInfo = (HeadInfo)pair.getSecond();
            if (headInfo instanceof HeadInfo.Unknown) {
                Hash headHash = this.resolveHeadRevision();
                if (headHash != null) {
                    headInfo = new HeadInfo.DetachedHead(headHash);
                } else {
                    LOG.warn((Throwable)new RepoStateException("Unknown repository state in " + this.gitFiles.getRootDir()));
                }
            }
        }
        Repository.State state2 = this.readRepositoryState(headInfo instanceof HeadInfo.Branch);
        GitHeadState headState = this.parseHeadState(headInfo, state2, branches);
        return new GitBranchState(headState.getCurrentRevision(), headState.getCurrentBranch(), state2, branches.getLocalBranches(), branches.getRemoteBranches());
    }

    private final GitHeadState parseHeadState(HeadInfo headInfo, Repository.State state2, GitBranches branches) {
        GitLocalBranch currentBranch;
        if (headInfo instanceof HeadInfo.Branch) {
            Hash currentBranchHash;
            GitLocalBranch currentBranch2 = this.fixCurrentBranchCase(((HeadInfo.Branch)headInfo).getBranch(), branches);
            Hash hash = currentBranchHash = currentBranch2 != null ? branches.getLocalBranches().get(currentBranch2) : null;
            String currentRevision = hash != null ? hash.asString() : null;
            return new GitHeadState(currentBranch2, currentRevision);
        }
        GitLocalBranch gitLocalBranch = currentBranch = state2 == Repository.State.REBASING ? this.fixCurrentBranchCase(this.findRebaseBranch(), branches) : null;
        if (headInfo instanceof HeadInfo.DetachedHead) {
            String string = ((HeadInfo.DetachedHead)headInfo).getHash().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String currentRevision = string;
            return new GitHeadState(currentBranch, currentRevision);
        }
        if (currentBranch == null) {
            LOG.warn("Couldn't identify neither current branch nor current revision.");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dumping files in .git/refs/, and the content of .git/packed-refs.");
                GitRefUtil.logDebugAllRefsFiles(this.gitFiles);
            }
        }
        return new GitHeadState(currentBranch, null);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final GitHooksInfo readHooksInfo() {
        v0 = this.gitFiles.getPreCommitHookFile();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getPreCommitHookFile(...)");
        if (git4idea.repo.GitRepositoryReader$Companion.access$isExistingExecutableFile(GitRepositoryReader.Companion, v0)) ** GOTO lbl-1000
        v1 = this.gitFiles.getCommitMsgHookFile();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getCommitMsgHookFile(...)");
        if (git4idea.repo.GitRepositoryReader$Companion.access$isExistingExecutableFile(GitRepositoryReader.Companion, v1)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        hasCommitHook = v2;
        v3 = this.gitFiles.getPrePushHookFile();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getPrePushHookFile(...)");
        hasPushHook = git4idea.repo.GitRepositoryReader$Companion.access$isExistingExecutableFile(GitRepositoryReader.Companion, v3);
        return new GitHooksInfo(hasCommitHook, hasPushHook);
    }

    public final boolean hasShallowCommits() {
        File file = this.gitFiles.getShallowFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getShallowFile(...)");
        File shallowFile = file;
        if (!shallowFile.exists()) {
            return false;
        }
        return shallowFile.length() > 0L;
    }

    private final Repository.State readRepositoryState(boolean isOnBranch) {
        if (this.isMergeInProgress()) {
            return Repository.State.MERGING;
        }
        if (this.isRebaseInProgress()) {
            return Repository.State.REBASING;
        }
        if (!isOnBranch) {
            return Repository.State.DETACHED;
        }
        if (this.isCherryPickInProgress()) {
            return Repository.State.GRAFTING;
        }
        if (this.isRevertInProgress()) {
            return Repository.State.REVERTING;
        }
        return Repository.State.NORMAL;
    }

    private final GitLocalBranch findRebaseBranch() {
        String currentBranch;
        File file = this.gitFiles.getRebaseApplyDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getRebaseApplyDir(...)");
        String string = GitRepositoryReader.Companion.readRebaseDirBranchFile(file);
        if (string == null) {
            File file2 = this.gitFiles.getRebaseMergeDir();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getRebaseMergeDir(...)");
            string = GitRepositoryReader.Companion.readRebaseDirBranchFile(file2);
        }
        if ((currentBranch = string) != null && !Intrinsics.areEqual((Object)currentBranch, (Object)DETACHED_HEAD)) {
            return new GitLocalBranch(currentBranch);
        }
        return null;
    }

    private final GitLocalBranch fixCurrentBranchCase(GitLocalBranch currentBranch, GitBranches branches) {
        GitLocalBranch gitLocalBranch;
        Object v0;
        block3: {
            if (currentBranch == null) {
                return null;
            }
            Iterable iterable = branches.getLocalBranches().keySet();
            for (Object t : iterable) {
                GitLocalBranch branch = (GitLocalBranch)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)branch, (Object)currentBranch)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        if ((gitLocalBranch = (GitLocalBranch)v0) == null) {
            gitLocalBranch = currentBranch;
        }
        return gitLocalBranch;
    }

    private final boolean isMergeInProgress() {
        return this.gitFiles.getMergeHeadFile().exists();
    }

    private final boolean isRebaseInProgress() {
        return this.gitFiles.getRebaseApplyDir().exists() || this.gitFiles.getRebaseMergeDir().exists();
    }

    private final boolean isCherryPickInProgress() {
        return this.gitFiles.getCherryPickHead().exists();
    }

    private final boolean isRevertInProgress() {
        return this.gitFiles.getRevertHead().exists();
    }

    private final Map<String, String> readPackedBranches() {
        File file = this.gitFiles.getPackedRefsPath();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getPackedRefsPath(...)");
        File packedRefsFile = file;
        if (!packedRefsFile.exists()) {
            return MapsKt.emptyMap();
        }
        try {
            String string = DvcsUtil.tryLoadFile((File)packedRefsFile, (String)"UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tryLoadFile(...)");
            String content = string;
            Map result2 = new LinkedHashMap();
            for (String line : LineTokenizer.tokenize((CharSequence)content, (boolean)false)) {
                com.intellij.openapi.util.Pair<String, String> pair;
                if (GitRefUtil.parseBranchesLine(line) == null) continue;
                result2.put(pair.first, pair.second);
            }
            return result2;
        }
        catch (RepoStateException repoStateException) {
            return MapsKt.emptyMap();
        }
    }

    private final GitBranches readBranches(Collection<GitRemote> remotes) {
        Map<String, String> data2 = this.readBranchRefsFromFiles();
        Map<String, Hash> map2 = GitRefUtil.resolveRefs(data2);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"resolveRefs(...)");
        Map<String, Hash> resolvedRefs = map2;
        return GitRepositoryReader.Companion.createBranchesFromData(remotes, resolvedRefs);
    }

    private final Map<String, String> readBranchRefsFromFiles() {
        try {
            Map result2 = new HashMap<String, String>(this.readPackedBranches());
            Map<String, String> map2 = GitRefUtil.readFromRefsFiles(this.gitFiles.getRefsHeadsFile(), "refs/heads/", this.gitFiles);
            Intrinsics.checkNotNullExpressionValue(map2, (String)"readFromRefsFiles(...)");
            result2.putAll(map2);
            Map<String, String> map3 = GitRefUtil.readFromRefsFiles(this.gitFiles.getRefsRemotesFile(), "refs/remotes/", this.gitFiles);
            Intrinsics.checkNotNullExpressionValue(map3, (String)"readFromRefsFiles(...)");
            result2.putAll(map3);
            return result2;
        }
        catch (Throwable e) {
            GitRefUtil.logDebugAllRefsFiles(this.gitFiles);
            LOG.warn("Error reading refs from files", e);
            return MapsKt.emptyMap();
        }
    }

    private final Pair<GitBranches, HeadInfo> readBranchesFromGit(Collection<GitRemote> remotes) {
        try {
            GitLocalBranch currentBranch;
            GitLineHandler handler = new GitLineHandler(this.project, this.gitFiles.getRootDir(), GitCommand.FOR_EACH_REF);
            handler.setEnableInteractiveCallbacks(false);
            String[] stringArray = new String[]{"refs/heads/**", "refs/remotes/**"};
            handler.addParameters(stringArray);
            stringArray = new String[]{"--no-color"};
            handler.addParameters(stringArray);
            stringArray = new String[]{"--format=%(refname)\t%(objectname)\t%(HEAD)"};
            handler.addParameters(stringArray);
            Map resolvedRefs = new LinkedHashMap();
            Ref.ObjectRef headStateRef = new Ref.ObjectRef();
            handler.addLineListener(new GitLineHandlerListener((Ref.ObjectRef<HeadInfo>)headStateRef, resolvedRefs){
                private int badLineReported;
                final /* synthetic */ Ref.ObjectRef<HeadInfo> $headStateRef;
                final /* synthetic */ Map<String, Hash> $resolvedRefs;
                {
                    this.$headStateRef = $headStateRef;
                    this.$resolvedRefs = $resolvedRefs;
                }

                public void onLineAvailable(String line, Key<?> outputType) {
                    block6: {
                        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                        try {
                            if (Intrinsics.areEqual(outputType, (Object)ProcessOutputType.STDOUT)) {
                                StringScanner scanner = new StringScanner(line);
                                String string = scanner.tabToken();
                                if (string == null) {
                                    return;
                                }
                                String branchRef = string;
                                Hash hash = GitRefUtil.parseHash(scanner.tabToken());
                                if (hash == null) {
                                    return;
                                }
                                Hash branchHash = hash;
                                boolean isHead = Intrinsics.areEqual((Object)"*", (Object)scanner.line());
                                if (isHead) {
                                    this.$headStateRef.element = new HeadInfo.Branch(new GitLocalBranch(branchRef));
                                }
                                this.$resolvedRefs.put(branchRef, branchHash);
                            }
                        }
                        catch (VcsException e) {
                            int n = this.badLineReported;
                            this.badLineReported = n + 1;
                            if (this.badLineReported >= 5) break block6;
                            GitRepositoryReader.access$getLOG$cp().warn("Unexpected branch output: " + line, (Throwable)e);
                        }
                    }
                }
            });
            Git.getInstance().runCommand(handler).throwOnError(new int[0]);
            HeadInfo headState = (HeadInfo)headStateRef.element;
            GitBranches branches = GitRepositoryReader.Companion.createBranchesFromData(remotes, resolvedRefs);
            if (headState != null) {
                return new Pair((Object)branches, (Object)headState);
            }
            if (branches.getLocalBranches().isEmpty() && (currentBranch = this.resolveCurrentBranch()) != null) {
                return new Pair((Object)new GitBranches(MapsKt.emptyMap(), branches.getRemoteBranches()), (Object)new HeadInfo.Branch(currentBranch));
            }
            return new Pair((Object)branches, (Object)HeadInfo.Unknown.INSTANCE);
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return new Pair((Object)new GitBranches(MapsKt.emptyMap(), MapsKt.emptyMap()), (Object)HeadInfo.Unknown.INSTANCE);
        }
    }

    private final GitLocalBranch resolveCurrentBranch() {
        try {
            GitLineHandler handler = new GitLineHandler(this.project, this.gitFiles.getRootDir(), GitCommand.BRANCH);
            handler.setEnableInteractiveCallbacks(false);
            String[] stringArray = new String[]{"--show-current"};
            handler.addParameters(stringArray);
            stringArray = new String[]{"--no-color"};
            handler.addParameters(stringArray);
            String string = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOutputOrThrow(...)");
            String output = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (((CharSequence)output).length() == 0) {
                return null;
            }
            return new GitLocalBranch(output);
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    private final Hash resolveHeadRevision() {
        try {
            GitLineHandler handler = new GitLineHandler(this.project, this.gitFiles.getRootDir(), GitCommand.REV_PARSE);
            handler.setEnableInteractiveCallbacks(false);
            String[] stringArray = new String[]{"--verify"};
            handler.addParameters(stringArray);
            stringArray = new String[]{"HEAD^{commit}"};
            handler.addParameters(stringArray);
            String string = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOutputOrThrow(...)");
            String output = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (GitUtil.isHashString(output)) {
                return HashImpl.build((String)output);
            }
            return null;
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    private final HeadInfo readHead() {
        String headContent = null;
        try {
            headContent = DvcsUtil.tryLoadFile((File)this.gitFiles.getHeadFile(), (String)"UTF-8");
        }
        catch (RepoStateException e) {
            LOG.warn((Throwable)e);
            return HeadInfo.Unknown.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)headContent, (Object)"ref: refs/heads/.invalid")) {
            return null;
        }
        Hash hash = GitRefUtil.parseHash(headContent);
        if (hash != null) {
            return new HeadInfo.DetachedHead(hash);
        }
        String target = GitRefUtil.getTarget(headContent);
        if (target != null) {
            return new HeadInfo.Branch(new GitLocalBranch(target));
        }
        LOG.warn((Throwable)new RepoStateException("Invalid format of the .git/HEAD file: [" + headContent + "]"));
        return HeadInfo.Unknown.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(GitRepositoryReader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0017\u0010\r\u001a\u0004\u0018\u00010\b2\u000b\u0010\u000e\u001a\u00070\f\u00a2\u0006\u0002\b\u000fH\u0002J*\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u001e\u0010\u0018\u001a\u0004\u0018\u00010\u00192\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u001a\u001a\u00020\bR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lgit4idea/repo/GitRepositoryReader$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "DETACHED_HEAD", "", "isExistingExecutableFile", "", "file", "Ljava/io/File;", "readRebaseDirBranchFile", "rebaseDir", "Lorg/jetbrains/annotations/NonNls;", "createBranchesFromData", "Lgit4idea/repo/GitRepositoryReader$GitBranches;", "remotes", "", "Lgit4idea/repo/GitRemote;", "data", "", "Lcom/intellij/vcs/log/Hash;", "parseBranchRef", "Lgit4idea/GitBranch;", "refName", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isExistingExecutableFile(File file) {
            return file.exists() && file.canExecute();
        }

        private final String readRebaseDirBranchFile(File rebaseDir) {
            File headName;
            if (rebaseDir.exists() && (headName = new File(rebaseDir, "head-name")).exists()) {
                return DvcsUtil.tryLoadFileOrReturn((File)headName, null, (String)"UTF-8");
            }
            return null;
        }

        private final GitBranches createBranchesFromData(Collection<GitRemote> remotes, Map<String, ? extends Hash> data2) {
            Map localBranches2 = new HashMap();
            Map remoteBranches2 = new HashMap();
            for (Map.Entry<String, ? extends Hash> entry : data2.entrySet()) {
                Hash hash;
                String refName = entry.getKey();
                Hash hash2 = entry.getValue();
                GitBranch branch = this.parseBranchRef(remotes, refName);
                if (branch instanceof GitLocalBranch) {
                    hash = localBranches2.put(branch, hash2);
                    continue;
                }
                if (branch instanceof GitRemoteBranch) {
                    if (Intrinsics.areEqual((Object)((GitRemoteBranch)branch).getName(), (Object)"origin/HEAD")) continue;
                    hash = remoteBranches2.put(branch, hash2);
                    continue;
                }
                Logger logger = LOG;
                String string = "Unexpected ref format: %s, %s";
                Object[] objectArray = new Object[]{refName, branch};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                logger.warn(string2);
                hash = Unit.INSTANCE;
            }
            return new GitBranches(localBranches2, remoteBranches2);
        }

        @Nullable
        public final GitBranch parseBranchRef(@NotNull Collection<GitRemote> remotes, @NotNull String refName) {
            Intrinsics.checkNotNullParameter(remotes, (String)"remotes");
            Intrinsics.checkNotNullParameter((Object)refName, (String)"refName");
            if (StringsKt.startsWith$default((String)refName, (String)"refs/heads/", (boolean)false, (int)2, null)) {
                return new GitLocalBranch(refName);
            }
            if (StringsKt.startsWith$default((String)refName, (String)"refs/remotes/", (boolean)false, (int)2, null)) {
                return GitUtil.parseRemoteBranch(refName, remotes);
            }
            return null;
        }

        public static final /* synthetic */ boolean access$isExistingExecutableFile(Companion $this, File file) {
            return $this.isExistingExecutableFile(file);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\b\u0010\tR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\r"}, d2={"Lgit4idea/repo/GitRepositoryReader$GitBranches;", "", "localBranches", "", "Lgit4idea/GitLocalBranch;", "Lcom/intellij/vcs/log/Hash;", "remoteBranches", "Lgit4idea/GitRemoteBranch;", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "getLocalBranches", "()Ljava/util/Map;", "getRemoteBranches", "intellij.vcs.git"})
    private static final class GitBranches {
        @NotNull
        private final Map<GitLocalBranch, Hash> localBranches;
        @NotNull
        private final Map<GitRemoteBranch, Hash> remoteBranches;

        public GitBranches(@NotNull Map<GitLocalBranch, ? extends Hash> localBranches2, @NotNull Map<GitRemoteBranch, ? extends Hash> remoteBranches2) {
            Intrinsics.checkNotNullParameter(localBranches2, (String)"localBranches");
            Intrinsics.checkNotNullParameter(remoteBranches2, (String)"remoteBranches");
            this.localBranches = localBranches2;
            this.remoteBranches = remoteBranches2;
        }

        @NotNull
        public final Map<GitLocalBranch, Hash> getLocalBranches() {
            return this.localBranches;
        }

        @NotNull
        public final Map<GitRemoteBranch, Hash> getRemoteBranches() {
            return this.remoteBranches;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lgit4idea/repo/GitRepositoryReader$GitHeadState;", "", "currentBranch", "Lgit4idea/GitLocalBranch;", "currentRevision", "", "<init>", "(Lgit4idea/GitLocalBranch;Ljava/lang/String;)V", "getCurrentBranch", "()Lgit4idea/GitLocalBranch;", "getCurrentRevision", "()Ljava/lang/String;", "intellij.vcs.git"})
    private static final class GitHeadState {
        @Nullable
        private final GitLocalBranch currentBranch;
        @Nullable
        private final String currentRevision;

        public GitHeadState(@Nullable GitLocalBranch currentBranch, @Nullable String currentRevision) {
            this.currentBranch = currentBranch;
            this.currentRevision = currentRevision;
        }

        @Nullable
        public final GitLocalBranch getCurrentBranch() {
            return this.currentBranch;
        }

        @Nullable
        public final String getCurrentRevision() {
            return this.currentRevision;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lgit4idea/repo/GitRepositoryReader$HeadInfo;", "", "<init>", "()V", "Unknown", "Branch", "DetachedHead", "Lgit4idea/repo/GitRepositoryReader$HeadInfo$Branch;", "Lgit4idea/repo/GitRepositoryReader$HeadInfo$DetachedHead;", "Lgit4idea/repo/GitRepositoryReader$HeadInfo$Unknown;", "intellij.vcs.git"})
    private static abstract class HeadInfo {
        private HeadInfo() {
        }

        public /* synthetic */ HeadInfo(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lgit4idea/repo/GitRepositoryReader$HeadInfo$Branch;", "Lgit4idea/repo/GitRepositoryReader$HeadInfo;", "branch", "Lgit4idea/GitLocalBranch;", "<init>", "(Lgit4idea/GitLocalBranch;)V", "getBranch", "()Lgit4idea/GitLocalBranch;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.vcs.git"})
        public static final class Branch
        extends HeadInfo {
            @NotNull
            private final GitLocalBranch branch;

            public Branch(@NotNull GitLocalBranch branch) {
                Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
                super(null);
                this.branch = branch;
            }

            @NotNull
            public final GitLocalBranch getBranch() {
                return this.branch;
            }

            @NotNull
            public final GitLocalBranch component1() {
                return this.branch;
            }

            @NotNull
            public final Branch copy(@NotNull GitLocalBranch branch) {
                Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
                return new Branch(branch);
            }

            public static /* synthetic */ Branch copy$default(Branch branch, GitLocalBranch gitLocalBranch, int n, Object object) {
                if ((n & 1) != 0) {
                    gitLocalBranch = branch.branch;
                }
                return branch.copy(gitLocalBranch);
            }

            @NotNull
            public String toString() {
                return "Branch(branch=" + this.branch + ")";
            }

            public int hashCode() {
                return this.branch.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Branch)) {
                    return false;
                }
                Branch branch = (Branch)other;
                return Intrinsics.areEqual((Object)this.branch, (Object)branch.branch);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lgit4idea/repo/GitRepositoryReader$HeadInfo$DetachedHead;", "Lgit4idea/repo/GitRepositoryReader$HeadInfo;", "hash", "Lcom/intellij/vcs/log/Hash;", "<init>", "(Lcom/intellij/vcs/log/Hash;)V", "getHash", "()Lcom/intellij/vcs/log/Hash;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.vcs.git"})
        public static final class DetachedHead
        extends HeadInfo {
            @NotNull
            private final Hash hash;

            public DetachedHead(@NotNull Hash hash) {
                Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
                super(null);
                this.hash = hash;
            }

            @NotNull
            public final Hash getHash() {
                return this.hash;
            }

            @NotNull
            public final Hash component1() {
                return this.hash;
            }

            @NotNull
            public final DetachedHead copy(@NotNull Hash hash) {
                Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
                return new DetachedHead(hash);
            }

            public static /* synthetic */ DetachedHead copy$default(DetachedHead detachedHead, Hash hash, int n, Object object) {
                if ((n & 1) != 0) {
                    hash = detachedHead.hash;
                }
                return detachedHead.copy(hash);
            }

            @NotNull
            public String toString() {
                return "DetachedHead(hash=" + this.hash + ")";
            }

            public int hashCode() {
                return this.hash.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DetachedHead)) {
                    return false;
                }
                DetachedHead detachedHead = (DetachedHead)other;
                return Intrinsics.areEqual((Object)this.hash, (Object)detachedHead.hash);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lgit4idea/repo/GitRepositoryReader$HeadInfo$Unknown;", "Lgit4idea/repo/GitRepositoryReader$HeadInfo;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.vcs.git"})
        public static final class Unknown
        extends HeadInfo {
            @NotNull
            public static final Unknown INSTANCE = new Unknown();

            private Unknown() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Unknown";
            }

            public int hashCode() {
                return -1319394176;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Unknown)) {
                    return false;
                }
                Unknown cfr_ignored_0 = (Unknown)other;
                return true;
            }
        }
    }
}

