/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.PushSource;
import com.intellij.openapi.util.NlsSafe;
import git4idea.GitLocalBranch;
import git4idea.GitTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitPushSource
implements PushSource {
    @NotNull
    public static GitPushSource create(@NotNull GitLocalBranch branch) {
        if (branch == null) {
            GitPushSource.$$$reportNull$$$0(0);
        }
        return new OnBranch(branch);
    }

    @NotNull
    public static GitPushSource createRef(@NotNull GitLocalBranch branch, @NotNull String revision) {
        if (branch == null) {
            GitPushSource.$$$reportNull$$$0(1);
        }
        if (revision == null) {
            GitPushSource.$$$reportNull$$$0(2);
        }
        return new OnRevision(branch, revision);
    }

    @NotNull
    public static GitPushSource createDetached(@NotNull String revision) {
        if (revision == null) {
            GitPushSource.$$$reportNull$$$0(3);
        }
        return new DetachedHead(revision);
    }

    @NotNull
    public static GitPushSource createTag(@NotNull GitTag tag) {
        if (tag == null) {
            GitPushSource.$$$reportNull$$$0(4);
        }
        return new Tag(tag);
    }

    @Nullable
    public abstract GitLocalBranch getBranch();

    @NotNull
    public abstract String getRevision();

    public abstract boolean isBranchRef();

    public String toString() {
        return this.getPresentation();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        objectArray2[1] = "git4idea/push/GitPushSource";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createRef";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createDetached";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createTag";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class OnBranch
    extends GitPushSource {
        @NotNull
        private final GitLocalBranch myBranch;

        private OnBranch(@NotNull GitLocalBranch branch) {
            if (branch == null) {
                OnBranch.$$$reportNull$$$0(0);
            }
            this.myBranch = branch;
        }

        @NotNull
        public String getPresentation() {
            String string = this.myBranch.getName();
            if (string == null) {
                OnBranch.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public GitLocalBranch getBranch() {
            GitLocalBranch gitLocalBranch = this.myBranch;
            if (gitLocalBranch == null) {
                OnBranch.$$$reportNull$$$0(2);
            }
            return gitLocalBranch;
        }

        @Override
        @NotNull
        public String getRevision() {
            String string = this.myBranch.getFullName();
            if (string == null) {
                OnBranch.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public boolean isBranchRef() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branch";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/push/GitPushSource$OnBranch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/push/GitPushSource$OnBranch";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBranch";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevision";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    static final class OnRevision
    extends GitPushSource {
        @NotNull
        private final GitLocalBranch myBranch;
        @NlsSafe
        private final String myRevision;

        private OnRevision(@NotNull GitLocalBranch branch, @NotNull String revision) {
            if (branch == null) {
                OnRevision.$$$reportNull$$$0(0);
            }
            if (revision == null) {
                OnRevision.$$$reportNull$$$0(1);
            }
            this.myBranch = branch;
            this.myRevision = revision;
        }

        @NotNull
        public String getPresentation() {
            String string = DvcsUtil.getShortHash((String)this.myRevision);
            if (string == null) {
                OnRevision.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public GitLocalBranch getBranch() {
            GitLocalBranch gitLocalBranch = this.myBranch;
            if (gitLocalBranch == null) {
                OnRevision.$$$reportNull$$$0(3);
            }
            return gitLocalBranch;
        }

        @Override
        @NotNull
        public String getRevision() {
            String string = this.myRevision;
            if (string == null) {
                OnRevision.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        public boolean isBranchRef() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branch";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/push/GitPushSource$OnRevision";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/push/GitPushSource$OnRevision";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBranch";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevision";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    static class DetachedHead
    extends GitPushSource {
        @NotNull
        private final String myRevision;

        DetachedHead(@NotNull String revision) {
            if (revision == null) {
                DetachedHead.$$$reportNull$$$0(0);
            }
            this.myRevision = revision;
        }

        @NotNull
        public String getPresentation() {
            String string = DvcsUtil.getShortHash((String)this.myRevision);
            if (string == null) {
                DetachedHead.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nullable
        public GitLocalBranch getBranch() {
            return null;
        }

        @Override
        @NotNull
        public String getRevision() {
            String string = this.myRevision;
            if (string == null) {
                DetachedHead.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public boolean isBranchRef() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/push/GitPushSource$DetachedHead";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/push/GitPushSource$DetachedHead";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevision";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    static class Tag
    extends GitPushSource {
        @NotNull
        private final GitTag tag;

        Tag(@NotNull GitTag tag) {
            if (tag == null) {
                Tag.$$$reportNull$$$0(0);
            }
            this.tag = tag;
        }

        @NotNull
        public String getPresentation() {
            String string = this.tag.getName();
            if (string == null) {
                Tag.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nullable
        public GitLocalBranch getBranch() {
            return null;
        }

        @Override
        @NotNull
        public String getRevision() {
            String string = this.tag.getFullName();
            if (string == null) {
                Tag.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public boolean isBranchRef() {
            return false;
        }

        @NotNull
        GitTag getTag() {
            GitTag gitTag = this.tag;
            if (gitTag == null) {
                Tag.$$$reportNull$$$0(3);
            }
            return gitTag;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/push/GitPushSource$Tag";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/push/GitPushSource$Tag";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevision";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTag";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

