/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commit.signing;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import git4idea.commit.signing.GpgAgentCommandExecutor;
import git4idea.commit.signing.GpgAgentConfig;
import git4idea.commit.signing.GpgAgentConfigurationNotificator;
import git4idea.commit.signing.GpgAgentConfiguratorKt;
import git4idea.commit.signing.GpgAgentPaths;
import git4idea.commit.signing.GpgAgentPathsLocator;
import git4idea.commit.signing.LocalGpgAgentCommandExecutor;
import git4idea.commit.signing.MacAndUnixGpgAgentPathsLocator;
import git4idea.commit.signing.PinentryShellScriptLauncherGenerator;
import git4idea.commit.signing.WslGpgAgentCommandExecutor;
import git4idea.commit.signing.WslGpgAgentPathsLocator;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableListener;
import git4idea.config.GitExecutableManager;
import git4idea.config.gpg.GitGpgConfigUtilsKt;
import git4idea.repo.GitConfigListener;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b\u0001\u0018\u0000 )2\u00020\u0001:\u0001)B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0007J\u0006\u0010\u000e\u001a\u00020\u000bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0019\u0010\u0015\u001a\u00020\u000b2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0010H\u0001\u00a2\u0006\u0002\b\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u000bH\u0002J\b\u0010\u001d\u001a\u00020\u000bH\u0002J\u0018\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010#\u001a\u00020\u0019H\u0002J\u0018\u0010$\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010#\u001a\u00020\u0019H\u0002J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020!H\u0002J\u0010\u0010'\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010(\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lgit4idea/commit/signing/GpgAgentConfigurator;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "updateLauncherQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "init", "", "isConfigured", "", "configure", "createPathLocator", "Lgit4idea/commit/signing/GpgAgentPathsLocator;", "executor", "Lgit4idea/config/GitExecutable;", "createGpgAgentExecutor", "Lgit4idea/commit/signing/GpgAgentCommandExecutor;", "doConfigure", "pathLocator", "doConfigure$intellij_vcs_git", "readConfig", "Lgit4idea/commit/signing/GpgAgentConfig;", "gpgAgentConf", "Ljava/nio/file/Path;", "emitUpdateLauncherEvent", "updateExistingPinentryLauncher", "generatePinentryLauncher", "executable", "gpgAgentPaths", "Lgit4idea/commit/signing/GpgAgentPaths;", "backupExistingConfig", "config", "writeAgentConfig", "deleteBackup", "paths", "restartAgent", "dispose", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGpgAgentConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GpgAgentConfigurator.kt\ngit4idea/commit/signing/GpgAgentConfigurator\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,438:1\n31#2,2:439\n31#2,2:445\n126#3:441\n153#3,3:442\n*S KotlinDebug\n*F\n+ 1 GpgAgentConfigurator.kt\ngit4idea/commit/signing/GpgAgentConfigurator\n*L\n233#1:439,2\n82#1:445,2\n236#1:441\n236#1:442,3\n*E\n"})
public final class GpgAgentConfigurator
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final MergingUpdateQueue updateLauncherQueue;
    @NotNull
    public static final String GPG_AGENT_PINENTRY_PROGRAM_CONF_KEY = "pinentry-program";

    public GpgAgentConfigurator(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cs = cs;
        this.updateLauncherQueue = new MergingUpdateQueue("update pinentry launcher queue", 100, true, null, (Disposable)this, null, false);
    }

    public final void init() {
        MessageBusConnection connection = ApplicationKt.getApplication().getMessageBus().connect((Disposable)this);
        Topic<GitExecutableListener> topic = GitExecutableManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        connection.subscribe(topic, () -> GpgAgentConfigurator.init$lambda$0(this));
        this.project.getMessageBus().connect((Disposable)this).subscribe(GitConfigListener.TOPIC, (Object)new GitConfigListener(this){
            final /* synthetic */ GpgAgentConfigurator this$0;
            {
                this.this$0 = $receiver;
            }

            public void notifyConfigChanged(GitRepository repository) {
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                ComponentManager $this$service$iv = (ComponentManager)GpgAgentConfigurator.access$getProject$p(this.this$0);
                boolean $i$f$service = false;
                Class<GpgAgentConfigurationNotificator> serviceClass$iv = GpgAgentConfigurationNotificator.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                ((GpgAgentConfigurationNotificator)object).proposeCustomPinentryAgentConfiguration(false);
                GpgAgentConfigurator.access$emitUpdateLauncherEvent(this.this$0);
            }
        });
        this.emitUpdateLauncherEvent();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresBackgroundThread
    public final boolean isConfigured(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GitExecutable gitExecutable = GitExecutableManager.getInstance().getExecutable(project);
        Intrinsics.checkNotNullExpressionValue((Object)gitExecutable, (String)"getExecutable(...)");
        GitExecutable executable = gitExecutable;
        GpgAgentPaths gpgAgentPaths = this.createPathLocator(executable).resolvePaths();
        if (gpgAgentPaths == null) {
            return false;
        }
        GpgAgentPaths gpgAgentPaths2 = gpgAgentPaths;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(gpgAgentPaths2.getGpgPinentryAppLauncher(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
        GpgAgentConfig gpgAgentConfig = this.readConfig(gpgAgentPaths2.getGpgAgentConf());
        if (!Intrinsics.areEqual((Object)(gpgAgentConfig != null ? gpgAgentConfig.getContent().get(GPG_AGENT_PINENTRY_PROGRAM_CONF_KEY) : null), (Object)gpgAgentPaths2.getGpgPinentryAppLauncherConfigPath())) return false;
        return true;
    }

    public final void configure() {
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GpgAgentConfigurator this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ GpgAgentConfigurator this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        GpgAgentConfigurator.doConfigure$intellij_vcs_git$default(this.this$0, null, 1, null);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final GpgAgentPathsLocator createPathLocator(GitExecutable executor) {
        if (executor instanceof GitExecutable.Wsl) {
            return new WslGpgAgentPathsLocator((GitExecutable.Wsl)executor);
        }
        return new MacAndUnixGpgAgentPathsLocator();
    }

    private final GpgAgentCommandExecutor createGpgAgentExecutor(GitExecutable executor) {
        if (executor instanceof GitExecutable.Wsl) {
            return new WslGpgAgentCommandExecutor(this.project, (GitExecutable.Wsl)executor);
        }
        return new LocalGpgAgentCommandExecutor();
    }

    @VisibleForTesting
    public final void doConfigure$intellij_vcs_git(@Nullable GpgAgentPathsLocator pathLocator) {
        GpgAgentConfig config;
        GitExecutable gitExecutable = GitExecutableManager.getInstance().getExecutable(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)gitExecutable, (String)"getExecutable(...)");
        GitExecutable executable = gitExecutable;
        if (!Companion.isEnabled(this.project, executable)) {
            return;
        }
        Object object = pathLocator;
        if ((object == null || (object = object.resolvePaths()) == null) && (object = this.createPathLocator(executable).resolvePaths()) == null) {
            return;
        }
        Object gpgAgentPaths = object;
        Path gpgAgentConf = ((GpgAgentPaths)gpgAgentPaths).getGpgAgentConf();
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean needBackup = Files.exists(gpgAgentConf, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        if (!needBackup) {
            GpgAgentConfiguratorKt.access$getLOG$p().debug("Cannot locate " + gpgAgentConf + ", creating new");
            this.writeAgentConfig((GpgAgentPaths)gpgAgentPaths, new GpgAgentConfig(gpgAgentConf, MapsKt.emptyMap()));
            this.restartAgent(executable);
            needBackup = false;
        }
        if ((config = this.readConfig(gpgAgentConf)) == null) {
            GpgAgentConfiguratorKt.access$getLOG$p().debug("Empty " + gpgAgentConf + ", skipping pinentry program configuration");
            return;
        }
        if (needBackup && this.backupExistingConfig((GpgAgentPaths)gpgAgentPaths, config)) {
            this.writeAgentConfig((GpgAgentPaths)gpgAgentPaths, config);
            this.restartAgent(executable);
        }
        this.generatePinentryLauncher(executable, (GpgAgentPaths)gpgAgentPaths);
    }

    public static /* synthetic */ void doConfigure$intellij_vcs_git$default(GpgAgentConfigurator gpgAgentConfigurator, GpgAgentPathsLocator gpgAgentPathsLocator, int n, Object object) {
        if ((n & 1) != 0) {
            gpgAgentPathsLocator = null;
        }
        gpgAgentConfigurator.doConfigure$intellij_vcs_git(gpgAgentPathsLocator);
    }

    private final GpgAgentConfig readConfig(Path gpgAgentConf) {
        Map config = new LinkedHashMap();
        try {
            Path path = gpgAgentConf;
            List<String> list = Files.readAllLines(path, Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
            block6: for (String line : list) {
                char[] cArray = new char[]{' '};
                List keyValue = StringsKt.split$default((CharSequence)line, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                String key = null;
                String value = null;
                switch (keyValue.size()) {
                    case 1: {
                        key = (String)keyValue.get(0);
                        value = "";
                        break;
                    }
                    case 2: {
                        key = (String)keyValue.get(0);
                        value = (String)keyValue.get(1);
                        break;
                    }
                    default: {
                        continue block6;
                    }
                }
                config.put(key, value);
            }
        }
        catch (IOException e) {
            GpgAgentConfiguratorKt.access$getLOG$p().error("Cannot read " + gpgAgentConf, (Throwable)e);
            return null;
        }
        return new GpgAgentConfig(gpgAgentConf, config);
    }

    private final void emitUpdateLauncherEvent() {
        this.updateLauncherQueue.queue(Update.Companion.create((Object)GPG_AGENT_PINENTRY_PROGRAM_CONF_KEY, () -> GpgAgentConfigurator.emitUpdateLauncherEvent$lambda$1(this)));
    }

    private final void updateExistingPinentryLauncher() {
        GpgAgentPaths gpgAgentPaths;
        GitExecutable gitExecutable = GitExecutableManager.getInstance().getExecutable(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)gitExecutable, (String)"getExecutable(...)");
        GitExecutable executable = gitExecutable;
        if (Companion.isEnabled(this.project, executable) && this.isConfigured(this.project) && (gpgAgentPaths = this.createPathLocator(executable).resolvePaths()) != null) {
            this.generatePinentryLauncher(executable, gpgAgentPaths);
        }
    }

    private final synchronized void generatePinentryLauncher(GitExecutable executable, GpgAgentPaths gpgAgentPaths) {
        String string;
        Path gpgAgentConfBackup = gpgAgentPaths.getGpgAgentConfBackup();
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(gpgAgentConfBackup, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            GpgAgentConfig gpgAgentConfig = this.readConfig(gpgAgentConfBackup);
            string = gpgAgentConfig != null ? gpgAgentConfig.getContent().get(GPG_AGENT_PINENTRY_PROGRAM_CONF_KEY) : null;
        } else {
            string = null;
        }
        String pinentryFallback = string;
        CharSequence charSequence = pinentryFallback;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            GpgAgentConfiguratorKt.access$getLOG$p().warn("Pinentry fallback not found in " + gpgAgentConfBackup + ". Some features of GPG (as a key manipulation) may not work correctly without default pinentry-program specified in this file.");
        }
        new PinentryShellScriptLauncherGenerator(executable).generate(this.project, gpgAgentPaths, pinentryFallback);
    }

    private final boolean backupExistingConfig(GpgAgentPaths gpgAgentPaths, GpgAgentConfig config) {
        String pinentryAppLauncherConfigPath = gpgAgentPaths.getGpgPinentryAppLauncherConfigPath();
        if (Intrinsics.areEqual((Object)config.getContent().get(GPG_AGENT_PINENTRY_PROGRAM_CONF_KEY), (Object)pinentryAppLauncherConfigPath)) {
            return false;
        }
        Path gpgAgentConf = gpgAgentPaths.getGpgAgentConf();
        Path gpgAgentConfBackup = gpgAgentPaths.getGpgAgentConfBackup();
        try {
            Path path = gpgAgentConf;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray2 = copyOptionArray;
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path, gpgAgentConfBackup, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"copy(...)");
        }
        catch (IOException e) {
            GpgAgentConfiguratorKt.access$getLOG$p().warn("Cannot backup config " + gpgAgentConf + " to " + gpgAgentConfBackup, (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void writeAgentConfig(GpgAgentPaths gpgAgentPaths, GpgAgentConfig config) {
        String pinentryAppLauncherConfigPath = gpgAgentPaths.getGpgPinentryAppLauncherConfigPath();
        Path configPath = config.component1();
        Map<String, String> configContent = config.component2();
        Map configToSave = MapsKt.toMutableMap(configContent);
        configToSave.put(GPG_AGENT_PINENTRY_PROGRAM_CONF_KEY, pinentryAppLauncherConfigPath);
        Object $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GpgAgentConfigurationNotificator> serviceClass$iv = GpgAgentConfigurationNotificator.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        GpgAgentConfigurationNotificator notificator = (GpgAgentConfigurationNotificator)object;
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$service$iv = configToSave;
            File file = configPath.toFile();
            boolean $i$f$map = false;
            serviceClass$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                collection.add(((Object)StringsKt.trimEnd((CharSequence)(key + " " + value))).toString());
            }
            FileUtil.writeToFile((File)file, (String)CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            notificator.notifyConfigurationSuccessful(gpgAgentPaths);
        }
        catch (IOException e) {
            GpgAgentConfiguratorKt.access$getLOG$p().warn("Cannot change config " + configPath, (Throwable)e);
            notificator.notifyConfigurationFailed(e);
            this.deleteBackup(gpgAgentPaths);
        }
    }

    private final void deleteBackup(GpgAgentPaths paths) {
        Path gpgAgentConfBackup = paths.getGpgAgentConfBackup();
        try {
            Files.deleteIfExists(gpgAgentConfBackup);
        }
        catch (Exception e) {
            GpgAgentConfiguratorKt.access$getLOG$p().warn("Cannot delete config " + gpgAgentConfBackup, (Throwable)e);
        }
    }

    private final void restartAgent(GitExecutable executor) {
        try {
            String[] stringArray = new String[]{"reloadagent", "/bye"};
            List<String> output = this.createGpgAgentExecutor(executor).execute("gpg-connect-agent", stringArray);
            if (output.contains("OK")) {
                GpgAgentConfiguratorKt.access$getLOG$p().debug("Gpg Agent restarted successfully");
            } else {
                GpgAgentConfiguratorKt.access$getLOG$p().warn("Gpg Agent restart failed, restart manually to apply config changes " + output);
            }
        }
        catch (ExecutionException e) {
            GpgAgentConfiguratorKt.access$getLOG$p().warn("Gpg Agent restart failed, restart manually to apply config changes", (Throwable)e);
        }
    }

    public void dispose() {
    }

    private static final void init$lambda$0(GpgAgentConfigurator this$0) {
        ComponentManager $this$service$iv = (ComponentManager)this$0.project;
        boolean $i$f$service = false;
        Class<GpgAgentConfigurationNotificator> serviceClass$iv = GpgAgentConfigurationNotificator.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((GpgAgentConfigurationNotificator)object).proposeCustomPinentryAgentConfiguration(false);
        this$0.emitUpdateLauncherEvent();
    }

    private static final void emitUpdateLauncherEvent$lambda$1(GpgAgentConfigurator this$0) {
        this$0.updateExistingPinentryLauncher();
    }

    @JvmStatic
    public static final boolean isEnabled(@NotNull Project project, @NotNull GitExecutable executable) {
        return Companion.isEnabled(project, executable);
    }

    public static final /* synthetic */ Project access$getProject$p(GpgAgentConfigurator $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$emitUpdateLauncherEvent(GpgAgentConfigurator $this) {
        $this.emitUpdateLauncherEvent();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lgit4idea/commit/signing/GpgAgentConfigurator$Companion;", "", "<init>", "()V", "GPG_AGENT_PINENTRY_PROGRAM_CONF_KEY", "", "isEnabled", "", "project", "Lcom/intellij/openapi/project/Project;", "executable", "Lgit4idea/config/GitExecutable;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGpgAgentConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GpgAgentConfigurator.kt\ngit4idea/commit/signing/GpgAgentConfigurator$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,438:1\n1755#2,3:439\n*S KotlinDebug\n*F\n+ 1 GpgAgentConfigurator.kt\ngit4idea/commit/signing/GpgAgentConfigurator$Companion\n*L\n69#1:439,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean isEnabled(@NotNull Project project, @NotNull GitExecutable executable) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            if (!Registry.Companion.is("git.commit.gpg.signing.enable.embedded.pinentry", false)) return false;
            if (!SystemInfo.isUnix && !(executable instanceof GitExecutable.Wsl)) {
                if (!ApplicationKt.getApplication().isUnitTestMode()) return false;
            }
            List<GitRepository> list = GitRepositoryManager.getInstance(project).getRepositories();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getRepositories(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                GitRepository repository = (GitRepository)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)repository);
                if (GitGpgConfigUtilsKt.isGpgSignEnabledCached(repository) && GitGpgConfigUtilsKt.getGpgSignKeyCached(repository) != null) {
                    return true;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

