/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.js.utils;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lexer.Lexer;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionEnclosuresDefinition;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionLexeme;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionLexer;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionLexerAdapter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001e\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J(\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J.\u0010\u001d\u001a\u00020\r*\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\"H\u0002R\u0013\u0010\u001a\u001a\u00070\u001b\u00a2\u0006\u0002\b\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/ml/inline/completion/js/utils/JSDialectMLCompletionLexerBase;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexerAdapter;", "enclosuresDefinition", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionEnclosuresDefinition;", "<init>", "(Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionEnclosuresDefinition;)V", "onToken", "", "token", "Lcom/intellij/psi/tree/IElementType;", "text", "", "offset", "", "collector", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexerAdapter$LexemesCollector;", "getLexingResult", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexer$LexingResult;", "lexemes", "", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexeme;", "lexer", "Lcom/intellij/lexer/Lexer;", "onBracketToken", "collectBracket", "findStringMarkers", "bracketsSet", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "update", "Lcom/intellij/openapi/util/UserDataHolder;", "key", "Lcom/intellij/openapi/util/Key;", "value", "Lkotlin/Function1;", "Companion", "intellij.ml.inline.completion.js"})
@SourceDebugExtension(value={"SMAP\nJSDialectMLCompletionLexerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSDialectMLCompletionLexerBase.kt\ncom/intellij/ml/inline/completion/js/utils/JSDialectMLCompletionLexerBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,150:1\n1755#2,3:151\n1734#2,3:160\n967#2,7:163\n170#3,6:154\n*S KotlinDebug\n*F\n+ 1 JSDialectMLCompletionLexerBase.kt\ncom/intellij/ml/inline/completion/js/utils/JSDialectMLCompletionLexerBase\n*L\n26#1:151,3\n115#1:160,3\n116#1:163,7\n113#1:154,6\n*E\n"})
public abstract class JSDialectMLCompletionLexerBase
extends MLCompletionLexerAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TokenSet bracketsSet;
    @NotNull
    private static final Key<Integer> BRACES_CNT_KEY = new Key("full.line.js.lexer.braces.cnt");

    public JSDialectMLCompletionLexerBase(@NotNull MLCompletionEnclosuresDefinition enclosuresDefinition) {
        Intrinsics.checkNotNullParameter((Object)enclosuresDefinition, (String)"enclosuresDefinition");
        super(enclosuresDefinition);
        IElementType[] iElementTypeArray = new IElementType[]{JSTokenTypes.LPAR, JSTokenTypes.RPAR, JSTokenTypes.LBRACKET, JSTokenTypes.RBRACKET, JSTokenTypes.LBRACE, JSTokenTypes.RBRACE, JSTokenTypes.XML_LBRACE, JSTokenTypes.XML_RBRACE, JSTokenTypes.XML_START_TAG_START, JSTokenTypes.XML_TAG_END, JSTokenTypes.XML_END_TAG_START, JSTokenTypes.XML_EMPTY_TAG_END};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        this.bracketsSet = tokenSet;
    }

    @Override
    protected void onToken(@NotNull IElementType token, @NotNull String text, int offset, @NotNull MLCompletionLexerAdapter.LexemesCollector collector) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        if (((CharSequence)text).length() == 0) {
            return;
        }
        if (this.bracketsSet.contains(token)) {
            this.onBracketToken(token, text, offset, collector);
        } else {
            this.findStringMarkers(token, text, offset, collector);
        }
    }

    @Override
    @NotNull
    protected MLCompletionLexer.LexingResult getLexingResult(@NotNull List<? extends MLCompletionLexeme> lexemes, @NotNull Lexer lexer) {
        MLCompletionLexer.LexingResult lexingResult;
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(lexemes, (String)"lexemes");
            Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
            Iterable $this$any$iv = lexemes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    MLCompletionLexeme it = (MLCompletionLexeme)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getText(), (Object)"<") || Intrinsics.areEqual((Object)it.getText(), (Object)">"))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            CharSequence charSequence = lexer.getBufferSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getBufferSequence(...)");
            lexingResult = new MLCompletionLexer.LexingResult(lexemes, new MLCompletionLexer.LexingContext(charSequence));
        } else {
            lexingResult = super.getLexingResult(lexemes, lexer);
        }
        return lexingResult;
    }

    private final void onBracketToken(IElementType token, String text, int offset, MLCompletionLexerAdapter.LexemesCollector collector) {
        MLCompletionLexerAdapter.Location location = collector.getCurrentLocation();
        if (location instanceof MLCompletionLexerAdapter.Location.StringLiteral) {
            if (Intrinsics.areEqual((Object)token, (Object)JSTokenTypes.LBRACE)) {
                collector.stringTemplate('{', offset, "${");
                collector.getCurrentLocation().getData().putUserData(BRACES_CNT_KEY, (Object)0);
            }
        } else if (location instanceof MLCompletionLexerAdapter.Location.Global) {
            this.collectBracket(token, text, offset, collector);
        } else if (location instanceof MLCompletionLexerAdapter.Location.StringTemplate) {
            IElementType iElementType = token;
            if (Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.LBRACE)) {
                this.update(collector.getCurrentLocation().getData(), BRACES_CNT_KEY, (Function1<? super Integer, Integer>)((Function1)JSDialectMLCompletionLexerBase::onBracketToken$lambda$1));
                collector.bracket('{', offset);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.RBRACE)) {
                int currentBalance = this.update(collector.getCurrentLocation().getData(), BRACES_CNT_KEY, (Function1<? super Integer, Integer>)((Function1)JSDialectMLCompletionLexerBase::onBracketToken$lambda$2));
                if (currentBalance == -1) {
                    MLCompletionLexerAdapter.LexemesCollector.stringTemplate$default(collector, '}', offset, null, 4, null);
                } else {
                    collector.bracket('}', offset);
                }
            } else {
                this.collectBracket(token, text, offset, collector);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void collectBracket(IElementType token, String text, int offset, MLCompletionLexerAdapter.LexemesCollector collector) {
        if (!(((CharSequence)text).length() > 0)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        IElementType iElementType = token;
        if (Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.XML_END_TAG_START)) {
            if (Intrinsics.areEqual((Object)text, (Object)"</")) {
                collector.bracket('<', offset);
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.XML_EMPTY_TAG_END)) {
            if (Intrinsics.areEqual((Object)text, (Object)"/>")) {
                collector.bracket('>', offset + 1);
            }
        } else if (text.length() == 1) {
            collector.bracket(StringsKt.first((CharSequence)text), offset);
        }
    }

    private final void findStringMarkers(IElementType token, String text, int offset, MLCompletionLexerAdapter.LexemesCollector collector) {
        IElementType iElementType = token;
        if (Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.STRING_LITERAL)) {
            char quote = StringsKt.first((CharSequence)text);
            if (this.getEnclosures().isStringMarker(quote)) {
                MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector, quote, offset, null, 4, null);
                if (StringsKt.last((CharSequence)text) == quote && text.length() > 1) {
                    MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector, quote, offset + text.length() - 1, null, 4, null);
                }
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.BACKQUOTE)) {
            if (this.getEnclosures().isStringMarker(StringsKt.first((CharSequence)text))) {
                MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector, StringsKt.first((CharSequence)text), offset, null, 4, null);
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.REGEXP_LITERAL)) {
            char slash = StringsKt.first((CharSequence)text);
            if (this.getEnclosures().isStringMarker(slash)) {
                int closingSlashOffset;
                block19: {
                    int n;
                    MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector, slash, offset, null, 4, null);
                    CharSequence $this$indexOfLast$iv = text;
                    boolean $i$f$indexOfLast = false;
                    int n2 = $this$indexOfLast$iv.length() + -1;
                    if (0 <= n2) {
                        do {
                            int index$iv = n2--;
                            char it = $this$indexOfLast$iv.charAt(index$iv);
                            boolean bl = false;
                            if (!(it == slash)) continue;
                            n = index$iv;
                            break block19;
                        } while (0 <= n2);
                    }
                    n = closingSlashOffset = -1;
                }
                if (closingSlashOffset > 0) {
                    boolean isEscaped;
                    boolean bl;
                    block20: {
                        Iterable $this$all$iv = (Iterable)RangesKt.until((int)(closingSlashOffset + 1), (int)text.length());
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            Iterator index$iv = $this$all$iv.iterator();
                            while (index$iv.hasNext()) {
                                int element$iv;
                                int it = element$iv = ((IntIterator)index$iv).nextInt();
                                boolean bl2 = false;
                                if (Character.isLetter(text.charAt(it))) continue;
                                bl = false;
                                break block20;
                            }
                            bl = true;
                        }
                    }
                    boolean actuallyClosing = bl;
                    Iterable $this$takeWhile$iv = (Iterable)RangesKt.downTo((int)(closingSlashOffset - 1), (int)0);
                    boolean $i$f$takeWhile = false;
                    ArrayList list$iv = new ArrayList();
                    for (Object item$iv : $this$takeWhile$iv) {
                        int it = ((Number)item$iv).intValue();
                        boolean bl3 = false;
                        if (!(text.charAt(it) == '\\')) break;
                        list$iv.add(item$iv);
                    }
                    boolean bl4 = isEscaped = ((List)list$iv).size() % 2 != 0;
                    if (actuallyClosing && !isEscaped) {
                        MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector, slash, offset + closingSlashOffset, null, 4, null);
                    }
                }
            }
        } else if ((Intrinsics.areEqual((Object)iElementType, (Object)XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) || Intrinsics.areEqual((Object)iElementType, (Object)XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER)) && (Intrinsics.areEqual((Object)text, (Object)"'") || Intrinsics.areEqual((Object)text, (Object)"\""))) {
            MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector, StringsKt.first((CharSequence)text), offset, null, 4, null);
        }
    }

    private final int update(UserDataHolder $this$update, Key<Integer> key, Function1<? super Integer, Integer> value) {
        Integer n = (Integer)$this$update.getUserData(key);
        int newValue = ((Number)value.invoke((Object)(n != null ? n : 0))).intValue();
        $this$update.putUserData(key, (Object)newValue);
        return newValue;
    }

    private static final int onBracketToken$lambda$1(int it) {
        return it + 1;
    }

    private static final int onBracketToken$lambda$2(int it) {
        return it - 1;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/inline/completion/js/utils/JSDialectMLCompletionLexerBase$Companion;", "", "<init>", "()V", "BRACES_CNT_KEY", "Lcom/intellij/openapi/util/Key;", "", "intellij.ml.inline.completion.js"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

