/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.postprocessing.filter;

import com.intellij.ml.inline.completion.features.correctness.SuggestionEnricher;
import com.intellij.ml.inline.completion.impl.AnalyzedMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionLanguageKit;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionStringLiteralSupporter;
import com.intellij.ml.inline.completion.impl.postprocessing.analyzer.CorrectnessAnalysisState;
import com.intellij.ml.inline.completion.impl.postprocessing.filter.ProposalFilter;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/inline/completion/impl/postprocessing/filter/CommentFilter;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/filter/ProposalFilter$Adapter;", "kit", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;", "<init>", "(Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;)V", "checkAnalyzed", "", "proposal", "Lcom/intellij/ml/inline/completion/impl/AnalyzedMLCompletionProposal;", "intellij.ml.inline.completion"})
public final class CommentFilter
extends ProposalFilter.Adapter {
    @NotNull
    private final MLCompletionLanguageKit kit;

    public CommentFilter(@NotNull MLCompletionLanguageKit kit) {
        Intrinsics.checkNotNullParameter((Object)kit, (String)"kit");
        super("contains comment");
        this.kit = kit;
    }

    @Override
    public boolean checkAnalyzed(@NotNull AnalyzedMLCompletionProposal proposal) {
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        CorrectnessAnalysisState correctnessState = proposal.getCorrectnessState();
        if (!(correctnessState instanceof CorrectnessAnalysisState.Analyzed)) {
            if (Intrinsics.areEqual((Object)correctnessState, (Object)CorrectnessAnalysisState.Unknown.INSTANCE)) {
                return true;
            }
            throw new NoWhenBranchMatchedException();
        }
        SuggestionEnricher.Enrichment enrichment = ((CorrectnessAnalysisState.Analyzed)correctnessState).getEnrichment();
        PsiFile psi = enrichment.component2();
        TextRange range = enrichment.component3();
        MLCompletionStringLiteralSupporter stringSupporter = this.kit.getStringLiteralSupporter();
        PsiElement element = psi.findElementAt(range.getStartOffset());
        while (element != null && PsiTreeUtilKt.getStartOffset((PsiElement)element) < range.getEndOffset()) {
            if (stringSupporter.isComment(element)) {
                return false;
            }
            element = PsiTreeUtil.nextLeaf((PsiElement)element);
        }
        return true;
    }
}

