/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import com.google.common.xml.XmlEscapers;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;

public final class StringTools {
    private static final Pattern NONCHAR = Pattern.compile("[^A-Z\\u00c0-\\u00D6\\u00D8-\\u00DE]");
    private static final Pattern WORD_FOR_SPELLER = Pattern.compile("^[\\p{L}\\d\\p{P}\\p{Zs}]+$");
    private static final Pattern IS_NUMERIC = Pattern.compile("^[\\d\\s\\.,]*\\d$");
    public static final Set<String> UPPERCASE_GREEK_LETTERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("\u0391", "\u0392", "\u0393", "\u0394", "\u0395", "\u0396", "\u0397", "\u0398", "\u0399", "\u039a", "\u039b", "\u039c", "\u039d", "\u039e", "\u039f", "\u03a0", "\u03a1", "\u03a3", "\u03a4", "\u03a5", "\u03a6", "\u03a7", "\u03a8", "\u03a9")));
    public static final Set<String> LOWERCASE_GREEK_LETTERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("\u03b1", "\u03b2", "\u03b3", "\u03b4", "\u03b5", "\u03b6", "\u03b7", "\u03b8", "\u03b9", "\u03ba", "\u03bb", "\u03bc", "\u03bd", "\u03be", "\u03bf", "\u03c0", "\u03c1", "\u03c3", "\u03c4", "\u03c5", "\u03c6", "\u03c7", "\u03c8", "\u03c9")));
    private static final String[] WHITESPACE_ARRAY = new String[20];
    public static final Pattern CHARS_NOT_FOR_SPELLING;
    private static final Pattern XML_COMMENT_PATTERN;
    private static final Pattern XML_PATTERN;
    private static final Pattern PUNCTUATION_PATTERN;
    private static final Pattern NOT_WORD_CHARACTER;
    private static final Pattern NOT_WORD_STR;
    private static final Pattern PATTERN;
    private static final Pattern DIACRIT_MARKS;
    private static final Set<String> ENGLISH_TITLECASE_EXCEPTIONS;
    private static final Set<String> PORTUGUESE_TITLECASE_EXCEPTIONS;
    private static final Set<String> FRENCH_TITLECASE_EXCEPTIONS;
    private static final Set<String> SPANISH_TITLECASE_EXCEPTIONS;
    private static final Set<String> GERMAN_TITLECASE_EXCEPTIONS;
    private static final Set<String> DUTCH_TITLECASE_EXCEPTIONS;
    private static final Set<String> ALL_TITLECASE_EXCEPTIONS;

    private StringTools() {
    }

    public static void assureSet(String s, String varName) {
        Objects.requireNonNull(varName);
        if (StringTools.isEmpty(s.trim())) {
            throw new IllegalArgumentException(varName + " cannot be empty or whitespace only");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStream(InputStream stream, String encoding) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader isr = null;){
            isr = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);
            try (BufferedReader br = new BufferedReader(isr);){
                String line;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append('\n');
                }
            }
        }
        return sb.toString();
    }

    public static boolean isAllUppercase(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isLetter(c) || !Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllUppercase(List<String> strList) {
        boolean isInputAllUppercase = true;
        boolean isAllNotLetters = true;
        for (int i = 0; i < strList.size(); ++i) {
            isInputAllUppercase = isInputAllUppercase && StringTools.isAllUppercase(strList.get(i));
            isAllNotLetters = isAllNotLetters && (StringTools.isNotWordString(strList.get(i)) || StringTools.isPunctuationMark(strList.get(i)));
        }
        return isInputAllUppercase && !isAllNotLetters;
    }

    public static boolean isMixedCase(String str) {
        return !StringTools.isAllUppercase(str) && !StringTools.isCapitalizedWord(str) && StringTools.isNotAllLowercase(str);
    }

    public static boolean isNotAllLowercase(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isLetter(c) || Character.isLowerCase(c)) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean isCapitalizedWord(@Nullable String str) {
        if (!StringTools.isEmpty(str) && Character.isUpperCase(str.charAt(0))) {
            for (int i = 1; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (!Character.isLetter(c) || Character.isLowerCase(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean startsWithUppercase(String str) {
        if (StringTools.isEmpty(str)) {
            return false;
        }
        return Character.isUpperCase(str.charAt(0));
    }

    public static boolean startsWithLowercase(String str) {
        if (StringTools.isEmpty(str)) {
            return false;
        }
        return Character.isLowerCase(str.charAt(0));
    }

    public static boolean allStartWithLowercase(String str) {
        String[] strParts = str.split(" ");
        if (strParts.length < 2) {
            return StringTools.startsWithLowercase(str);
        }
        for (String strPart : strParts) {
            if (StringTools.startsWithLowercase(strPart)) continue;
            return false;
        }
        return true;
    }

    @Contract(value="!null -> !null")
    @Nullable
    public static String uppercaseFirstChar(@Nullable String str) {
        return StringTools.changeFirstCharCase(str, true);
    }

    @Contract(value="!null, _ -> !null")
    @Nullable
    public static String uppercaseFirstChar(@Nullable String str, Language language) {
        if (language != null && "nl".equals(language.getShortCode()) && str != null && str.toLowerCase().startsWith("ij")) {
            return "IJ" + str.substring(2);
        }
        return StringTools.changeFirstCharCase(str, true);
    }

    private static Set<String> collectAllTitleCaseExceptions() {
        List<Set> setList = Arrays.asList(ENGLISH_TITLECASE_EXCEPTIONS, PORTUGUESE_TITLECASE_EXCEPTIONS, FRENCH_TITLECASE_EXCEPTIONS, SPANISH_TITLECASE_EXCEPTIONS, GERMAN_TITLECASE_EXCEPTIONS, DUTCH_TITLECASE_EXCEPTIONS);
        Set<String> union = setList.stream().flatMap(Collection::stream).collect(Collectors.toSet());
        return union;
    }

    @Contract(value="!null -> !null")
    @Nullable
    public static String titlecaseGlobal(@Nullable String str) {
        assert (str != null);
        String[] strParts = str.split(" ");
        if (strParts.length == 1) {
            return StringTools.uppercaseFirstChar(str);
        }
        StringJoiner titlecasedStr = new StringJoiner(" ");
        for (int i = 0; i < strParts.length; ++i) {
            String strPart = strParts[i];
            if (i == 0) {
                titlecasedStr.add(StringTools.uppercaseFirstChar(strPart));
                continue;
            }
            if (ALL_TITLECASE_EXCEPTIONS.contains(strPart.toLowerCase())) {
                titlecasedStr.add(StringTools.lowercaseFirstCharIfCapitalized(strPart));
                continue;
            }
            titlecasedStr.add(StringTools.uppercaseFirstChar(strPart));
        }
        return titlecasedStr.toString();
    }

    @Contract(value="!null -> !null")
    @Nullable
    public static String lowercaseFirstChar(@Nullable String str) {
        return StringTools.changeFirstCharCase(str, false);
    }

    @Contract(value="!null, -> !null")
    @Nullable
    public static String lowercaseFirstCharIfCapitalized(@Nullable String str) {
        if (!StringTools.isCapitalizedWord(str)) {
            return str;
        }
        return StringTools.changeFirstCharCase(str, false);
    }

    @Contract(value="!null, _ -> !null")
    @Nullable
    private static String changeFirstCharCase(@Nullable String str, boolean toUpperCase) {
        int pos;
        if (StringTools.isEmpty(str)) {
            return str;
        }
        if (str.length() == 1) {
            return toUpperCase ? str.toUpperCase(Locale.ENGLISH) : str.toLowerCase();
        }
        int len = str.length() - 1;
        for (pos = 0; !Character.isLetterOrDigit(str.charAt(pos)) && len > pos; ++pos) {
        }
        char firstChar = str.charAt(pos);
        return str.substring(0, pos) + (toUpperCase ? Character.toUpperCase(firstChar) : Character.toLowerCase(firstChar)) + str.substring(pos + 1);
    }

    public static String readerToString(Reader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        int readBytes = 0;
        char[] chars = new char[4000];
        while (readBytes >= 0 && (readBytes = reader.read(chars, 0, 4000)) > 0) {
            sb.append(new String(chars, 0, readBytes));
        }
        return sb.toString();
    }

    public static String streamToString(InputStream is, String charsetName) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(is, charsetName);){
            String string2 = StringTools.readerToString(isr);
            return string2;
        }
    }

    public static String escapeXML(String s) {
        return StringTools.escapeHTML(s);
    }

    public static String escapeForXmlAttribute(String s) {
        return XmlEscapers.xmlAttributeEscaper().escape(s);
    }

    public static String escapeForXmlContent(String s) {
        return XmlEscapers.xmlContentEscaper().escape(s);
    }

    public static String escapeHTML(String s) {
        StringBuilder sb = new StringBuilder();
        int n = s.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String trimWhitespace(String s) {
        StringBuilder filter2 = new StringBuilder();
        String str = s.trim();
        for (int i = 0; i < str.length(); ++i) {
            while (str.charAt(i) <= ' ' && i < str.length() && (str.charAt(i + 1) <= ' ' || i > 1 && str.charAt(i - 1) <= ' ')) {
                ++i;
            }
            char c = str.charAt(i);
            if (c == '\n' || c == '\t' || c == '\r') continue;
            filter2.append(c);
        }
        return filter2.length() == str.length() ? str : filter2.toString();
    }

    public static String trimSpecialCharacters(String s) {
        return PATTERN.matcher(s).replaceAll("");
    }

    public static String addSpace(String word, Language language) {
        String space = " ";
        if (word.length() == 1) {
            char c = word.charAt(0);
            if ("fr".equals(language.getShortCode())) {
                if (c == '.' || c == ',') {
                    space = "";
                }
            } else if (c == '.' || c == ',' || c == ';' || c == ':' || c == '?' || c == '!') {
                space = "";
            }
        }
        return space;
    }

    public static boolean isWhitespace(String str) {
        if ("\u0002".equals(str) || "\u0001".equals(str)) {
            return false;
        }
        if ("\ufeff".equals(str)) {
            return true;
        }
        String trimStr = str.trim();
        if (StringTools.isEmpty(trimStr)) {
            return true;
        }
        if (trimStr.length() == 1) {
            if ("\u200b".equals(str) || "\u00a0".equals(str) || "\u202f".equals(str)) {
                return true;
            }
            return Character.isWhitespace(trimStr.charAt(0));
        }
        return false;
    }

    public static boolean isNonBreakingWhitespace(String str) {
        return "\u00a0".equals(str);
    }

    public static boolean isPositiveNumber(char ch) {
        return ch >= '1' && ch <= '9';
    }

    public static boolean isEmpty(@Nullable String str) {
        return str == null || str.length() == 0;
    }

    public static String filterXML(String str) {
        String s = str;
        if (s.contains("<")) {
            s = XML_COMMENT_PATTERN.matcher(s).replaceAll(" ");
            s = XML_PATTERN.matcher(s).replaceAll("");
        }
        return s;
    }

    public static boolean hasDiacritics(String str) {
        return !str.equals(StringTools.removeDiacritics(str));
    }

    public static String removeDiacritics(String str) {
        String s = Normalizer.normalize(str, Normalizer.Form.NFD);
        return DIACRIT_MARKS.matcher(s).replaceAll("");
    }

    public static String normalizeNFKC(String str) {
        return Normalizer.normalize(str, Normalizer.Form.NFKC);
    }

    public static String normalizeNFC(String str) {
        return Normalizer.normalize(str, Normalizer.Form.NFC);
    }

    public static String preserveCase(String inputString, String modelString) {
        if (modelString.isEmpty()) {
            return inputString;
        }
        if (StringTools.isCapitalizedWord(modelString)) {
            return StringTools.uppercaseFirstChar(inputString.toLowerCase());
        }
        if (StringTools.isAllUppercase(modelString)) {
            return inputString.toUpperCase();
        }
        return inputString;
    }

    @Nullable
    public static String asString(CharSequence s) {
        if (s == null) {
            return null;
        }
        return s.toString();
    }

    public static boolean isParagraphEnd(String sentence, boolean singleLineBreaksMarksPara) {
        boolean isParaEnd = false;
        if (singleLineBreaksMarksPara) {
            if (sentence.endsWith("\n") || sentence.endsWith("\n\r")) {
                isParaEnd = true;
            }
        } else if (sentence.endsWith("\n\n") || sentence.endsWith("\n\r\n\r") || sentence.endsWith("\r\n\r\n")) {
            isParaEnd = true;
        }
        return isParaEnd;
    }

    public static List<String> loadLines(String path) {
        InputStream stream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(path);
        ArrayList<String> l = new ArrayList<String>();
        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                l.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load data from " + path, e);
        }
        return Collections.unmodifiableList(l);
    }

    public static String toId(String input, Language language) {
        String languageCode = language.getShortCode();
        String normalisedId = input.toUpperCase().trim().replace(' ', '_').replace("'", "_Q_");
        if (Objects.equals(languageCode, "de")) {
            normalisedId = normalisedId.replace("\u00c4", "AE").replace("\u00dc", "UE").replace("\u00d6", "OE");
        }
        normalisedId = NONCHAR.matcher(normalisedId).replaceAll("_");
        return normalisedId;
    }

    public static boolean isCamelCase(String token) {
        return token.matches("[a-z]+[A-Z][A-Za-z]+");
    }

    public static boolean isPunctuationMark(String input) {
        return PUNCTUATION_PATTERN.matcher(input).matches();
    }

    public static boolean isNotWordCharacter(String input) {
        return NOT_WORD_CHARACTER.matcher(input).matches();
    }

    public static List<String> getDifference(String s1, String s2) {
        int fromEnd;
        int fromStart;
        ArrayList<String> results = new ArrayList<String>();
        if (s1.equals(s2)) {
            results.add(s1);
            results.add("");
            results.add("");
            results.add("");
            return results;
        }
        int l1 = s1.length();
        int l2 = s2.length();
        for (fromStart = 0; fromStart < l1 && fromStart < l2 && s1.charAt(fromStart) == s2.charAt(fromStart); ++fromStart) {
        }
        for (fromEnd = 0; fromEnd < l1 && fromEnd < l2 && s1.charAt(l1 - 1 - fromEnd) == s2.charAt(l2 - 1 - fromEnd); ++fromEnd) {
        }
        while (fromStart > l1 - fromEnd) {
            --fromEnd;
        }
        while (fromStart > l2 - fromEnd) {
            --fromEnd;
        }
        results.add(s1.substring(0, fromStart));
        results.add(s1.substring(fromStart, l1 - fromEnd));
        results.add(s2.substring(fromStart, l2 - fromEnd));
        results.add(s1.substring(l1 - fromEnd, l1));
        return results;
    }

    public static String makeWrong(String s) {
        if (s.contains("a")) {
            return s.replace("a", "\u00e4");
        }
        if (s.contains("e")) {
            return s.replace("e", "\u00eb");
        }
        if (s.contains("i")) {
            return s.replace("i", "\u00ef");
        }
        if (s.contains("o")) {
            return s.replace("o", "\u00f6");
        }
        if (s.contains("u")) {
            return s.replace("u", "\u00f9");
        }
        if (s.contains("\u00e1")) {
            return s.replace("\u00e1", "\u00e4");
        }
        if (s.contains("\u00e9")) {
            return s.replace("\u00e9", "\u00eb");
        }
        if (s.contains("\u00ed")) {
            return s.replace("\u00ed", "\u00ef");
        }
        if (s.contains("\u00f3")) {
            return s.replace("\u00f3", "\u00f6");
        }
        if (s.contains("\u00fa")) {
            return s.replace("\u00fa", "\u00f9");
        }
        if (s.contains("\u00e0")) {
            return s.replace("\u00e0", "\u00e4");
        }
        if (s.contains("\u00e8")) {
            return s.replace("\u00e8", "\u00eb");
        }
        if (s.contains("\u00ec")) {
            return s.replace("\u00ec", "i");
        }
        if (s.contains("\u00f2")) {
            return s.replace("\u00f2", "\u00f6");
        }
        if (s.contains("\u00ef")) {
            return s.replace("\u00ef", "\u00ec");
        }
        if (s.contains("\u00fc")) {
            return s.replace("\u00fc", "\u00f9");
        }
        return s + "-";
    }

    public static String removeTashkeel(String str) {
        String striped = str.replaceAll("[\u064b\u064c\u064d\u064e\u064f\u0650\u0651\u0652\u0653\u0654\u0655\u0656\u0640]", "");
        return striped;
    }

    public static boolean isNotWordString(String input) {
        return NOT_WORD_STR.matcher(input).matches();
    }

    public static int numberOf(String s, String t) {
        return s.length() - s.replaceAll(t, "").length();
    }

    public static String convertToTitleCaseIteratingChars(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return text2;
        }
        StringBuilder converted = new StringBuilder();
        boolean convertNext = true;
        for (char ch : text2.toCharArray()) {
            if (Character.isSpaceChar(ch) || ch == '-') {
                convertNext = true;
            } else if (convertNext) {
                ch = Character.toTitleCase(ch);
                convertNext = false;
            } else {
                ch = Character.toLowerCase(ch);
            }
            converted.append(ch);
        }
        return converted.toString();
    }

    public static boolean isEmoji(String word) {
        if (word.length() > 1 && word.codePointCount(0, word.length()) != word.length()) {
            return !WORD_FOR_SPELLER.matcher(word).matches();
        }
        return false;
    }

    public static String stringForSpeller(String s) {
        if (s.length() > 1 && s.codePointCount(0, s.length()) != s.length()) {
            Matcher matcher = CHARS_NOT_FOR_SPELLING.matcher(s);
            while (matcher.find()) {
                String found = matcher.group(0);
                s = s.replace(found, WHITESPACE_ARRAY[found.length()]);
            }
        }
        return s;
    }

    public static String[] splitCamelCase(String input) {
        if (StringTools.isAllUppercase(input)) {
            return new String[]{input};
        }
        StringBuilder word = new StringBuilder();
        StringBuilder result2 = new StringBuilder();
        boolean previousIsUppercase = false;
        for (int i = 0; i < input.length(); ++i) {
            char currentChar = input.charAt(i);
            if (Character.isUpperCase(currentChar)) {
                if (!previousIsUppercase) {
                    result2.append((CharSequence)word).append(" ");
                    word.setLength(0);
                }
                previousIsUppercase = true;
            } else {
                previousIsUppercase = false;
            }
            word.append(currentChar);
        }
        result2.append((CharSequence)word);
        return result2.toString().trim().split(" ");
    }

    public static String[] splitDigitsAtEnd(String input) {
        int lastIndex;
        for (lastIndex = input.length() - 1; lastIndex >= 0 && Character.isDigit(input.charAt(lastIndex)); --lastIndex) {
        }
        String nonDigitPart = input.substring(0, lastIndex + 1);
        String digitPart = input.substring(lastIndex + 1);
        if (!nonDigitPart.isEmpty() && !digitPart.isEmpty()) {
            return new String[]{nonDigitPart, digitPart};
        }
        return new String[]{input};
    }

    public static boolean isAnagram(String string1, String string2) {
        if (string1.length() != string2.length()) {
            return false;
        }
        char[] charArray1 = string1.toCharArray();
        char[] charArray2 = string2.toCharArray();
        Arrays.sort(charArray1);
        Arrays.sort(charArray2);
        return Arrays.equals(charArray1, charArray2);
    }

    public static boolean isNumeric(String string2) {
        return IS_NUMERIC.matcher(string2).matches();
    }

    static {
        for (int i = 0; i < 20; ++i) {
            StringTools.WHITESPACE_ARRAY[i] = StringUtils.repeat((char)' ', (int)i);
        }
        CHARS_NOT_FOR_SPELLING = Pattern.compile("[^\\p{L}\\d\\p{P}\\p{Zs}]");
        XML_COMMENT_PATTERN = Pattern.compile("<!--.*?-->", 32);
        XML_PATTERN = Pattern.compile("(?<!<)<[^<>]+>", 32);
        PUNCTUATION_PATTERN = Pattern.compile("[\\p{IsPunctuation}']", 32);
        NOT_WORD_CHARACTER = Pattern.compile("[^\\p{L}]", 32);
        NOT_WORD_STR = Pattern.compile("[^\\p{L}]+", 32);
        PATTERN = Pattern.compile("(?U)[^\\p{Space}\\p{Alnum}\\p{Punct}]");
        DIACRIT_MARKS = Pattern.compile("[\\p{InCombiningDiacriticalMarks}]");
        ENGLISH_TITLECASE_EXCEPTIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("of", "in", "on", "the", "a", "an", "and", "or")));
        PORTUGUESE_TITLECASE_EXCEPTIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("e", "ou", "que", "de", "do", "dos", "da", "das", "o", "a", "os", "as", "no", "nos", "na", "nas", "ao", "aos", "\u00e0", "\u00e0s")));
        FRENCH_TITLECASE_EXCEPTIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("et", "ou", "que", "qui", "de", "du", "des", "en", "le", "les", "la", "un", "une", "\u00e0", "au", "aux")));
        SPANISH_TITLECASE_EXCEPTIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("y", "e", "o", "u", "que", "el", "la", "los", "las", "un", "unos", "una", "unas", "del", "nel", "de", "en", "a", "al")));
        GERMAN_TITLECASE_EXCEPTIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("von", "in", "im", "an", "am", "vom", "und", "oder", "dass", "ob", "der", "die", "das", "dem", "den", "des", "ein", "eines", "einem", "einen", "einer", "eine", "kein", "keines", "keinem", "keinen", "keiner", "keine")));
        DUTCH_TITLECASE_EXCEPTIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("van", "in", "de", "het", "een", "en", "of")));
        ALL_TITLECASE_EXCEPTIONS = StringTools.collectAllTitleCaseExceptions();
    }

    public static enum ApiPrintMode {
        NORMAL_API,
        START_API,
        END_API,
        CONTINUE_API;

    }
}

