/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.LineExpander;

public class CompoundRuleData {
    private final Set<String> incorrectCompounds = new ObjectOpenHashSet();
    private final Set<String> joinedSuggestion = new ObjectOpenHashSet();
    private final Set<String> joinedLowerCaseSuggestion = new ObjectOpenHashSet();
    private final Set<String> dashSuggestion = new ObjectOpenHashSet();
    private final LineExpander expander;

    public CompoundRuleData(String path) {
        this(new String[]{path});
    }

    public CompoundRuleData(String ... paths) {
        this((LineExpander)null, paths);
    }

    public CompoundRuleData(LineExpander expander, String ... paths) {
        this.expander = expander;
        for (String path : paths) {
            try {
                this.loadCompoundFile(path);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load compound data from " + path, e);
            }
        }
    }

    public Set<String> getIncorrectCompounds() {
        return Collections.unmodifiableSet(this.incorrectCompounds);
    }

    public Set<String> getJoinedSuggestion() {
        return Collections.unmodifiableSet(this.joinedSuggestion);
    }

    public Set<String> getDashSuggestion() {
        return Collections.unmodifiableSet(this.dashSuggestion);
    }

    public Set<String> getJoinedLowerCaseSuggestion() {
        return Collections.unmodifiableSet(this.joinedLowerCaseSuggestion);
    }

    /*
     * WARNING - void declaration
     */
    private void loadCompoundFile(String path) throws IOException {
        List<String> lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(path);
        for (String line : lines) {
            if (line.isEmpty() || line.startsWith("#")) continue;
            line = line.replaceFirst("#.*$", "").trim();
            List<Object> expandedLines = new ArrayList<String>();
            if (this.expander != null) {
                expandedLines = this.expander.expandLine(line);
            } else {
                expandedLines.add(line);
            }
            for (String string2 : expandedLines) {
                void var7_7;
                String string3 = string2.replace('-', ' ');
                this.validateLine(path, string3);
                if (string3.endsWith("+")) {
                    String string4 = this.removeLastCharacter(string3);
                    this.joinedSuggestion.add(string4);
                } else if (string3.endsWith("*")) {
                    String string5 = this.removeLastCharacter(string3);
                    this.dashSuggestion.add(string5);
                } else if (string3.endsWith("?")) {
                    String string6 = this.removeLastCharacter(string3);
                    this.joinedSuggestion.add(string6);
                    this.joinedLowerCaseSuggestion.add(string6);
                } else if (string3.endsWith("$")) {
                    String string7 = this.removeLastCharacter(string3);
                    this.joinedSuggestion.add(string7);
                    this.dashSuggestion.add(string7);
                    this.joinedLowerCaseSuggestion.add(string7);
                } else {
                    this.joinedSuggestion.add(string3);
                    this.dashSuggestion.add(string3);
                }
                this.incorrectCompounds.add((String)var7_7);
            }
        }
    }

    private void validateLine(String path, String line) {
        String[] parts = line.split(" ");
        if (parts.length == 1) {
            throw new IllegalArgumentException("Not a compound in file " + path + ": " + line);
        }
        if (parts.length > 5) {
            throw new IllegalArgumentException("Too many compound parts in file " + path + ": " + line + ", maximum allowed: " + 5);
        }
        if (this.incorrectCompounds.contains(line.toLowerCase())) {
            throw new IllegalArgumentException("Duplicated word in file " + path + ": " + line);
        }
    }

    private String removeLastCharacter(String str) {
        return str.substring(0, str.length() - 1);
    }
}

