/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.logic;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import edu.washington.cs.knowitall.logic.Expression;
import edu.washington.cs.knowitall.logic.LogicException;
import edu.washington.cs.knowitall.logic.LogicExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class LogicExpressionParser<E>
implements Function<String, LogicExpression<E>> {
    public static final Pattern doubleQuoteStringLiteralRegex = Pattern.compile("\"([^\"\\p{Cntrl}\\\\]*+(?:\\\\[\\\\'\"bfnrt])*+(?:\\\\u[a-fA-F0-9]{4})*+)*+\"");
    public static final Pattern singleQuoteStringLiteralRegex = Pattern.compile("'(?:[^']*+)'");
    public static final Pattern regexLiteralRegex = Pattern.compile("/(?:(?:[^/\\\\]*+(?:\\\\)*+(?:\\\\/)*+)*+)/");
    private static final List<Pattern> literalPatterns = Lists.newArrayList((Object[])new Pattern[]{doubleQuoteStringLiteralRegex, singleQuoteStringLiteralRegex, regexLiteralRegex});

    public LogicExpression<E> parse(String string2) {
        List<Expression<E>> expressions = this.tokenize(string2);
        return new LogicExpression<E>(expressions);
    }

    public LogicExpression<E> apply(String string2) {
        return this.parse(string2);
    }

    public abstract Expression.Arg<E> factory(String var1);

    public String readToken(String remainder) {
        String token;
        try {
            int nextExpression;
            Stack<Character> parens = new Stack<Character>();
            for (nextExpression = 0; nextExpression < remainder.length(); ++nextExpression) {
                char c = remainder.charAt(nextExpression);
                String match = null;
                for (Pattern pattern : literalPatterns) {
                    Matcher matcher = pattern.matcher(remainder).region(nextExpression, remainder.length());
                    if (!matcher.lookingAt()) continue;
                    match = matcher.group(0);
                    break;
                }
                if (match != null) {
                    nextExpression += match.length() - 1;
                    continue;
                }
                if (c == '(') {
                    parens.push(Character.valueOf(c));
                    continue;
                }
                if (c == ')') {
                    if (parens.isEmpty()) break;
                    parens.pop();
                    continue;
                }
                if (c == '&' || c == '|') break;
            }
            token = remainder.substring(0, nextExpression).trim();
        }
        catch (Exception e) {
            throw new LogicException.TokenizeLogicException("Error parsing token: " + remainder, e);
        }
        if (token.isEmpty()) {
            throw new LogicException.TokenizeLogicException("zero-length token found.");
        }
        return token;
    }

    public List<Expression<E>> tokenize(String input) throws LogicException.TokenizeLogicException {
        ArrayList<Expression<Expression>> tokens = new ArrayList<Expression<Expression>>();
        int i = 0;
        while (i < input.length()) {
            String substring = input.substring(i);
            char firstChar = substring.charAt(0);
            if (firstChar == ' ') {
                ++i;
                continue;
            }
            if (firstChar == '(') {
                tokens.add(new Expression.Paren.L());
                ++i;
                continue;
            }
            if (firstChar == ')') {
                tokens.add(new Expression.Paren.R());
                ++i;
                continue;
            }
            if (firstChar == '!') {
                tokens.add(new Expression.Op.Mon.Not());
                ++i;
                continue;
            }
            if (firstChar == '&') {
                tokens.add(new Expression.Op.Bin.And());
                ++i;
                continue;
            }
            if (firstChar == '|') {
                tokens.add(new Expression.Op.Bin.Or());
                ++i;
                continue;
            }
            String token = this.readToken(substring);
            tokens.add(this.factory(token));
            i += token.length();
        }
        return tokens;
    }
}

